package org.mule.weave.v2.helper

import org.scalatest.Assertion
import org.scalatest.Succeeded

import java.util.concurrent.TimeUnit

class TestProbe(matcher: () => Assertion, amount: Int = 10, wait: Long = 500, timeUnit: TimeUnit = TimeUnit.MILLISECONDS) {

  def verify(): Assertion = {
    var i = 0
    var failing = true
    while (i < amount && failing) {
      val triedFunction = matcher()
      if (triedFunction eq Succeeded) {
        return triedFunction
      }
      Thread.sleep(timeUnit.toMinutes(wait))
      i = i + 1
    }
    matcher()
  }

}
