package org.mule.weave.v2.helper

import java.io.File
import org.mule.weave.v2.matchers.WeaveMatchers._
import org.scalatest.Assertion
import org.scalatest.funspec.AnyFunSpec
import org.scalatest.matchers.should.Matchers

import scala.io.Source.fromFile
import scala.util.Try

trait SimpleTextBasedTest extends AnyFunSpec with Matchers with FileBasedTest with ParsingContextTestAware {
  scenarios.foreach {
    case (fileName, testFile, expectedFile) =>
      it(fileName) {
        val expected = fileToString(expectedFile)
        val actual: String = runTest(testFile)
        if (shouldUpdateResult) {
          if (doesNotMatch(expected, actual)) {
            updateExpectedFileWith(expectedFile, actual)
          }
        }
        assertMatchesWith(actual, expected)
      }
  }

  private def doesNotMatch(expected: String, actual: String) = {
    Try(assertMatchesWith(actual, expected)).isFailure
  }

  def assertMatchesWith(actual: String, expected: String): Assertion = {
    if (isExpectedJson) {
      actual should matchJson(expected)
    } else {
      actual.trim should matchString(expected.trim)
    }
  }

  def isExpectedJson: Boolean = {
    expectedExtension.equals(".json")
  }

  def runTest(testFile: File): String

}
