package org.mule.weave.v2.api.tooling.ast

import java.util.Optional

/**
  * Allows to create a [[DWAstNode]] from scripts.
  */
trait DWAstNodeFactory {

  /**
    * For the given script content it will parse it and create the [[DWAstNode]] if possible.
    *
    * Be aware that the script should be syntactically correct and the parser will not resolve scope neither type
    * checking phase, therefore the [[DWAstNode.getReference]] or [[DWAstNode.getTypeOf]] will not be populated.
    * @param content a script to be parsed.
    * @return [[DWAstNode]] that represents the script parsed. Could be empty if the script has compilation issues.
    */
  def parse(content: String): Optional[DWAstNode]

}
