/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.maven.plugin;

import java.util.Map;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class WeaveRunnerExecutor {
    private MavenProject project;
    private Log log;

    public WeaveRunnerExecutor(MavenProject project, Log log) {
        this.project = project;
        this.log = log;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public Log getLog() {
        return this.log;
    }

    public boolean execute(String classpath, String[] args, Map<String, String> environmentVariables, Map<String, String> systemProperties, String argLine, boolean logForkedProcessCommand, boolean jvmDebug) throws MojoFailureException {
        Commandline cli = new Commandline();
        cli.setWorkingDirectory(this.project.getBasedir());
        cli.setExecutable("java");
        if (environmentVariables != null) {
            for (Map.Entry<String, String> entry : environmentVariables.entrySet()) {
                cli.addEnvironment(entry.getKey(), entry.getValue());
            }
        }
        cli.addEnvironment("CLASSPATH", classpath);
        if (systemProperties != null) {
            for (Map.Entry<String, String> entry : systemProperties.entrySet()) {
                cli.createArg().setValue(String.format("-D%s=%s", entry.getKey(), entry.getValue()));
            }
        }
        if (jvmDebug) {
            cli.createArg().setValue("-agentlib:jdwp=transport=dt_socket,server=y,suspend=n,address=5005");
        }
        cli.createArg().setValue(String.format("-Dbasedir=%s", this.project.getBasedir().getAbsolutePath()));
        if (argLine != null) {
            cli.createArg().setLine(argLine);
        }
        cli.createArg().setValue("org.mule.weave.v2.runtime.utils.WeaveRunner");
        for (String arg : args) {
            cli.createArg().setValue(arg);
        }
        String commandLogStatement = "Forking ScalaTest via: " + cli;
        if (logForkedProcessCommand) {
            this.getLog().info((CharSequence)commandLogStatement);
        } else {
            this.getLog().debug((CharSequence)commandLogStatement);
        }
        StreamConsumer streamConsumer = line -> System.out.println(line);
        try {
            int result = CommandLineUtils.executeCommandLine((Commandline)cli, (StreamConsumer)streamConsumer, (StreamConsumer)streamConsumer);
            return result == 0;
        }
        catch (CommandLineException e) {
            throw new MojoFailureException("Exception while executing forked process.", (Throwable)e);
        }
    }
}

