/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.maven.plugin;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.mule.weave.maven.plugin.MojoUtils;
import org.mule.weave.maven.plugin.WeaveRunnerExecutor;

public class WeaveTestMojo
extends AbstractMojo {
    MavenProject project;
    File reportsDirectory;
    File testOutputDirectory;
    File dwTestDirectory;
    File dwITDirectory;
    File outputDirectory;
    boolean debug;
    Map<String, String> environmentVariables;
    Map<String, String> systemProperties;
    String argLine;
    boolean logForkedProcessCommand;
    boolean jvmDebug;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            ArrayList<String> dwITArgs = new ArrayList<String>();
            if (this.dwITDirectory.getCanonicalFile().exists()) {
                if (this.systemProperties == null) {
                    this.systemProperties = new HashMap<String, String>();
                }
                this.systemProperties.put("dwitDir", this.dwITDirectory.getCanonicalPath());
                dwITArgs.add("-test");
                dwITArgs.add("dw::test::DWITTestRunner");
            }
            WeaveRunnerExecutor executor = new WeaveRunnerExecutor(this.project, this.getLog());
            executor.execute(this.buildClassPathEnvironment(), MojoUtils.concat(this.testMode(), dwITArgs, this.testsDirectories(), this.reports()), this.environmentVariables, this.systemProperties, this.argLine, this.logForkedProcessCommand, this.jvmDebug);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error", e);
        }
    }

    public String buildClassPathEnvironment() {
        StringBuffer buf = new StringBuffer();
        boolean first = true;
        for (String e : this.testClasspathElements()) {
            if (first) {
                first = false;
            } else {
                buf.append(File.pathSeparator);
            }
            buf.append(e);
        }
        return buf.toString();
    }

    public List<String> testClasspathElements() {
        try {
            return this.project.getTestClasspathElements();
        }
        catch (DependencyResolutionRequiredException e) {
            throw new IllegalStateException("Dependency resolution should be test-scoped.", e);
        }
    }

    private List<String> testMode() {
        return Collections.singletonList("--wtest");
    }

    private List<String> testsDirectories() throws IOException {
        return MojoUtils.compoundArg("-R", this.dwTestDirectory.getCanonicalPath());
    }

    private List<String> reports() throws IOException {
        return Arrays.asList("-r", "junit=" + this.reportsDirectory.getCanonicalPath(), "-r", "json=" + this.reportsDirectory.getCanonicalPath());
    }
}

