/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.maven.plugin;

import java.io.File;
import java.io.IOException;
import java.util.Optional;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;
import org.mule.weave.v2.parser.DocumentParser;
import org.mule.weave.v2.parser.Message;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.parser.location.WeaveLocation;
import org.mule.weave.v2.parser.phase.ParsingContext;
import org.mule.weave.v2.parser.phase.PhaseResult;
import org.mule.weave.v2.sdk.ParsingContextFactory;
import org.mule.weave.v2.sdk.WeaveResourceFactory;
import scala.Option;
import scala.Tuple2;
import scala.collection.Iterator;

@Mojo(name="compile", defaultPhase=LifecyclePhase.COMPILE, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, executionStrategy="always")
@Execute(goal="compile")
public class DataWeaveCompileMojo
extends AbstractMojo {
    @Parameter(property="project", required=true, readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${project.build.sourceDirectory}/../dw", required=true, readonly=true)
    private File sourceDir;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)("Start Compiling DataWeave " + this.project.getName()));
        int numberOfError = this.validate(this.sourceDir, "");
        if (numberOfError > 0) {
            throw new MojoFailureException("Compilation failure.  " + numberOfError + " errors found.");
        }
    }

    private int validate(File sourceDir, String name) {
        File[] child;
        int errors = 0;
        for (File f : child = Optional.ofNullable(sourceDir.listFiles()).orElse(new File[0])) {
            this.getLog().info((CharSequence)("Compiling " + f.getAbsolutePath()));
            if ("dwl".equals(FileUtils.extension((String)f.getName()))) {
                String basename = FileUtils.basename((String)f.getName());
                errors += this.parse(NameIdentifier.apply((String)this.nameIdentifier(name, basename), (Option)Option.empty()), f);
                continue;
            }
            if (!f.isDirectory()) continue;
            this.validate(f, this.nameIdentifier(name, f.getName()));
        }
        return errors;
    }

    private String nameIdentifier(String name, String moduleName) {
        if (name.isEmpty()) {
            return moduleName;
        }
        return name + NameIdentifier.SEPARATOR() + moduleName;
    }

    public int parse(NameIdentifier identifier, File file) {
        DocumentParser documentParser = new DocumentParser(15);
        ParsingContext parsingContext = ParsingContextFactory.createParsingContext((NameIdentifier)identifier);
        PhaseResult parse = documentParser.parse(WeaveResourceFactory.fromFile((File)file), parsingContext);
        Iterator errors = parse.messages().errorMessages().toIterator();
        while (errors.hasNext()) {
            Tuple2 next = (Tuple2)errors.next();
            WeaveLocation weaveLocation = (WeaveLocation)next._1;
            this.getLog().error((CharSequence)(((Message)next._2).message() + " at " + weaveLocation.locationString()));
            try {
                this.getLog().error((CharSequence)(file.getCanonicalPath() + ":[" + weaveLocation.startPosition().line() + "," + weaveLocation.startPosition().column() + "]"));
            }
            catch (IOException iOException) {}
        }
        Iterator warnings = parse.messages().warningMessages().toIterator();
        while (warnings.hasNext()) {
            Tuple2 next = (Tuple2)warnings.next();
            WeaveLocation weaveLocation = (WeaveLocation)next._1;
            this.getLog().warn((CharSequence)(((Message)next._2).message() + " at " + weaveLocation.locationString()));
            try {
                this.getLog().warn((CharSequence)(file.getCanonicalPath() + ":[" + weaveLocation.startPosition().line() + "," + weaveLocation.startPosition().column() + "]"));
            }
            catch (IOException iOException) {}
        }
        return parse.errorMessages().length();
    }
}

