/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.maven.plugin;

import com.mulesoft.weave.docs.DocTemplateBundle;
import com.mulesoft.weave.docs.DocTemplateBundles;
import com.mulesoft.weave.docs.WeaveDocsGenerator;
import java.io.File;
import java.io.IOException;
import java.util.Optional;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="weavedoc", defaultPhase=LifecyclePhase.GENERATE_SOURCES, threadSafe=true)
@Execute(goal="weavedoc")
public class WeaveDocsMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.build.sourceDirectory}/../dw", required=true, readonly=true)
    private File sourceFolder;
    @Parameter(defaultValue="${project.build.outputDirectory}/../weavedocs", required=true, readonly=true)
    private File outputDocs;
    @Parameter(required=false, readonly=true)
    private File moduleDocsPath;
    @Parameter(defaultValue="markdown")
    private String template;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            File canonicalFile = this.outputDocs.getCanonicalFile();
            this.getLog().info((CharSequence)("Generating docs at :" + canonicalFile));
            if (!this.outputDocs.exists()) {
                this.outputDocs.mkdirs();
            }
            Optional<File> maybeModuleDocsPath = Optional.ofNullable(this.moduleDocsPath);
            DocTemplateBundle docTemplateBundleOption = DocTemplateBundles.templateByName((String)this.template, (DocTemplateBundle)DocTemplateBundles.markdown());
            WeaveDocsGenerator.generate((DocTemplateBundle)docTemplateBundleOption, (File)this.sourceFolder, (File)canonicalFile, maybeModuleDocsPath);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Exception while resolving.", (Exception)e);
        }
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public void setSourceFolder(File sourceFolder) {
        this.sourceFolder = sourceFolder;
    }

    public void setOutputDocs(File outputDocs) {
        this.outputDocs = outputDocs;
    }
}

