/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.maven.plugin;

import com.mulesoft.weave.docs.AnypointAPIHelper;
import com.mulesoft.weave.docs.Logger;
import java.io.File;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.DeploymentRepository;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.settings.crypto.SettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecryptionResult;
import org.mule.exchange.utils.ExchangeUtils;

@Mojo(name="deploy-docs", defaultPhase=LifecyclePhase.DEPLOY)
@Execute(goal="deploy-docs")
public class DeployDocsMojo
extends AbstractMojo {
    @Parameter(property="project", required=true, readonly=true)
    MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Parameter(defaultValue="${project.build.outputDirectory}/../weavedocs/markdown", required=true, readonly=true)
    private File outputDocs;
    @Parameter(required=false, readonly=true)
    private File faviconPath;
    private static final Pattern exchangeAnypointDomain;
    @Component
    SettingsDecrypter decrypter;

    public void execute() {
        if (Boolean.getBoolean("skipDeployDocs")) {
            this.getLog().warn((CharSequence)"Skipping Deploy of the WeaveDocs.");
            return;
        }
        DeploymentRepository repository = this.project.getDistributionManagement().getRepository();
        String url = repository.getUrl();
        Matcher matcher = exchangeAnypointDomain.matcher(url);
        Optional<File> maybeFavicon = Optional.ofNullable(this.faviconPath);
        if (matcher.find()) {
            String anypointUrl = "https://" + matcher.group("baseUri");
            AnypointAPIHelper anypointAPIHelper = new AnypointAPIHelper(anypointUrl);
            Settings settings = this.loadDefaultUserSettings();
            if (settings != null) {
                Server server = settings.getServer(repository.getId());
                if (server != null) {
                    this.getLog().info((CharSequence)("Deploying: `" + this.outputDocs.getAbsolutePath() + "` to : `" + anypointUrl + "`"));
                    Server decryptedServer = this.decrypt(server);
                    String username = decryptedServer.getUsername();
                    String password = decryptedServer.getPassword();
                    String token = anypointAPIHelper.login(username, password);
                    Logger logger = new Logger(){

                        public void logInfo(String message) {
                            DeployDocsMojo.this.getLog().info((CharSequence)message);
                        }

                        public void logWarning(String message) {
                            DeployDocsMojo.this.getLog().warn((CharSequence)message);
                        }

                        public void logError(String message) {
                            DeployDocsMojo.this.getLog().error((CharSequence)message);
                        }
                    };
                    anypointAPIHelper.uploadPortalPages(this.outputDocs, this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion(), this.project.getDescription(), maybeFavicon, token, logger);
                    this.getLog().info((CharSequence)("Deployed successful to: `" + anypointUrl + "`"));
                } else {
                    this.getLog().warn((CharSequence)"Ignoring deploy docs as server was not found");
                }
            }
        } else {
            this.getLog().warn((CharSequence)("Unable to find anypoint url from " + url));
        }
    }

    private Settings loadDefaultUserSettings() {
        return this.session.getSettings();
    }

    private Server decrypt(Server server) {
        DefaultSettingsDecryptionRequest decryptionRequest = new DefaultSettingsDecryptionRequest(server);
        SettingsDecryptionResult decryptedResult = this.decrypter.decrypt((SettingsDecryptionRequest)decryptionRequest);
        return decryptedResult.getServer();
    }

    static {
        ExchangeUtils.installPatchMethod();
        exchangeAnypointDomain = Pattern.compile("https://maven\\.(?<baseUri>.*anypoint\\.mulesoft\\.com)");
    }
}

