/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.maven.plugin;

import java.io.File;
import java.util.List;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="initialize", executionStrategy="always", defaultPhase=LifecyclePhase.INITIALIZE, threadSafe=true)
@Execute(goal="initialize")
public class WeaveProjectInitializeMojo
extends AbstractMojo {
    @Parameter(property="project", required=true, readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${project.build.sourceDirectory}/../dw", required=true, readonly=true)
    private File sourceDir;
    @Parameter(defaultValue="${project.build.testSourceDirectory}/../dwmit", required=true, readonly=true)
    private File dwModuleIntegrationTest;
    @Parameter(defaultValue="${project.build.testSourceDirectory}/../dwit", required=true, readonly=true)
    private File dwIntegrationTest;
    @Parameter(defaultValue="${project.build.testSourceDirectory}/../dwtest", required=true, readonly=true)
    private File dwTest;
    @Parameter(property="maven.scala.useCanonicalPath", defaultValue="true")
    private boolean useCanonicalPath;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            String path;
            if (this.sourceDir != null && this.sourceDir.exists() && this.resourceNotDefined(path = WeaveProjectInitializeMojo.pathOf(this.sourceDir, this.useCanonicalPath), this.project.getResources())) {
                this.getLog().debug((CharSequence)("Add Source directory: " + path));
                Resource resource = new Resource();
                resource.setDirectory(path);
                this.project.addResource(resource);
            }
            if (this.dwModuleIntegrationTest != null && this.dwModuleIntegrationTest.exists()) {
                path = WeaveProjectInitializeMojo.pathOf(this.dwModuleIntegrationTest, this.useCanonicalPath);
                this.defineTestResourceIfMissing(path);
            }
            if (this.dwIntegrationTest != null && this.dwIntegrationTest.exists()) {
                path = WeaveProjectInitializeMojo.pathOf(this.dwIntegrationTest, this.useCanonicalPath);
                this.defineTestResourceIfMissing(path);
            }
            if (this.dwTest != null && this.dwTest.exists()) {
                path = WeaveProjectInitializeMojo.pathOf(this.dwTest, this.useCanonicalPath);
                this.defineTestResourceIfMissing(path);
            }
        }
        catch (Exception exc) {
            throw new MojoExecutionException("Error while running initialize.", exc);
        }
    }

    private void defineTestResourceIfMissing(String path) {
        List testResources = this.project.getTestResources();
        if (this.resourceNotDefined(path, testResources)) {
            this.getLog().debug((CharSequence)("Add Test Source directory: " + path));
            Resource testResource = new Resource();
            testResource.setDirectory(path);
            this.project.addTestResource(testResource);
        }
    }

    private boolean resourceNotDefined(String path, List<Resource> testResources) {
        return testResources.stream().noneMatch(r -> r.getDirectory().equals(path));
    }

    static String pathOf(File f, boolean canonical) throws Exception {
        return canonical ? f.getCanonicalPath() : f.getAbsolutePath();
    }
}

