/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.maven.plugin;

import java.io.File;
import java.util.Arrays;
import java.util.Map;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.shared.model.fileset.FileSet;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.jar.JarArchiver;

@Mojo(name="package", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
@Execute(goal="package")
public class WeavePackagerMojo
extends AbstractMojo {
    public static final String ARTIFACT_TYPE = "jar";
    public static final String ARTIFACT_CLASSIFIER = "dw-library";
    @Parameter(defaultValue="${project.build.directory}", required=true, readonly=true)
    File outputDirectory;
    @Parameter(defaultValue="${project.build.finalName}", readonly=true)
    String finalName;
    @Component
    Map<String, Archiver> archivers;
    @Parameter(property="project", required=true, readonly=true)
    MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    MavenSession session;
    @Parameter(defaultValue="${project.build.outputDirectory}", required=true)
    File classesDirectory;
    MavenArchiveConfiguration archive = new MavenArchiveConfiguration();
    @Component
    private ArtifactHandlerManager artifactHandlerManager;
    @Component
    MavenProjectHelper projectHelper;

    protected File getJarFile(File basedir, String resultFinalName, String classifier) {
        if (basedir == null) {
            throw new IllegalArgumentException("basedir is not allowed to be null");
        }
        if (resultFinalName == null) {
            throw new IllegalArgumentException("finalName is not allowed to be null");
        }
        String fileName = resultFinalName + "-" + classifier + ".jar";
        return new File(basedir, fileName);
    }

    public File createArchive() throws MojoExecutionException {
        String[] includes = new String[]{"**/**"};
        String[] excludes = new String[]{"**/package.html"};
        File jarFile = this.getJarFile(this.outputDirectory, this.finalName, ARTIFACT_CLASSIFIER);
        FileSet jarContentFileSet = new FileSet();
        jarContentFileSet.setDirectory(this.classesDirectory.getAbsolutePath());
        jarContentFileSet.setIncludes(Arrays.asList(includes));
        jarContentFileSet.setExcludes(Arrays.asList(excludes));
        MavenArchiver archiver = new MavenArchiver();
        archiver.setArchiver((JarArchiver)this.archivers.get(ARTIFACT_TYPE));
        archiver.setOutputFile(jarFile);
        this.archive.setForced(true);
        try {
            File contentDirectory = this.classesDirectory;
            if (!contentDirectory.exists()) {
                this.getLog().warn((CharSequence)"JAR will be empty - no content was marked for inclusion!");
            } else {
                archiver.getArchiver().addDirectory(contentDirectory, includes, excludes);
            }
            archiver.createArchive(this.session, this.project, this.archive);
            return jarFile;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error creating weave ", e);
        }
    }

    public void execute() throws MojoExecutionException {
        File jarFile = this.createArchive();
        ArtifactHandler handler = this.artifactHandlerManager.getArtifactHandler(ARTIFACT_TYPE);
        DefaultArtifact artifact = new DefaultArtifact(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion(), null, ARTIFACT_TYPE, ARTIFACT_CLASSIFIER, handler);
        artifact.setFile(jarFile);
        artifact.setResolved(true);
        this.project.setArtifact((Artifact)artifact);
    }
}

