/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.maven.plugin;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.mule.weave.maven.plugin.MojoUtils;
import org.mule.weave.maven.plugin.WeaveRunnerExecutor;

@Mojo(name="test", defaultPhase=LifecyclePhase.TEST, requiresDependencyCollection=ResolutionScope.TEST, requiresDependencyResolution=ResolutionScope.TEST)
@Execute(goal="test")
public class WeaveTestMojo
extends AbstractMojo {
    @Parameter(property="project", required=true, readonly=true)
    MavenProject project;
    @Parameter(defaultValue="${project.build.directory}/weavetest-reports", required=true, readonly=false)
    File reportsDirectory;
    @Parameter(defaultValue="${project.build.testSourceDirectory}/../dwtest", required=true, readonly=true)
    File dwTestDirectory;
    @Parameter(defaultValue="${project.build.testSourceDirectory}/../dwit", required=true, readonly=true)
    File dwITDirectory;
    @Parameter(defaultValue="${project.build.testSourceDirectory}/../dwmit", required=true, readonly=true)
    File dwmITDirectory;
    @Parameter
    Map<String, String> environmentVariables;
    @Parameter
    Map<String, String> systemProperties;
    @Parameter
    String argLine;
    @Parameter(defaultValue="true")
    Boolean htmlReport;
    @Parameter(defaultValue="false")
    boolean logForkedProcessCommand;
    @Parameter(defaultValue="false")
    boolean jvmDebug;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (System.getProperty("skipTests") != null) {
            this.getLog().warn((CharSequence)"Skipping Weave Tests.");
            return;
        }
        try {
            ArrayList<String> dwITArgs = new ArrayList<String>();
            if (this.dwITDirectory.getCanonicalFile().exists()) {
                if (this.systemProperties == null) {
                    this.systemProperties = new HashMap<String, String>();
                }
                this.systemProperties.put("dwitDir", this.dwITDirectory.getCanonicalPath());
                dwITArgs.add("-test");
                dwITArgs.add("dw::test::DWITTestRunner");
            }
            if (this.dwmITDirectory.getCanonicalFile().exists()) {
                if (this.systemProperties == null) {
                    this.systemProperties = new HashMap<String, String>();
                }
                this.systemProperties.put("dwmitDir", this.dwmITDirectory.getCanonicalPath());
                dwITArgs.add("-test");
                dwITArgs.add("dw::test::DWMITTestRunner");
            }
            WeaveRunnerExecutor executor = new WeaveRunnerExecutor(this.project, this.getLog());
            boolean sucess = executor.execute(this.buildClassPathEnvironment(), MojoUtils.concat(this.testMode(), dwITArgs, this.testsDirectories(), this.reports(), this.aggregators()), this.environmentVariables, this.systemProperties, this.argLine, this.logForkedProcessCommand, this.jvmDebug);
            if (!sucess) {
                throw new MojoFailureException("Tests Failed");
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error", e);
        }
    }

    public String buildClassPathEnvironment() {
        StringBuffer buf = new StringBuffer();
        boolean first = true;
        for (String e : this.testClasspathElements()) {
            if (first) {
                first = false;
            } else {
                buf.append(File.pathSeparator);
            }
            buf.append(e);
        }
        return buf.toString();
    }

    public List<String> testClasspathElements() {
        try {
            return this.project.getTestClasspathElements();
        }
        catch (DependencyResolutionRequiredException e) {
            throw new IllegalStateException("Dependency resolution should be test-scoped.", e);
        }
    }

    private List<String> testMode() {
        return Collections.singletonList("--wtest");
    }

    private List<String> testsDirectories() throws IOException {
        return MojoUtils.compoundArg("-R", this.dwTestDirectory.getCanonicalPath());
    }

    private List<String> reports() throws IOException {
        return Arrays.asList("-r", "junit=" + this.reportsDirectory.getCanonicalPath(), "-r", "json=" + this.reportsDirectory.getCanonicalPath());
    }

    private List<String> aggregators() throws IOException {
        return this.htmlReport != false ? Arrays.asList("-a", "html=" + this.reportsDirectory.getCanonicalPath()) : Collections.emptyList();
    }
}

