/*
 * Decompiled with CFR 0.152.
 */
package org.weave;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.function.BiConsumer;
import org.mule.weave.v2.env.ServiceProvider;
import org.mule.weave.v2.env.StaticServiceProvider;
import org.mule.weave.v2.env.WeaveRuntime$;
import org.mule.weave.v2.interpreted.DefaultModuleNodeLoader;
import org.mule.weave.v2.interpreted.InterpreterMappingCompilerPhase;
import org.mule.weave.v2.interpreted.ModuleNodeLoader;
import org.mule.weave.v2.interpreted.extension.MultiWeaveResourceResolver;
import org.mule.weave.v2.interpreted.extension.ParsingContextCreator$;
import org.mule.weave.v2.interpreted.extension.WeaveBasedDataFormatExtensionLoaderService;
import org.mule.weave.v2.interpreted.extension.WeaveBasedDataFormatExtensionLoaderService$;
import org.mule.weave.v2.interpreted.module.WeaveWriter$;
import org.mule.weave.v2.interpreted.module.WeaveWriterSettings;
import org.mule.weave.v2.io.FileHelper$;
import org.mule.weave.v2.model.EvaluationContext;
import org.mule.weave.v2.model.EvaluationContext$;
import org.mule.weave.v2.model.ServiceManager;
import org.mule.weave.v2.model.ServiceManager$;
import org.mule.weave.v2.model.ServiceRegistration;
import org.mule.weave.v2.model.service.LoggingService;
import org.mule.weave.v2.model.service.StdOutputLoggingService$;
import org.mule.weave.v2.module.CompositeDataFormatExtensionsLoaderService$;
import org.mule.weave.v2.module.DataFormat;
import org.mule.weave.v2.module.DataFormatExtensionsLoaderService;
import org.mule.weave.v2.module.DataFormatManager$;
import org.mule.weave.v2.module.DefaultDataFormatExtensionsLoaderService$;
import org.mule.weave.v2.module.csv.CSVDataFormat;
import org.mule.weave.v2.module.json.JsonDataFormat;
import org.mule.weave.v2.module.multipart.MultiPartDataFormat;
import org.mule.weave.v2.module.native.NativeValueProvider;
import org.mule.weave.v2.module.octetstream.OctetStreamDataFormat;
import org.mule.weave.v2.module.properties.PropertiesDataFormat;
import org.mule.weave.v2.module.reader.FileSourceProvider;
import org.mule.weave.v2.module.reader.Reader;
import org.mule.weave.v2.module.reader.SourceProvider;
import org.mule.weave.v2.module.reader.SourceProvider$;
import org.mule.weave.v2.module.textplain.TextPlainDataFormat;
import org.mule.weave.v2.module.writer.Writer;
import org.mule.weave.v2.module.xml.XmlDataFormat;
import org.mule.weave.v2.module.yaml.YamlDataFormat;
import org.mule.weave.v2.parser.MappingParser$;
import org.mule.weave.v2.parser.Message;
import org.mule.weave.v2.parser.MessageCollector;
import org.mule.weave.v2.parser.ast.AstNode;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier$;
import org.mule.weave.v2.parser.exception.LocatableException;
import org.mule.weave.v2.parser.location.WeaveLocation;
import org.mule.weave.v2.parser.phase.AstNodeResultAware;
import org.mule.weave.v2.parser.phase.ModuleLoader;
import org.mule.weave.v2.parser.phase.ModuleLoader$;
import org.mule.weave.v2.parser.phase.ModuleLoaderManager;
import org.mule.weave.v2.parser.phase.ModuleLoaderManager$;
import org.mule.weave.v2.parser.phase.ModuleParserManager;
import org.mule.weave.v2.parser.phase.ModuleParserManager$;
import org.mule.weave.v2.parser.phase.ParsingContext;
import org.mule.weave.v2.parser.phase.ParsingContext$;
import org.mule.weave.v2.parser.phase.PhaseResult;
import org.mule.weave.v2.parser.phase.TypeCheckingResult;
import org.mule.weave.v2.runtime.CompilationResult;
import org.mule.weave.v2.runtime.ExecutableWeave;
import org.mule.weave.v2.runtime.core.SystemNativeValueProvider;
import org.mule.weave.v2.runtime.core.functions.ReadFunctionProtocolHandler;
import org.mule.weave.v2.runtime.core.functions.UrlProtocolHandler;
import org.mule.weave.v2.sdk.WeaveResource;
import org.mule.weave.v2.sdk.WeaveResource$;
import org.mule.weave.v2.sdk.WeaveResourceResolver;
import org.weave.AnsiColor$;
import org.weave.CustomWeaveDataFormat;
import org.weave.DataWeaveCli$delayedInit$body;
import org.weave.PathBasedResourceResolver;
import org.weave.PathBasedResourceResolver$;
import org.weave.WeaveProperties$;
import org.weave.WeaveRunnerConfig;
import scala.App;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class DataWeaveCli$
implements App {
    public static DataWeaveCli$ MODULE$;
    private final String version;
    private final long executionStart;
    private String[] scala$App$$_args;
    private final ListBuffer<Function0<BoxedUnit>> scala$App$$initCode;

    static {
        new DataWeaveCli$();
    }

    public String[] args() {
        return App.args$((App)this);
    }

    public void delayedInit(Function0<BoxedUnit> body2) {
        App.delayedInit$((App)this, body2);
    }

    public void main(String[] args) {
        App.main$((App)this, (String[])args);
    }

    public long executionStart() {
        return this.executionStart;
    }

    public String[] scala$App$$_args() {
        return this.scala$App$$_args;
    }

    public void scala$App$$_args_$eq(String[] x$1) {
        this.scala$App$$_args = x$1;
    }

    public ListBuffer<Function0<BoxedUnit>> scala$App$$initCode() {
        return this.scala$App$$initCode;
    }

    public void scala$App$_setter_$executionStart_$eq(long x$1) {
        this.executionStart = x$1;
    }

    public final void scala$App$_setter_$scala$App$$initCode_$eq(ListBuffer<Function0<BoxedUnit>> x$1) {
        this.scala$App$$initCode = x$1;
    }

    public String version() {
        return this.version;
    }

    public Either<WeaveRunnerConfig, String> parse(String[] args) {
        String path = "";
        None$ scriptToRun = None$.MODULE$;
        None$ output = None$.MODULE$;
        boolean debug = false;
        None$ main = None$.MODULE$;
        Map inputs = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        for (int i = 0; i < args.length; ++i) {
            BoxedUnit boxedUnit;
            String string = args[i];
            if ("-path".equals(string)) {
                if (i + 1 >= args.length) {
                    return package$.MODULE$.Right().apply((Object)"Missing path expression");
                }
                path = args[++i];
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if ("-verbose".equals(string)) {
                WeaveProperties$.MODULE$.verbose_$eq(true);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if ("-input".equals(string)) {
                String inputName;
                File input;
                if (i + 2 < args.length) {
                    input = new File(args[i + 2]);
                    inputName = args[i + 1];
                    if (!input.exists()) {
                        return package$.MODULE$.Right().apply((Object)org.mule.weave.v2.runtime.utils.AnsiColor$.MODULE$.red(new StringBuilder(21).append("Invalid input file ").append(inputName).append(" ").append(input.getAbsolutePath()).append(".").toString()));
                    }
                } else {
                    return package$.MODULE$.Right().apply((Object)org.mule.weave.v2.runtime.utils.AnsiColor$.MODULE$.red("Invalid amount of arguments on input."));
                }
                inputs.put((Object)inputName, (Object)SourceProvider$.MODULE$.apply((Object)input, Charset.defaultCharset(), (Option)None$.MODULE$));
                i += 2;
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if ("-output".equals(string)) {
                if (i + 1 >= args.length) {
                    return package$.MODULE$.Right().apply((Object)"Missing <outputPath>");
                }
                output = new Some((Object)args[++i]);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if ("-main".equals(string)) {
                if (i + 1 >= args.length) {
                    return package$.MODULE$.Right().apply((Object)"Missing main name identifier");
                }
                main = new Some((Object)args[++i]);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if ("-debug".equals(string)) {
                debug = true;
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (i + 1 == args.length) {
                scriptToRun = new Some((Object)string);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            return package$.MODULE$.Right().apply((Object)new StringBuilder(17).append("Invalid argument ").append(string).toString());
        }
        String[] paths = path.isEmpty() ? (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class)) : new StringOps(Predef$.MODULE$.augmentString(path)).split(File.pathSeparatorChar);
        return scriptToRun.isEmpty() && main.isEmpty() ? package$.MODULE$.Right().apply((Object)"Missing <scriptContent> or -main <nameIdentifier>") : package$.MODULE$.Left().apply((Object)new WeaveRunnerConfig(paths, debug, (Option<String>)scriptToRun, (Option<String>)main, (scala.collection.immutable.Map<String, SourceProvider>)inputs.toMap(Predef$.MODULE$.$conforms()), (Option<String>)output));
    }

    public String usages() {
        return new StringOps(Predef$.MODULE$.augmentString("\n      |\n      |.........................................................................\n      |.%%%%%....%%%%...%%%%%%...%%%%...%%...%%..%%%%%%...%%%%...%%..%%..%%%%%%.\n      |.%%..%%..%%..%%....%%....%%..%%..%%...%%..%%......%%..%%..%%..%%..%%.....\n      |.%%..%%..%%%%%%....%%....%%%%%%..%%.%.%%..%%%%....%%%%%%..%%..%%..%%%%...\n      |.%%..%%..%%..%%....%%....%%..%%..%%%%%%%..%%......%%..%%...%%%%...%%.....\n      |.%%%%%...%%..%%....%%....%%..%%...%%.%%...%%%%%%..%%..%%....%%....%%%%%%.\n      |.........................................................................\n      |\n      |\n      |Usage:\n      |\n      |dw [-path <weavePath>]? [-input <name> <path>]* [-verbose]? [-output <outputPath>]? [[-main <nameIdentifier>] | <scriptContent>]\n      |\n      |Arguments Detail:\n      |\n      | -path    | Path of jars or directories where weave files are being searched\n      | -input   | Declares a new input\n      | -verbose | Enable Verbose Mode\n      | -output  | Specifies output file for the transformation if not standard output will be used\n      | -main    | The full qualified name of the mapping to execute\n      |\n      |\n      | Documentation reference:\n      |\n      | https://docs.mulesoft.com/mule-runtime/4.1/dataweave\n    ")).stripMargin();
    }

    /*
     * WARNING - void declaration
     */
    public File getDWHome() {
        File file;
        File homeUser = new File(System.getProperty("user.home"));
        String weavehome = System.getenv("WEAVE_HOME");
        if (weavehome != null) {
            void var3_3;
            File home = new File(weavehome);
            if (!home.exists()) {
                Predef$.MODULE$.println((Object)AnsiColor$.MODULE$.red(new StringBuilder(94).append("[error] Weave Home Directory `").append(weavehome).append("` declared on environment variable `WEAVE_HOME` does not exists.").toString()));
            }
            file = var3_3;
        } else {
            File defaultDWHomeDir;
            if (WeaveProperties$.MODULE$.verbose()) {
                Predef$.MODULE$.println((Object)"[debug] Env not working trying home directory");
            }
            if ((defaultDWHomeDir = new File(homeUser, ".dw")).exists()) {
                file = defaultDWHomeDir;
            } else {
                Predef$.MODULE$.println((Object)AnsiColor$.MODULE$.yellow(new StringBuilder(170).append("[warning] Unable to detect Weave Home directory so local directory is going to be used. Please either define the env variable WEAVE_HOME or copy the weave distro into `").append(defaultDWHomeDir.getAbsolutePath()).append("`.").toString()));
                file = new File("..");
            }
        }
        return file;
    }

    public void run(WeaveRunnerConfig config) {
        block8: {
            Some resourceToRun;
            PathBasedResourceResolver resolver;
            NameIdentifier nameIdentifier;
            long startExecution;
            block7: {
                if (WeaveProperties$.MODULE$.verbose()) {
                    Predef$.MODULE$.println((Object)"[debug] System properties are: ");
                    System.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(a, b) -> Predef$.MODULE$.println((Object)new StringBuilder(15).append("[debug] - '").append(a).append("'='").append(b).append("'").toString())));
                }
                startExecution = System.currentTimeMillis();
                File dwHome = this.getDWHome();
                File weavelibs = new File(dwHome, "sdk");
                if (!weavelibs.exists()) {
                    Predef$.MODULE$.println((Object)AnsiColor$.MODULE$.red(new StringBuilder(27).append("[Error]Invalid home folder ").append(dwHome.getAbsolutePath()).toString()));
                    System.exit(-1);
                }
                if (WeaveProperties$.MODULE$.verbose()) {
                    Predef$.MODULE$.println((Object)new StringBuilder(19).append("[debug] Weave Home ").append(dwHome).toString());
                }
                String[] path = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])config.path())).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new Some((Object)weavelibs.listFiles()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (File[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(File.class))))).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getAbsolutePath(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
                nameIdentifier = (NameIdentifier)config.main().map((Function1 & Serializable & scala.Serializable)x$2 -> new NameIdentifier(x$2, NameIdentifier$.MODULE$.apply$default$2())).getOrElse((Function0 & Serializable & scala.Serializable)() -> NameIdentifier$.MODULE$.ANONYMOUS_NAME());
                resolver = PathBasedResourceResolver$.MODULE$.apply(path);
                Some some = resourceToRun = config.main().isDefined() ? resolver.resolve(nameIdentifier) : new Some((Object)WeaveResource$.MODULE$.apply("", (String)config.scriptToRun().get()));
                if (!resourceToRun.isEmpty()) break block7;
                Predef$.MODULE$.println((Object)AnsiColor$.MODULE$.red(new StringBuilder(34).append("[Error] Name Identifier not found ").append(nameIdentifier).toString()));
                System.exit(-1);
                break block8;
            }
            Map inputs = (Map)Map$.MODULE$.apply(config.inputs().toSeq());
            Object object = !inputs.contains((Object)"payload") ? inputs.put((Object)"payload", (Object)SourceProvider$.MODULE$.apply((Object)System.in)) : BoxedUnit.UNIT;
            if (WeaveProperties$.MODULE$.verbose()) {
                Predef$.MODULE$.println((Object)"[debug] Start parsing script");
            }
            ModuleLoaderManager manager = ModuleLoaderManager$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ModuleLoader[]{ModuleLoader$.MODULE$.apply((WeaveResourceResolver)resolver)}));
            ModuleParserManager parserManager = ModuleParserManager$.MODULE$.apply(manager);
            NameIdentifier x$8 = nameIdentifier;
            MessageCollector x$9 = new MessageCollector();
            ModuleParserManager x$10 = parserManager;
            int x$11 = 0;
            boolean x$12 = false;
            Option x$13 = ParsingContext$.MODULE$.$lessinit$greater$default$4();
            boolean x$14 = ParsingContext$.MODULE$.$lessinit$greater$default$5();
            ParsingContext parsingContext = new ParsingContext(x$8, x$9, x$10, x$13, x$14, x$11, x$12);
            inputs.keys().foreach((Function1 & Serializable & scala.Serializable)key -> parsingContext.addImplicitInput(key, (Option)None$.MODULE$));
            long startParsing = System.currentTimeMillis();
            PhaseResult result = MappingParser$.MODULE$.parse(MappingParser$.MODULE$.typeCheckPhase(), (WeaveResource)resourceToRun.get(), parsingContext);
            if (WeaveProperties$.MODULE$.verbose()) {
                Predef$.MODULE$.println((Object)new StringBuilder(30).append("[Debug] Parsing script took ").append(System.currentTimeMillis() - startParsing).append("ms").toString());
            }
            Seq messages = result.errorMessages();
            messages.foreach((Function1 & Serializable & scala.Serializable)message -> {
                DataWeaveCli$.$anonfun$run$7(message);
                return BoxedUnit.UNIT;
            });
            if (messages.isEmpty()) {
                System.exit(this.runMapping(parsingContext, (PhaseResult<TypeCheckingResult<? extends AstNode>>)result, config, manager, (Map<String, SourceProvider>)inputs, parserManager, resolver));
            } else {
                System.exit(-1);
            }
            if (!WeaveProperties$.MODULE$.verbose()) break block8;
            Predef$.MODULE$.println((Object)new StringBuilder(31).append("[Debug] Total execution took ").append(System.currentTimeMillis() - startExecution).append("ms").toString());
        }
    }

    private int runMapping(ParsingContext parsingContext, PhaseResult<TypeCheckingResult<? extends AstNode>> typeCheckResult, WeaveRunnerConfig config, ModuleLoaderManager moduleLoaderManager, Map<String, SourceProvider> inputs, ModuleParserManager parserManager, PathBasedResourceResolver resolver) {
        if (WeaveProperties$.MODULE$.verbose()) {
            Predef$.MODULE$.println((Object)"[debug] Start running mapping");
        }
        int statusResult = 0;
        CustomWeaveDataFormat weaveDataFormat = new CustomWeaveDataFormat(moduleLoaderManager);
        scala.collection.immutable.Map services = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(NativeValueProvider.class), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SystemNativeValueProvider[]{new SystemNativeValueProvider()}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(DataFormat.class), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DataFormat[]{new CSVDataFormat(), new JsonDataFormat(), new XmlDataFormat(), weaveDataFormat, new TextPlainDataFormat(), new OctetStreamDataFormat(), new PropertiesDataFormat(), new MultiPartDataFormat(), new YamlDataFormat()}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(ServiceRegistration.class), (Object)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(ReadFunctionProtocolHandler.class), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UrlProtocolHandler[]{new UrlProtocolHandler()})))}));
        WeaveRuntime$.MODULE$.setServiceProvider((ServiceProvider)new StaticServiceProvider(services));
        DefaultModuleNodeLoader nodeLoader = new DefaultModuleNodeLoader();
        WeaveBasedDataFormatExtensionLoaderService weaveBasedDataFormatManager = WeaveBasedDataFormatExtensionLoaderService$.MODULE$.apply(ParsingContextCreator$.MODULE$.apply(parserManager), (MultiWeaveResourceResolver)resolver, (ModuleNodeLoader)nodeLoader);
        ServiceManager serviceManager = ServiceManager$.MODULE$.apply((LoggingService)StdOutputLoggingService$.MODULE$, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(DataFormatExtensionsLoaderService.class), (Object)CompositeDataFormatExtensionsLoaderService$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DataFormatExtensionsLoaderService[]{DefaultDataFormatExtensionsLoaderService$.MODULE$, weaveBasedDataFormatManager})))})));
        EvaluationContext ctx = EvaluationContext$.MODULE$.apply(serviceManager);
        TypeCheckingResult value = (TypeCheckingResult)typeCheckResult.getResult();
        long startCompile = System.currentTimeMillis();
        PhaseResult result = new InterpreterMappingCompilerPhase((ModuleNodeLoader)nodeLoader).call((AstNodeResultAware)value, parsingContext);
        if (WeaveProperties$.MODULE$.verbose()) {
            Predef$.MODULE$.println((Object)new StringBuilder(30).append("[debug] Compile script took ").append(System.currentTimeMillis() - startCompile).append("ms").toString());
        }
        ExecutableWeave executable = ((CompilationResult)result.getResult()).executable();
        OutputStream out = config.outputPath().isDefined() ? new FileOutputStream((String)config.outputPath().get()) : System.out;
        scala.collection.immutable.Map<String, Reader> readers = this.buildReaders(executable, (scala.collection.immutable.Map<String, SourceProvider>)inputs.toMap(Predef$.MODULE$.$conforms()), ctx);
        Writer writer = (Writer)executable.declaredOutput(ctx).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.writer((Option)new Some((Object)out), x$3.writer$default$2(), ctx)).getOrElse((Function0 & Serializable & scala.Serializable)() -> WeaveWriter$.MODULE$.apply(out, new WeaveWriterSettings(), ctx));
        try {
            long startExecute = System.currentTimeMillis();
            executable.write(writer, readers, executable.write$default$3(), executable.write$default$4(), ctx);
            if (WeaveProperties$.MODULE$.verbose()) {
                Predef$.MODULE$.println((Object)new StringBuilder(30).append("[debug] Execute script took ").append(System.currentTimeMillis() - startExecute).append("ms").toString());
            }
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof LocatableException) {
                LocatableException locatableException = (LocatableException)throwable2;
                Predef$.MODULE$.println((Object)AnsiColor$.MODULE$.red(new StringBuilder(13).append("[error] ").append(locatableException.getMessage()).append(" at\n ").append(locatableException.location().locationString()).toString()));
                statusResult = -1;
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            if (throwable2 instanceof Exception) {
                Exception exception = (Exception)throwable2;
                Predef$.MODULE$.println((Object)AnsiColor$.MODULE$.red(new StringBuilder(8).append("[error] ").append(exception.getMessage()).toString()));
                statusResult = -1;
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
        return statusResult;
    }

    public scala.collection.immutable.Map<String, Reader> buildReaders(ExecutableWeave<?> executableWeave, scala.collection.immutable.Map<String, SourceProvider> inputs, EvaluationContext ctx) {
        scala.collection.immutable.Map declaredInputs = executableWeave.declaredInputs(ctx);
        return (scala.collection.immutable.Map)inputs.map((Function1 & Serializable & scala.Serializable)input -> {
            String string;
            SourceProvider sourceProvider = (SourceProvider)input._2();
            if (sourceProvider instanceof FileSourceProvider) {
                FileSourceProvider fileSourceProvider = (FileSourceProvider)sourceProvider;
                string = FileHelper$.MODULE$.getExtension(fileSourceProvider.file());
            } else {
                string = "";
            }
            String fileExtension = string;
            DataFormat valueDataFormat = (DataFormat)DataFormatManager$.MODULE$.byExtension(fileExtension, ctx).orElse((Function0 & Serializable & scala.Serializable)() -> declaredInputs.get(input._1())).getOrElse((Function0 & Serializable & scala.Serializable)() -> new JsonDataFormat());
            return new Tuple2(input._1(), (Object)valueDataFormat.reader((SourceProvider)input._2(), ctx));
        }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ void $anonfun$run$7(Tuple2 message) {
        Predef$.MODULE$.println((Object)AnsiColor$.MODULE$.red(new StringBuilder(8).append("[Error] ").append(((Message)message._2()).message()).toString()));
        Predef$.MODULE$.println((Object)AnsiColor$.MODULE$.red(((WeaveLocation)message._1()).locationString()));
    }

    public final void delayedEndpoint$org$weave$DataWeaveCli$1() {
        this.version = "2.2.0-SNAPSHOT";
        Either<WeaveRunnerConfig, String> scriptToRun = this.parse(this.args());
        Either<WeaveRunnerConfig, String> either = scriptToRun;
        if (either instanceof Right) {
            Right right = (Right)either;
            String message = (String)right.value();
            Predef$.MODULE$.println((Object)AnsiColor$.MODULE$.red(message));
            Predef$.MODULE$.println((Object)this.usages());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (either instanceof Left) {
            Left left = (Left)either;
            WeaveRunnerConfig config = (WeaveRunnerConfig)left.value();
            this.run(config);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(either);
        }
    }

    private DataWeaveCli$() {
        MODULE$ = this;
        App.$init$((App)this);
        this.delayedInit((Function0<BoxedUnit>)new DataWeaveCli$delayedInit$body(this));
    }
}

