/**
*
* The functions described here are packaged in the Runtime module. The module is included with Mule runtime, but you must import it to your DataWeave code by adding the line `import dw::Runtime` to your header.
*
* .Example
* [source]
* ----
* %dw 2.0
* import dw::Runtime
* ---
* Runtime::fail("Error")
* ----
*
* This module contains functions that allow you to interact with the DataWeave engine.
*
*/
%dw 2.0

/**
* 
* Throws an exception with the specified message.
*/
fun fail (message: String = 'Error'): Nothing = native("system::fail")

/**
*
* Throws an exception with the specified message if the expression in the evaluator returns `true`.
*/
fun failIf <T>(value: T, evaluator: (value: T) => Boolean): T =
    if(evaluator(value)) fail("Failed") else value

/**
*
* Stops the execution for the specified timeout (in milliseconds).
*/
fun wait <T>(value: T, timeout: Number): T = native("system::wait")
