/**
 * Returns true if some element of the list matches the condition.
 * It stops the iterations after the first match.
 */
fun some<T>(list: Array<T>, condition: (T) -> Boolean): Boolean =
  list match {
    case [] -> false
    case [head ~ tail] ->
      if(condition(head))
        true
      else
        some(tail, condition)
  }

/**
 * Returns true if every element of the list matches the condition.
 * It stops the iterations after the first negative evaluation.
 */
fun every<T>(list: Array<T>, condition: (T) -> Boolean): Boolean =
  list match {
    case [] -> false
    else -> private_every(list, condition)
  }

fun private_every<T>(list: Array<T>, condition: (T) -> Boolean): Boolean =
  list match {
    case [] -> true
    case [head ~ tail] ->
      if(condition(head))
        private_every(tail, condition)
      else
        false
  }