%dw 2.0

import ls, nameOf, contentOf, mimeTypeOf, baseNameOf, path, fileTypeOf from dw::test::internal::File
import runUrl from dw::test::internal::Runner
import * from dw::test::Tests
import * from dw::test::Asserts

fun createTestSuite(directory: String) = do {
    var mappings = ls(directory)
    ---
    if(isEmpty(mappings))
        []
    else
        mappings flatMap ((mappingDir) -> do {
            createTestCases(mappingDir)
        })
}

fun createTestCases(mappingDir:String) = do {
    var testScenario = ls(mappingDir)
    var mappingUrl = "classpath://" ++ (nameOf(mappingDir) replace "::" with "/") ++ ".dwl"
    ---
    testScenario flatMap (testCase) -> do {
      var context = buildContext(path(testCase, "inputs"))
      var outs = ls(testCase, "out.*") map ((expectedPath) -> read(contentOf(expectedPath), mimeTypeOf(expectedPath)))
      ---
      outs map (expected) -> createTestCase(nameOf(mappingDir) ++ " - " ++ nameOf(testCase), mappingUrl, context, expected)
    }
}

fun buildContext(dir: String) = do {
    var inputs = ls(dir) map (element) -> do {
        {
           (baseNameOf(element)):
               fileTypeOf(element) match {
                    case "FileType" -> read(contentOf(element), mimeTypeOf(element))
                    case "DirType" -> buildContext(element)
               }
        }
    }
    ---
    {
        (inputs)
    }
}


fun createTestCase(scenario: String, mapping: String, context: Object, expected: Any) = do {
    (() -> scenario in do {
        runUrl(mapping, context) must equalTo(expected)
    })
}
---
describedBy("IntegrationTest", createTestSuite(dw::Runtime::prop("dwitDir")))