%dw 2.0

import * from dw::test::Tests
import countBy from dw::core::Arrays

type TestsResult = Array<{name: String, testResult: TestResult}>


fun totalWithStatus(testsuite: TestResult, statusId: String) = do {
        var status: Array<TEST_STATUS> = (testsuite..).status
        ---
        status match {
          case is Null -> 0
          case is Array -> $ countBy $ == statusId
        }
    }

fun totalErrors(testsuite: TestResult) =
    totalWithStatus(testsuite, ERROR_STATUS)

fun totalSkip(testsuite: TestResult) =
    totalWithStatus(testsuite, SKIP_STATUS)

fun totalOk(testsuite: TestResult) =
    totalWithStatus(testsuite, OK_STATUS)

fun totalFail(testsuite: TestResult) =
    totalWithStatus(testsuite, FAIL_STATUS)

fun totalTests(testsuite: TestResult) = do {
    var testsSuites = testsuite..[?($ is Object and not $.tests?)]
    ---
    testsSuites match {
        case is Null -> 0
        case is Array -> sizeOf($)
    }
}