%dw 2.0

/**
* Helper method to execute something before and after
*
* === Parameters
*
* [%header, cols="1,3"]
* |===
* | Name   | Description
* | before | The method to be executed before
* | value | The function to be executed
* | after | The function to be executed after
* |===
*
* ----
**/
fun interceptor<T>(before:() -> Any, value:() -> T, after: (T) -> Any): T = do {
    var beforeResult = before()
    var result = value()
    var afterResult = after(result)
    ---
    result
}