/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.module.test.runner;

import java.io.File;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.mule.weave.v2.interpreted.listener.WeaveExecutionListener;
import org.mule.weave.v2.model.ServiceManager;
import org.mule.weave.v2.model.ServiceManager$;
import org.mule.weave.v2.model.service.LoggingService;
import org.mule.weave.v2.model.structure.KeyValuePair;
import org.mule.weave.v2.model.structure.KeyValuePair$;
import org.mule.weave.v2.model.values.ArrayValue;
import org.mule.weave.v2.model.values.ArrayValue$;
import org.mule.weave.v2.model.values.KeyValue$;
import org.mule.weave.v2.model.values.ObjectValue$;
import org.mule.weave.v2.model.values.StringValue$;
import org.mule.weave.v2.model.values.Value;
import org.mule.weave.v2.module.test.runner.Report;
import org.mule.weave.v2.module.test.runner.Report$;
import org.mule.weave.v2.module.test.runner.ReporterConfig;
import org.mule.weave.v2.module.test.runner.ReporterConfig$;
import org.mule.weave.v2.module.test.runner.TestRunnerConfiguration;
import org.mule.weave.v2.module.test.runner.TestStdOutputLoggingService;
import org.mule.weave.v2.module.test.runner.coverage.CodeCoverageListener;
import org.mule.weave.v2.module.test.runner.coverage.CodeCoverageLocationCollector;
import org.mule.weave.v2.module.test.runner.coverage.CodeCoverageResultProcessor;
import org.mule.weave.v2.module.test.runner.coverage.model.CodeCoverageFile;
import org.mule.weave.v2.module.test.runner.coverage.model.CodeCoverageResult;
import org.mule.weave.v2.module.test.runner.listener.DefaultEventListener;
import org.mule.weave.v2.module.test.runner.listener.DefaultEventListener$;
import org.mule.weave.v2.module.test.runner.listener.IntellijEventListener;
import org.mule.weave.v2.module.test.runner.listener.JsonEventListener$;
import org.mule.weave.v2.module.test.runner.listener.TestEventListener;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier$;
import org.mule.weave.v2.runtime.DataWeaveResult;
import org.mule.weave.v2.runtime.DataWeaveScript;
import org.mule.weave.v2.runtime.DataWeaveScriptingEngine;
import org.mule.weave.v2.runtime.DataWeaveScriptingEngine$;
import org.mule.weave.v2.runtime.ExecuteResult;
import org.mule.weave.v2.runtime.InputType;
import org.mule.weave.v2.runtime.InputType$;
import org.mule.weave.v2.runtime.ModuleComponentsFactory;
import org.mule.weave.v2.runtime.ScriptingBindings;
import org.mule.weave.v2.runtime.SimpleModuleComponentFactory$;
import org.mule.weave.v2.runtime.utils.AnsiColor$;
import org.mule.weave.v2.runtime.utils.CustomRunner;
import org.mule.weave.v2.ts.StringType;
import org.mule.weave.v2.ts.StringType$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.util.Either;

@ScalaSignature(bytes="\u0006\u0001\t\re\u0001\u0002\u0015*\u0001aBQa\u0012\u0001\u0005\u0002!+Aa\u0013\u0001\u0001\u0019\"9q\n\u0001b\u0001\n\u0003\u0001\u0006BB-\u0001A\u0003%\u0011\u000bC\u0004[\u0001\t\u0007I\u0011\u0001)\t\rm\u0003\u0001\u0015!\u0003R\u0011\u001da\u0006A1A\u0005\u0002ACa!\u0018\u0001!\u0002\u0013\t\u0006b\u00020\u0001\u0005\u0004%\t\u0001\u0015\u0005\u0007?\u0002\u0001\u000b\u0011B)\t\u000f\u0001\u0004!\u0019!C\u0001!\"1\u0011\r\u0001Q\u0001\nECqA\u0019\u0001C\u0002\u0013\u0005\u0001\u000b\u0003\u0004d\u0001\u0001\u0006I!\u0015\u0005\bI\u0002\u0011\r\u0011\"\u0001f\u0011\u0019\t\b\u0001)A\u0005M\"9!\u000f\u0001b\u0001\n\u0003)\u0007BB:\u0001A\u0003%a\rC\u0004u\u0001\t\u0007I\u0011A3\t\rU\u0004\u0001\u0015!\u0003g\u0011\u00151\b\u0001\"\u0011x\u0011\u001d\t)\u0001\u0001C!\u0003\u000fAq!!\n\u0001\t\u0003\n9\u0003C\u0004\u00024\u0001!\t!!\u000e\t\u0013\u0005m\u0004A1A\u0005\n\u0005u\u0004\u0002CAD\u0001\u0001\u0006I!a \t\u000f\u0005%\u0005\u0001\"\u0001\u0002\f\"9\u0011q\u0014\u0001\u0005\u0002\u0005\u0005\u0006bBAY\u0001\u0011%\u00111\u0017\u0005\b\u0003W\u0004A\u0011AAw\u0011\u001d\u0011i\u0001\u0001C\u0005\u0005\u001fAqAa\t\u0001\t\u0013\u0011)\u0003C\u0004\u0003,\u0001!IA!\f\t\u000f\tM\u0002\u0001\"\u0003\u00036!I!Q\u000b\u0001\u0012\u0002\u0013%!q\u000b\u0005\b\u0005[\u0002A\u0011\u0002B8\u0011%\u00119\bAI\u0001\n\u0013\u00119\u0006C\u0004\u0003z\u0001!IAa\u001f\t\u000f\t}\u0004\u0001\"\u0011\u0003\u0002\n\u0001B+Z:u\u0007V\u001cHo\\7Sk:tWM\u001d\u0006\u0003U-\naA];o]\u0016\u0014(B\u0001\u0017.\u0003\u0011!Xm\u001d;\u000b\u00059z\u0013AB7pIVdWM\u0003\u00021c\u0005\u0011aO\r\u0006\u0003eM\nQa^3bm\u0016T!\u0001N\u001b\u0002\t5,H.\u001a\u0006\u0002m\u0005\u0019qN]4\u0004\u0001M\u0019\u0001!O \u0011\u0005ijT\"A\u001e\u000b\u0003q\nQa]2bY\u0006L!AP\u001e\u0003\r\u0005s\u0017PU3g!\t\u0001U)D\u0001B\u0015\t\u00115)A\u0003vi&d7O\u0003\u0002E_\u00059!/\u001e8uS6,\u0017B\u0001$B\u00051\u0019Uo\u001d;p[J+hN\\3s\u0003\u0019a\u0014N\\5u}Q\t\u0011\n\u0005\u0002K\u00015\t\u0011FA\u0001U!\tQU*\u0003\u0002OS\t9B+Z:u%Vtg.\u001a:D_:4\u0017nZ;sCRLwN\\\u0001\u0017i\u0016\u001cHOU3tk2$h+\u0019:jC\ndWMT1nKV\t\u0011\u000b\u0005\u0002S/6\t1K\u0003\u0002U+\u0006!A.\u00198h\u0015\u00051\u0016\u0001\u00026bm\u0006L!\u0001W*\u0003\rM#(/\u001b8h\u0003]!Xm\u001d;SKN,H\u000e\u001e,be&\f'\r\\3OC6,\u0007%A\bsKB|'\u000f^3s?B\u0014XMZ5y\u0003A\u0011X\r]8si\u0016\u0014x\f\u001d:fM&D\b%\u0001\u0007F%J{%kU0M\u0003\n+E*A\u0007F%J{%kU0M\u0003\n+E\nI\u0001\u000e'.K\u0005\u000bU#E?2\u000b%)\u0012'\u0002\u001dM[\u0015\n\u0015)F\t~c\u0015IQ#MA\u0005qa)Q%M+J+5k\u0018'B\u0005\u0016c\u0015a\u0004$B\u00132+&+R*`\u0019\u0006\u0013U\t\u0014\u0011\u0002\u0017Q{E+\u0011'`\u0019\u0006\u0013U\tT\u0001\r)>#\u0016\tT0M\u0003\n+E\nI\u0001\ne\u0016\u0004xN\u001d;feN,\u0012A\u001a\t\u0005O2\ff.D\u0001i\u0015\tI'.A\u0005j[6,H/\u00192mK*\u00111nO\u0001\u000bG>dG.Z2uS>t\u0017BA7i\u0005\ri\u0015\r\u001d\t\u0003\u0015>L!\u0001]\u0015\u0003\rI+\u0007o\u001c:u\u0003)\u0011X\r]8si\u0016\u00148\u000fI\u0001\fC\u001e<'/Z4bi>\u00148/\u0001\u0007bO\u001e\u0014XmZ1u_J\u001c\b%A\bd_Z,'/Y4f%\u0016\u0004xN\u001d;t\u0003A\u0019wN^3sC\u001e,'+\u001a9peR\u001c\b%\u0001\u0006sk:tWM\u001d(b[\u0016$\u0012\u0001\u001f\t\u0004s\u0006\u0005aB\u0001>\u007f!\tY8(D\u0001}\u0015\tix'\u0001\u0004=e>|GOP\u0005\u0003\u007fn\na\u0001\u0015:fI\u00164\u0017b\u0001-\u0002\u0004)\u0011qpO\u0001\na\u0006\u00148/Z!sON$B!!\u0003\u0002\u001cA1\u00111BA\u000b\u0019btA!!\u0004\u0002\u00129\u001910a\u0004\n\u0003qJ1!a\u0005<\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u0006\u0002\u001a\t1Q)\u001b;iKJT1!a\u0005<\u0011\u001d\tiB\u0006a\u0001\u0003?\tA!\u0019:hgB!!(!\ty\u0013\r\t\u0019c\u000f\u0002\u0006\u0003J\u0014\u0018-_\u0001\u0004eVtG\u0003BA\u0015\u0003_\u00012AOA\u0016\u0013\r\tic\u000f\u0002\u0005+:LG\u000f\u0003\u0004\u00022]\u0001\r\u0001T\u0001\u0007G>tg-[4\u0002\u0019\r|G\u000e\\3diR+7\u000f^:\u0015\u0011\u0005]\u0012\u0011KA1\u0003k\u0002b!a\u0003\u0002:\u0005u\u0012\u0002BA\u001e\u00033\u00111aU3r!\u0011\ty$!\u0014\u000e\u0005\u0005\u0005#\u0002BA\"\u0003\u000b\n\u0011B^1sS\u0006\u0014G.Z:\u000b\t\u0005\u001d\u0013\u0011J\u0001\u0004CN$(bAA&_\u00051\u0001/\u0019:tKJLA!a\u0014\u0002B\tqa*Y7f\u0013\u0012,g\u000e^5gS\u0016\u0014\bbBA*1\u0001\u0007\u0011QK\u0001\ti\u0016\u001cHOR5mKB!\u0011qKA/\u001b\t\tIFC\u0002\u0002\\U\u000b!![8\n\t\u0005}\u0013\u0011\f\u0002\u0005\r&dW\rC\u0004\u0002da\u0001\r!!\u001a\u0002\u000fA\fG\u000f^3s]B!\u0011qMA9\u001b\t\tIG\u0003\u0003\u0002l\u00055\u0014!\u0002:fO\u0016D(bAA8+\u0006!Q\u000f^5m\u0013\u0011\t\u0019(!\u001b\u0003\u000fA\u000bG\u000f^3s]\"9\u0011q\u000f\rA\u0002\u0005e\u0014A\u00039be\u0016tG\u000fU1uQB)\u00111BA\u001dq\u00061QM\\4j]\u0016,\"!a \u0011\t\u0005\u0005\u00151Q\u0007\u0002\u0007&\u0019\u0011QQ\"\u00031\u0011\u000bG/Y,fCZ,7k\u0019:jaRLgnZ#oO&tW-A\u0004f]\u001eLg.\u001a\u0011\u0002+A\u0014xnY3tg\u000e{g/\u001a:bO\u0016\u0014Vm];miR1\u0011\u0011FAG\u0003;Cq!a$\u001c\u0001\u0004\t\t*A\u0005d_2dWm\u0019;peB!\u00111SAM\u001b\t\t)JC\u0002\u0002\u0018&\n\u0001bY8wKJ\fw-Z\u0005\u0005\u00037\u000b)JA\u000fD_\u0012,7i\u001c<fe\u0006<W\rT8dCRLwN\\\"pY2,7\r^8s\u0011\u0019\t\td\u0007a\u0001\u0019\u0006A!/\u001e8UKN$8\u000f\u0006\u0003\u0002$\u0006=\u0006cBAS\u0003OC\u0018\u0011V\u0007\u0003\u0003[J1!\\A7!\rQ\u00141V\u0005\u0004\u0003[[$aA%oi\"1\u0011\u0011\u0007\u000fA\u00021\u000b1C];o%\u0016\u0004xN\u001d;BO\u001e\u0014XmZ1u_J$b!a)\u00026\u0006%\bbBA\\;\u0001\u0007\u0011\u0011X\u0001\u000eKb,7-\u001e;fIR+7\u000f^:\u0011\r\u0005-\u0011\u0011HA^!\u001dQ\u0014QXA\u001f\u0003\u0003L1!a0<\u0005\u0019!V\u000f\u001d7feA\"\u00111YAl!\u0019\t)-a4\u0002T6\u0011\u0011q\u0019\u0006\u0005\u0003\u0013\fY-\u0001\u0004wC2,Xm\u001d\u0006\u0004\u0003\u001b|\u0013!B7pI\u0016d\u0017\u0002BAi\u0003\u000f\u0014QAV1mk\u0016\u0004B!!6\u0002X2\u0001A\u0001DAm\u0003k\u000b\t\u0011!A\u0003\u0002\u0005m'aA0%eE!\u0011Q\\Ar!\rQ\u0014q\\\u0005\u0004\u0003C\\$a\u0002(pi\"Lgn\u001a\t\u0004u\u0005\u0015\u0018bAAtw\t\u0019\u0011I\\=\t\r\u0005ER\u00041\u0001M\u0003\u001d\u0011XO\u001c+fgR$\"\"a<\u0002z\u0006u\u0018q B\u0005a\u0011\t\t0!>\u0011\r\u0005\u0015\u0017qZAz!\u0011\t).!>\u0005\u0017\u0005]h$!A\u0001\u0002\u000b\u0005\u00111\u001c\u0002\u0004?\u0012\u001a\u0004bBA~=\u0001\u0007\u0011QH\u0001\u000f]\u0006lW-\u00133f]RLg-[3s\u0011\u0019\t\tD\ba\u0001\u0019\"9!\u0011\u0001\u0010A\u0002\t\r\u0011aC<fCZ,7k\u0019:jaR\u0004B!!!\u0003\u0006%\u0019!qA\"\u0003\u001f\u0011\u000bG/Y,fCZ,7k\u0019:jaRDqAa\u0003\u001f\u0001\u0004\t\t*A\u000fd_\u0012,7i\u001c<fe\u0006<W\rT8dCRLwN\\\"pY2,7\r^8s\u0003)\u0011XO\u001c+iKR+7\u000f\u001e\u000b\u000b\u0005#\u0011YB!\b\u0003 \t\u0005\u0002\u0007\u0002B\n\u0005/\u0001b!!2\u0002P\nU\u0001\u0003BAk\u0005/!1B!\u0007 \u0003\u0003\u0005\tQ!\u0001\u0002\\\n\u0019q\f\n\u001b\t\u000f\u0005mx\u00041\u0001\u0002>!1\u0011\u0011G\u0010A\u00021Cq!a\u001f \u0001\u0004\u0011\u0019\u0001C\u0004\u0002\u0010~\u0001\r!!%\u0002!M\fg.\u001b;ju\u00164\u0015\u000e\\3OC6,Gc\u0001=\u0003(!1!\u0011\u0006\u0011A\u0002a\fAA\\1nK\u0006qAo\u001c*fg>,(oY3QCRDGcA)\u00030!1!\u0011G\u0011A\u0002a\fA\u0001]1uQ\u0006iQ\r_3dkR,'+\u001a9peR$\u0002Ba\u000e\u0003>\t\u0015#1\n\t\u0005\u0003\u0003\u0013I$C\u0002\u0003<\r\u0013q\u0002R1uC^+\u0017M^3SKN,H\u000e\u001e\u0005\b\u0003c\u0011\u0003\u0019\u0001B !\rQ%\u0011I\u0005\u0004\u0005\u0007J#A\u0004*fa>\u0014H/\u001a:D_:4\u0017n\u001a\u0005\b\u0005\u000f\u0012\u0003\u0019\u0001B%\u0003)!Xm\u001d;SKN,H\u000e\u001e\t\u0007\u0003\u000b\fy-a9\t\u0013\t5#\u0005%AA\u0002\t=\u0013A\u0002;be\u001e,G\u000fE\u0003;\u0005#\n\u0019/C\u0002\u0003Tm\u0012aa\u00149uS>t\u0017aF3yK\u000e,H/\u001a*fa>\u0014H\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\u0011IF\u000b\u0003\u0003P\tm3F\u0001B/!\u0011\u0011yF!\u001b\u000e\u0005\t\u0005$\u0002\u0002B2\u0005K\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t\u001d4(\u0001\u0006b]:|G/\u0019;j_:LAAa\u001b\u0003b\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002+\u0015DXmY;uK\u000e{g/\u001a:bO\u0016\u0014V\r]8siRA!q\u0007B9\u0005g\u0012)\bC\u0004\u00022\u0011\u0002\rAa\u0010\t\r\t\u001dC\u00051\u0001:\u0011%\u0011i\u0005\nI\u0001\u0002\u0004\u0011y%A\u0010fq\u0016\u001cW\u000f^3D_Z,'/Y4f%\u0016\u0004xN\u001d;%I\u00164\u0017-\u001e7uIM\nabY8qs\"#X\u000e\\!tg\u0016$8\u000f\u0006\u0003\u0002*\tu\u0004BBA\u0019M\u0001\u0007A*A\u0003vg\u0006<W\r\u0006\u0002\u0002*\u0001")
public class TestCustomRunner
implements CustomRunner {
    private final String testResultVariableName;
    private final String reporter_prefix;
    private final String ERRORS_LABEL;
    private final String SKIPPED_LABEL;
    private final String FAILURES_LABEL;
    private final String TOTAL_LABEL;
    private final scala.collection.immutable.Map<String, Report> reporters = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"default"), (Object)new Report("dw/test/internal/reporter/Default.dwl", ".json", Report$.MODULE$.apply$default$3(), Report$.MODULE$.apply$default$4())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"json"), (Object)new Report("dw/test/internal/reporter/Default.dwl", ".json", Report$.MODULE$.apply$default$3(), Report$.MODULE$.apply$default$4())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"junit"), (Object)new Report("dw/test/internal/reporter/JUnit.dwl", ".xml", Report$.MODULE$.apply$default$3(), Report$.MODULE$.apply$default$4()))}));
    private final scala.collection.immutable.Map<String, Report> aggregators = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"html"), (Object)new Report("dw/test/internal/reporter/HtmlAggregator.dwl", ".html", (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)"dw/test/internal/reporter/assets/"))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sonar"), (Object)new Report("dw/test/internal/reporter/Sonar.dwl", ".xml", (Option<String>)new Some((Object)"sonar"), Report$.MODULE$.apply$default$4()))}));
    private final scala.collection.immutable.Map<String, Report> coverageReports = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"html"), (Object)new Report("dw/test/internal/coverage/HtmlCoverage.dwl", ".html", (Option<String>)new Some((Object)"wtf-coverage-report"), (Option<String>)new Some((Object)"dw/test/internal/reporter/assets/"))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sonar"), (Object)new Report("dw/test/internal/coverage/Sonar.dwl", ".xml", (Option<String>)new Some((Object)"sonar"), Report$.MODULE$.apply$default$4()))}));
    private final DataWeaveScriptingEngine engine = DataWeaveScriptingEngine$.MODULE$.apply((ModuleComponentsFactory)SimpleModuleComponentFactory$.MODULE$.apply());

    public String testResultVariableName() {
        return this.testResultVariableName;
    }

    public String reporter_prefix() {
        return this.reporter_prefix;
    }

    public String ERRORS_LABEL() {
        return this.ERRORS_LABEL;
    }

    public String SKIPPED_LABEL() {
        return this.SKIPPED_LABEL;
    }

    public String FAILURES_LABEL() {
        return this.FAILURES_LABEL;
    }

    public String TOTAL_LABEL() {
        return this.TOTAL_LABEL;
    }

    public scala.collection.immutable.Map<String, Report> reporters() {
        return this.reporters;
    }

    public scala.collection.immutable.Map<String, Report> aggregators() {
        return this.aggregators;
    }

    public scala.collection.immutable.Map<String, Report> coverageReports() {
        return this.coverageReports;
    }

    public String runnerName() {
        return "wtest";
    }

    public Either<TestRunnerConfiguration, String> parseArgs(String[] args) {
        ArrayBuffer testsToRun = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        ArrayBuffer directoriesToScan = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        String pattern = ".*(Test|TestCase|Spec)";
        TestEventListener testEventListener = new DefaultEventListener(DefaultEventListener$.MODULE$.$lessinit$greater$default$1(), DefaultEventListener$.MODULE$.$lessinit$greater$default$2());
        boolean debug = false;
        boolean coverage = false;
        boolean htmlReport = false;
        String[] srcDirectories = (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class));
        ArrayBuffer reportConfigs = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        ArrayBuffer aggregatorConfigs = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        ArrayBuffer coverageReport = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        String[] configArgs = args;
        scala.collection.mutable.Map props = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        for (int i = 0; i < configArgs.length; ++i) {
            BoxedUnit boxedUnit;
            String arg = configArgs[i];
            if (arg.equals("-debug")) {
                debug = true;
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (arg.equals("-r") || arg.equals("-report")) {
                String report = configArgs[++i];
                String[] namePath = report.split("=");
                Report reporter = (Report)this.reporters().getOrElse((Object)namePath[0], (Function0 & Serializable & scala.Serializable)() -> {
                    throw new RuntimeException(new StringBuilder(39).append("Invalid `-report` ").append(namePath[0]).append(". Valid options are: ").append(this.reporters().keySet().mkString(",")).toString());
                });
                boxedUnit = reportConfigs.$plus$eq((Object)new ReporterConfig(reporter, new File(namePath[1])));
                continue;
            }
            if (arg.equals("-a") || arg.equals("-aggregator")) {
                htmlReport = true;
                String report = configArgs[++i];
                String[] namePath = report.split("=");
                Report reporter = (Report)this.aggregators().getOrElse((Object)namePath[0], (Function0 & Serializable & scala.Serializable)() -> {
                    throw new RuntimeException(new StringBuilder(43).append("Invalid `-aggregator` ").append(namePath[0]).append(". Valid options are: ").append(this.aggregators().keySet().mkString(",")).toString());
                });
                boxedUnit = aggregatorConfigs.$plus$eq((Object)new ReporterConfig(reporter, new File(namePath[1])));
                continue;
            }
            if (arg.equals("-t") || arg.equals("-test")) {
                String testToRun = configArgs[++i];
                boxedUnit = testsToRun.$plus$plus$eq((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])testToRun.split(","))));
                continue;
            }
            if (arg.equals("-R") || arg.equals("-directory")) {
                String directory = configArgs[++i];
                boxedUnit = directoriesToScan.$plus$eq((Object)directory);
                continue;
            }
            if (arg.equals("-prop")) {
                String name = configArgs[++i];
                String value = configArgs[++i];
                boxedUnit = props.put((Object)name, (Object)value);
                continue;
            }
            if (arg.equals("-pattern")) {
                String patternText;
                pattern = patternText = configArgs[++i];
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (arg.equals("-testlistener")) {
                String patternText;
                String string;
                TestEventListener testEventListener2 = "intellij".equals(string = (patternText = configArgs[++i])) ? new IntellijEventListener() : ("json".equals(string) ? JsonEventListener$.MODULE$.apply() : new DefaultEventListener(DefaultEventListener$.MODULE$.$lessinit$greater$default$1(), DefaultEventListener$.MODULE$.$lessinit$greater$default$2()));
                testEventListener = testEventListener2;
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (arg.equals("-coverage")) {
                coverage = true;
                srcDirectories = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])configArgs[++i].split(","))).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.trim(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (arg.equals("-coverageReport")) {
                String report = configArgs[++i];
                String[] namePath = report.split("=");
                Report reporter = (Report)this.coverageReports().getOrElse((Object)namePath[0], (Function0 & Serializable & scala.Serializable)() -> {
                    throw new RuntimeException(new StringBuilder(47).append("Invalid `-coverageReport` ").append(namePath[0]).append(". Valid options are: ").append(this.coverageReports().keySet().mkString(",")).toString());
                });
                boxedUnit = coverageReport.$plus$eq((Object)new ReporterConfig(reporter, new File(namePath[1])));
                continue;
            }
            return package$.MODULE$.Right().apply((Object)new StringBuilder(17).append("Invalid argument ").append(arg).toString());
        }
        return package$.MODULE$.Left().apply((Object)new TestRunnerConfiguration((Seq<String>)testsToRun, (Seq<ReporterConfig>)reportConfigs, (Seq<ReporterConfig>)aggregatorConfigs, debug, htmlReport, coverage, srcDirectories, (Seq<ReporterConfig>)coverageReport, pattern, (Seq<String>)directoriesToScan, testEventListener, (scala.collection.immutable.Map<String, String>)props.toMap(Predef$.MODULE$.$conforms())));
    }

    public void run(TestRunnerConfiguration config) {
        Map<String, Object> result = this.runTests(config);
        int failures = BoxesRunTime.unboxToInt((Object)result.get(this.FAILURES_LABEL()));
        int errors = BoxesRunTime.unboxToInt((Object)result.get(this.ERRORS_LABEL()));
        int total = BoxesRunTime.unboxToInt((Object)result.get(this.TOTAL_LABEL()));
        int skipped = BoxesRunTime.unboxToInt((Object)result.get(this.SKIPPED_LABEL()));
        if (errors == 0 && failures == 0) {
            Predef$.MODULE$.println((Object)AnsiColor$.MODULE$.green(new StringBuilder(35).append("All test passed (ignored: ").append(skipped).append(" total: ").append(total).append(")").toString()));
        } else {
            Predef$.MODULE$.println((Object)AnsiColor$.MODULE$.red(new StringBuilder(45).append("Summary ignored: ").append(skipped).append(" failures: ").append(failures).append(" errors: ").append(errors).append(" total: ").append(total).toString()));
        }
        if (config.htmlReport()) {
            Predef$.MODULE$.println((Object)AnsiColor$.MODULE$.green(new StringBuilder(29).append("Check out the test report at ").append(new File(((ReporterConfig)config.aggregators().head()).outputDirectory(), "wtf-summary.html").getPath()).toString()));
        }
        if (errors > 0 || failures > 0) {
            System.exit(1);
        } else {
            System.exit(0);
        }
    }

    public Seq<NameIdentifier> collectTests(File testFile, Pattern pattern, Seq<String> parentPath) {
        Seq seq;
        if (testFile.isDirectory()) {
            Seq path = (Seq)parentPath.$colon$plus((Object)testFile.getName(), Seq$.MODULE$.canBuildFrom());
            seq = (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])testFile.listFiles())).map((Function1 & Serializable & scala.Serializable)file -> this.collectTests((File)file, pattern, (Seq<String>)path), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Seq.class))))).foldLeft((Object)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (Function2 & Serializable & scala.Serializable)(value, acc) -> (Seq)value.$plus$plus((GenTraversableOnce)acc, Seq$.MODULE$.canBuildFrom()));
        } else if (testFile.getName().endsWith(".dwl")) {
            String baseName = testFile.getName().substring(0, testFile.getName().length() - 4);
            if (pattern.matcher(baseName).matches()) {
                Seq path = (Seq)parentPath.$colon$plus((Object)baseName, Seq$.MODULE$.canBuildFrom());
                seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NameIdentifier[]{NameIdentifier$.MODULE$.fromElements(path, (Option)None$.MODULE$)}));
            } else {
                seq = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
            }
        } else {
            seq = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
        }
        return seq;
    }

    private DataWeaveScriptingEngine engine() {
        return this.engine;
    }

    public void processCoverageResult(CodeCoverageLocationCollector collector, TestRunnerConfiguration config) {
        CodeCoverageResultProcessor processor = new CodeCoverageResultProcessor(collector);
        CodeCoverageFile[] results = (CodeCoverageFile[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])config.srcDirs())).flatMap((Function1 & Serializable & scala.Serializable)file -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])processor.process(new File(file)).files())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(CodeCoverageFile.class)));
        CodeCoverageResult payload = new CodeCoverageResult(results);
        config.coverageReports().foreach((Function1 & Serializable & scala.Serializable)ac -> {
            DataWeaveResult dataWeaveResult;
            File outputDirectory = ac.outputDirectory();
            outputDirectory.mkdirs();
            File outputFile = new File(outputDirectory, ac.report().outputFileName("wtf-coverage"));
            try (FileOutputStream fileOutputStream = new FileOutputStream(outputFile);){
                dataWeaveResult = this.executeCoverageReport((ReporterConfig)ac, payload, (Option<Object>)new Some((Object)fileOutputStream));
            }
            return dataWeaveResult;
        });
    }

    public Map<String, Object> runTests(TestRunnerConfiguration config) {
        Seq executedTests;
        block1: {
            Seq testFromDirectories = (Seq)config.directoriesToScan().flatMap((Function1 & Serializable & scala.Serializable)d -> {
                ArrayOps.ofRef ofRef2;
                File testDirectory = new File((String)d);
                if (testDirectory.exists() && testDirectory.isDirectory()) {
                    ofRef2 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])testDirectory.listFiles())).flatMap((Function1 & Serializable & scala.Serializable)td -> this.collectTests((File)td, Pattern.compile(config.pattern()), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(NameIdentifier.class))))).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.name(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))));
                } else {
                    Predef$.MODULE$.println((Object)new StringBuilder(65).append("[WARNING] Ignoring `").append((String)d).append("` as it does not exist or it is not a folder.").toString());
                    ofRef2 = (SeqLike)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
                }
                return ofRef2;
            }, Seq$.MODULE$.canBuildFrom());
            Seq tests = (Seq)config.tests().$plus$plus((GenTraversableOnce)testFromDirectories, Seq$.MODULE$.canBuildFrom());
            CodeCoverageLocationCollector collector = new CodeCoverageLocationCollector();
            executedTests = (Seq)tests.map((Function1 & Serializable & scala.Serializable)resourcePath -> {
                NameIdentifier path = new NameIdentifier(resourcePath, NameIdentifier$.MODULE$.apply$default$2());
                config.testListener().startLocation(path.toString());
                InputType[] inputs = (InputType[])((TraversableOnce)config.props().map((Function1 & Serializable & scala.Serializable)prop -> InputType$.MODULE$.apply((String)prop._1(), (Option)new Some((Object)new StringType(StringType$.MODULE$.apply$default$1()))), Iterable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(InputType.class));
                DataWeaveScript script = this.engine().compile(path, inputs);
                return new Tuple2((Object)path, this.runTest(path, config, script, collector));
            }, Seq$.MODULE$.canBuildFrom());
            if (config.htmlReport() || config.coverage() && config.coverageReports().exists((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)TestCustomRunner.$anonfun$runTests$6(p)))) {
                this.copyHtmlAssets(config);
            }
            if (!config.coverage()) break block1;
            this.processCoverageResult(collector, config);
        }
        return this.runReportAggregator(executedTests, config);
    }

    private Map<String, Object> runReportAggregator(Seq<Tuple2<NameIdentifier, Value<?>>> executedTests, TestRunnerConfiguration config) {
        Seq values = (Seq)executedTests.map((Function1 & Serializable & scala.Serializable)tr -> ObjectValue$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyValuePair[]{new KeyValuePair((Value)KeyValue$.MODULE$.apply("name"), (Value)StringValue$.MODULE$.apply(((NameIdentifier)tr._1()).name()), KeyValuePair$.MODULE$.apply$default$3()), new KeyValuePair((Value)KeyValue$.MODULE$.apply("testResult"), (Value)tr._2(), KeyValuePair$.MODULE$.apply$default$3())}))), Seq$.MODULE$.canBuildFrom());
        ArrayValue arrayValue = ArrayValue$.MODULE$.apply(values);
        config.aggregators().foreach((Function1 & Serializable & scala.Serializable)ac -> {
            DataWeaveResult dataWeaveResult;
            File outputDirectory = ac.outputDirectory();
            outputDirectory.mkdirs();
            File outputFile = new File(outputDirectory, ac.report().outputFileName("wtf-summary"));
            try (FileOutputStream fileOutputStream = new FileOutputStream(outputFile);){
                dataWeaveResult = this.executeReport((ReporterConfig)ac, (Value<Object>)arrayValue, (Option<Object>)new Some((Object)fileOutputStream));
            }
            return dataWeaveResult;
        });
        HashMap<String, Integer> initialValue = new HashMap<String, Integer>();
        initialValue.put(this.FAILURES_LABEL(), BoxesRunTime.boxToInteger((int)0));
        initialValue.put(this.ERRORS_LABEL(), BoxesRunTime.boxToInteger((int)0));
        initialValue.put(this.SKIPPED_LABEL(), BoxesRunTime.boxToInteger((int)0));
        initialValue.put(this.TOTAL_LABEL(), BoxesRunTime.boxToInteger((int)0));
        Seq results = (Seq)executedTests.map((Function1 & Serializable & scala.Serializable)pair -> {
            ReporterConfig tuple = new ReporterConfig(new Report("dw/test/internal/reporter/Summary.dwl", Report$.MODULE$.apply$default$2(), Report$.MODULE$.apply$default$3(), Report$.MODULE$.apply$default$4()), ReporterConfig$.MODULE$.apply$default$2());
            return (Map)this.executeReport(tuple, (Value<Object>)((Value)pair._2()), this.executeReport$default$3()).getContent();
        }, Seq$.MODULE$.canBuildFrom());
        return (Map)results.foldLeft(initialValue, (Function2 & Serializable & scala.Serializable)(value, acc) -> {
            acc.put(this.FAILURES_LABEL(), BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt(acc.get(this.FAILURES_LABEL())) + BoxesRunTime.unboxToInt(value.get(this.FAILURES_LABEL())))));
            acc.put(this.ERRORS_LABEL(), BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt(acc.get(this.ERRORS_LABEL())) + BoxesRunTime.unboxToInt(value.get(this.ERRORS_LABEL())))));
            acc.put(this.SKIPPED_LABEL(), BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt(acc.get(this.SKIPPED_LABEL())) + BoxesRunTime.unboxToInt(value.get(this.SKIPPED_LABEL())))));
            acc.put(this.TOTAL_LABEL(), BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt(acc.get(this.TOTAL_LABEL())) + BoxesRunTime.unboxToInt(value.get(this.TOTAL_LABEL())))));
            return acc;
        });
    }

    public Value<?> runTest(NameIdentifier nameIdentifier, TestRunnerConfiguration config, DataWeaveScript weaveScript, CodeCoverageLocationCollector codeCoverageLocationCollector) {
        Object object = config.debug() ? weaveScript.enableDebug() : BoxedUnit.UNIT;
        return this.runTheTest(nameIdentifier, config, weaveScript, codeCoverageLocationCollector);
    }

    private Value<?> runTheTest(NameIdentifier nameIdentifier, TestRunnerConfiguration config, DataWeaveScript engine, CodeCoverageLocationCollector collector) {
        Value value;
        ScriptingBindings scriptingBindings = new ScriptingBindings();
        config.props().foreach((Function1 & Serializable & scala.Serializable)prop -> scriptingBindings.addBinding((String)prop._1(), (Value)StringValue$.MODULE$.apply((String)prop._2())));
        ServiceManager serviceManager = ServiceManager$.MODULE$.apply((LoggingService)new TestStdOutputLoggingService(config.testListener()));
        Object object = config.coverage() ? engine.addExecutionListener((WeaveExecutionListener)new CodeCoverageListener(collector)) : BoxedUnit.UNIT;
        try (ExecuteResult testResult = engine.exec(scriptingBindings, serviceManager);){
            Seq seq;
            Seq testReports = config.reporter();
            if (testReports.isEmpty()) {
                Report reporter2 = (Report)this.reporters().apply((Object)"default");
                seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReporterConfig[]{new ReporterConfig(reporter2, ReporterConfig$.MODULE$.apply$default$2())}));
            } else {
                seq = testReports;
            }
            Seq fullReports = seq;
            Value testResultValue = testResult.getResultMaterialized();
            fullReports.foreach((Function1 & Serializable & scala.Serializable)reporter -> {
                DataWeaveResult dataWeaveResult;
                File outputDirectory = reporter.outputDirectory();
                outputDirectory.mkdirs();
                String fileName = new StringBuilder(5).append("TEST-").append(nameIdentifier.toString()).append(reporter.report().outputExtension()).toString();
                File outputFile = new File(outputDirectory, this.sanitizeFileName(fileName));
                try (FileOutputStream fileOutputStream = new FileOutputStream(outputFile);){
                    dataWeaveResult = this.executeReport((ReporterConfig)reporter, (Value<Object>)testResultValue, (Option<Object>)new Some((Object)fileOutputStream));
                }
                return dataWeaveResult;
            });
            value = testResultValue;
        }
        return value;
    }

    private String sanitizeFileName(String name) {
        return name.replaceAll("[\u0000-\u001f<>:\"/\\\\|?*\u007f]+", "-");
    }

    private String toResourcePath(String path) {
        return path.replace('\\', '/');
    }

    private DataWeaveResult executeReport(ReporterConfig config, Value<Object> testResult, Option<Object> target) {
        NameIdentifier nameIdentifier = NameIdentifier$.MODULE$.fromPath(config.report().path());
        DataWeaveScript reporterScript = this.engine().compile(nameIdentifier, (InputType[])((Object[])new InputType[]{InputType$.MODULE$.apply(this.testResultVariableName(), (Option)None$.MODULE$)}));
        ScriptingBindings reportBindings = new ScriptingBindings();
        reportBindings.addBinding(this.testResultVariableName(), testResult);
        return reporterScript.write(reportBindings, ServiceManager$.MODULE$.apply(), target);
    }

    private Option<Object> executeReport$default$3() {
        return None$.MODULE$;
    }

    private DataWeaveResult executeCoverageReport(ReporterConfig config, Object testResult, Option<Object> target) {
        NameIdentifier nameIdentifier = NameIdentifier$.MODULE$.fromPath(config.report().path());
        DataWeaveScript reporterScript = this.engine().compile(nameIdentifier, (InputType[])((Object[])new InputType[]{InputType$.MODULE$.apply("payload", (Option)None$.MODULE$)}));
        ScriptingBindings reportBindings = new ScriptingBindings();
        reportBindings.addBinding("payload", testResult, "application/java");
        return reporterScript.write(reportBindings, ServiceManager$.MODULE$.apply(), target);
    }

    private Option<Object> executeCoverageReport$default$3() {
        return None$.MODULE$;
    }

    private void copyHtmlAssets(TestRunnerConfiguration config) {
        Some some;
        ReporterConfig reporter = null;
        File assetsDirectory = null;
        Path fromPath = null;
        ObjectRef toPath = ObjectRef.create(null);
        if (config.htmlReport()) {
            reporter = (ReporterConfig)config.aggregators().head();
            assetsDirectory = new File(reporter.outputDirectory(), "assets");
        } else if (!config.htmlReport() && config.coverage() && config.coverageReports().exists((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)TestCustomRunner.$anonfun$copyHtmlAssets$1(p)))) {
            reporter = (ReporterConfig)((IterableLike)config.coverageReports().filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)TestCustomRunner.$anonfun$copyHtmlAssets$2(p)))).head();
            assetsDirectory = new File(reporter.outputDirectory().getParentFile(), "assets");
        }
        assetsDirectory.mkdirs();
        fromPath = Paths.get((String)reporter.report().assetsPath().get(), new String[0]);
        toPath.elem = assetsDirectory.toPath();
        URI uri = System.getProperty("os.name").startsWith("Windows") ? this.getClass().getClassLoader().getResource(this.toResourcePath(((Object)fromPath).toString())).toURI() : this.getClass().getClassLoader().getResource(((Object)fromPath).toString()).toURI();
        try {
            some = new Some((Object)FileSystems.newFileSystem(uri, new HashMap()));
        }
        catch (Exception e) {
            some = None$.MODULE$;
        }
        Some maybeZipFs = some;
        try {
            try {
                Files.list(((FileSystem)maybeZipFs.get()).getPath(((Object)fromPath).toString(), new String[0])).forEach(f -> Files.copy(f, Paths.get(((Object)((Path)toPath$1.elem)).toString(), ((Object)f.getName(f.getNameCount() - 1)).toString()), StandardCopyOption.REPLACE_EXISTING));
            }
            catch (Exception e) {
                Predef$.MODULE$.println((Object)"An error occurred while copying the asset files");
            }
        }
        finally {
            if (!maybeZipFs.isEmpty()) {
                ((FileSystem)maybeZipFs.get()).close();
            }
        }
    }

    public void usage() {
        Predef$.MODULE$.println((Object)"--test -debug -report <reporter:path> <test_resource,>*");
    }

    public static final /* synthetic */ boolean $anonfun$runTests$6(ReporterConfig p) {
        return p.report().outputExtension().equals(".html");
    }

    public static final /* synthetic */ boolean $anonfun$copyHtmlAssets$1(ReporterConfig p) {
        return p.report().outputExtension().equals(".html");
    }

    public static final /* synthetic */ boolean $anonfun$copyHtmlAssets$2(ReporterConfig p) {
        return p.report().outputExtension().equals(".html");
    }

    public TestCustomRunner() {
        this.testResultVariableName = "testResult";
        this.reporter_prefix = "reporter:";
        this.ERRORS_LABEL = "errors";
        this.SKIPPED_LABEL = "skip";
        this.FAILURES_LABEL = "failures";
        this.TOTAL_LABEL = "total";
    }
}

