%dw 2.0
output application/html with xml
input payload application/java

import * from dw::core::Arrays
import * from dw::test::internal::coverage::CoverageReports

var files: Array<File> = payload.files as Array<File>
var formatter = (n: Number) -> (n as String {format: "##.##"})
---
html: {
    head: {
        meta @(charset: "utf-8") : null,
        meta @(name: "viewport", content:"width=device-width, initial-scale=1, maximum-scale=1") : null,
        title: "Weave Testing Framework - Coverage Report",
        link @(rel: "stylesheet", 'type': "text/css", href: "../assets/mulesoft-styles.css"): null,
        link @(rel: "stylesheet", 'type': "text/css", href: "../assets/tsorter.css"): null
    },
    body: {
        header: {
             div @(class:"mulesoft-topbar"): {
                div @(class: "mulesoft-appbar"): {
                        div @(class: "muleicon muleicon-logo"): null,
                        div @(class: "anypoint-brand"): "Weave Testing Framework - Coverage Report"
                    }
                }
            },
        div @(class: "col-md-2 col-md-offset-1 sidemenu"):{
            ul @(class: "sidemenu-back"):{
                li:{
                    a @(href: "../wtf-summary.html"): "Test Report"
                },
                li: {
                    a @(href: ""): "Coverage Report"
                }
            }
        },
        div @(class: "container col-md-8"): {
            h2 @(class: "text-bold"): "DataWeave Coverage**",
            div @(class: "progress"): do {
                var totalProjectCoverage = formatter(totalCoverage(files))
                ---
                {
                    span: "$(totalProjectCoverage) %",
                    div @(class: "progress-bar progress-bar-success",
                     role: "progressbar",
                     'aria-valuenow':"$(totalProjectCoverage)",
                     'aria-valuemin':"0",
                     'aria-valuemax':"100",
                     style: "width: $(totalProjectCoverage)%;"): null
                }
            }},
            h2 @(class: "text-bold"): "Weave Files",
            table @(id: "resources-table", class: "table table-featured table-hover sortable"): {
                thead:{
                    tr: {
                        th @(colspan:"2", 'data-tsorter': "link"): "Resource",
                        th @('data-tsorter':"coverage"): "Coverage"
                    }
                },
                tbody @(id: "table-body"):
                    files map ((f) -> do{
                    var currentFileCoverage = formatter(fileCoverage(f))
                    ---
                        tr: {
                            td @(colspan:"2"): f.nameIdentifier.name,
                            td: {
                                div @(class: "progress"): {
                                    span: "$(currentFileCoverage) %",
                                    div @(class: "progress-bar progress-bar-success",
                                         role: "progressbar",
                                         'aria-valuenow': "$(currentFileCoverage)",
                                         'aria-valuemin': "0",
                                         'aria-valuemax':"100",
                                         style: "width: $(currentFileCoverage)%;"
                                            ):null
                                }
                            }

                        }
                    })

            }

        }

}



