/**
* INTERNAL USE ONLY
*
* Simple file module
*/
%dw 2.0

/**
* Return the list of child elements of the specified path.
*
*/
fun ls(path: String): Array<String> = native("file::ls")

fun ls(path: String, filterExpr: String): Array<String> = do {
    ls(path) filter ((dir) -> nameOf(dir) matches (filterExpr as Regex))
}

/**
* Returns the file type. FileType or DirType
*/
fun fileTypeOf(path: String): String = native("file::fileTypeOf")

/**
* Returns the name of this file
*/
fun nameOf(path:String): String = native("file::nameOf")

/**
* Returns the content of the specified file
*/
fun contentOf(path: String): String = native("file::contentOf")

/**
* Returns the infered mimeType of the specified file if not returns null
*/
fun mimeTypeOf(path: String): String | Null = do {
    extensionOf(path) match {
      case ".xml" -> "application/xml"
      case ".json" -> "application/json"
      case ".csv" -> "application/csv"
      case ".xlsx" -> "application/xlsx"
      case ".txt" -> "text/plain"
      case ".dwl" -> "application/dw"
      else -> null
    }
}

/**
* Returns the base name of this file
*/
fun baseNameOf(path: String): String = do {
    var name = nameOf(path)
    var lastDotIndex =  (name find ".")[-1] default -1
    ---
    if(lastDotIndex == -1)
        name
    else
        name[0 to (lastDotIndex - 1)]
}

fun extensionOf(path: String): String | Null = do {
    var lastDotIndex =  (path find ".")[-1] default -1
    ---
    if(lastDotIndex == -1)
        null
    else
        path[lastDotIndex to -1]
}



/**
* Creates a valid path from this two parts
*/
fun path(basePath: String, part: String): String = native("file::path")