%dw 2.0
import countBy from dw::core::Arrays


/**
* Transforms the test result in a junit compatible test result report
*/
fun processTestResult(testResult) = do {

    fun testToJunitResult(test) = do {
      if ((not test.tests?) or isEmpty(test.tests)) {
        testcase @(name: test.name, time: test.time, status: test.status): {
          (failure: test.errorMessage) if (test.status == "FAIL"),
          (error: test.errorMessage) if (test.status == "ERROR")
        }
      } else do {
        {
          testsuite @(
                    tests: totalTests(testResult),
                    time: testResult.time,
                    name: testResult.name,
                    failures: totalFailures(testResult),
                    errors: totalErrors(testResult)): {
            (testResult.tests map ((item, index) -> testToJunitResult(item)))
          }
        }
      }
    }

    fun totalFailures(testsuite) = do {
        var status = testsuite..status
        ---
        status match {
          case is Null -> 0
          case is Array -> $ countBy $ == "FAIL"
        }
    }

    fun totalErrors(testsuite) = do {
        var status = testsuite..status
        ---
        status match {
            case is Null -> 0
            case is Array -> $ countBy $ == "ERROR"
        }
    }

    fun totalTests(testsuite) = do {
        var testsSuites = testsuite..[?($ is Object and not $.tests?)]
        ---
        testsSuites match {
            case is Null -> 0
            case is Array -> sizeOf($)
        }
    }

    ---
    {
        testsuites
              @(tests: totalTests(testResult),
                time: testResult.time,
                name: testResult.name,
                failures: totalFailures(testResult),
                errors: totalErrors(testResult)
                ): testToJunitResult(testResult)
    }
}

output application/xml
---
processTestResult(testResult)