package org.mule.weave.v2.module.xmlschema.handler

import org.mule.apache.xerces.impl.dv.xs.XSSimpleTypeDecl
import org.mule.weave.v2.module.xmlschema.utils.XmlConstants.XSD_TIME
import org.mule.weave.v2.parser.ast.structure.StringNode
import org.mule.weave.v2.parser.ast.structure.schema.{ SchemaNode, SchemaPropertyNode }
import org.mule.weave.v2.parser.ast.types.{ TypeReferenceNode, WeaveTypeNode }
import org.mule.weave.v2.parser.ast.variables.NameIdentifier

import javax.xml.namespace.QName

class TimeHandler extends XmlHandler {

  val TIME_TYPES: List[QName] = List(XSD_TIME)

  override def handles(schema: QName): Boolean = TIME_TYPES.contains(schema)

  override def handle(xsTypeDefinition: XSSimpleTypeDecl, defaultValue: Option[String]): WeaveTypeNode = {
    TypeReferenceNode(NameIdentifier("Time"), None, None)
  }
}
