package org.mule.weave.v2.module.xmlschema

import org.mule.weave.v2.parser.{ Message, MessageCategory, MessageKind, ParsingPhaseCategory }

case class InvalidXmlSchemaMessage(reason: String) extends Message {
  override def message: String = {
    reason
  }

  override def category: MessageCategory = ParsingPhaseCategory

  /**
    * The kind message.
    * It's used by mule to classify the messages so it is considered as API
    *
    * @return the message kind
    */
  override def kind: String = MessageKind.INVALID_XML_SCHEMA_MESSAGE_KIND
}
