package org.mule.weave.v2.module.xmlschema

import org.mule.apache.xerces.impl.Constants.DISALLOW_DOCTYPE_DECL_FEATURE
import org.mule.apache.xerces.impl.Constants.DOM_ERROR_HANDLER
import org.mule.apache.xerces.impl.Constants.HONOUR_ALL_SCHEMALOCATIONS_FEATURE
import org.mule.apache.xerces.impl.Constants.XERCES_FEATURE_PREFIX
import org.mule.apache.xerces.impl.xs.XMLSchemaLoader.ENTITY_RESOLVER
import org.mule.apache.xerces.impl.xs.XSImplementationImpl
import org.mule.apache.xerces.impl.xs.XSLoaderImpl
import org.mule.apache.xerces.util.DOMEntityResolverWrapper
import org.mule.apache.xerces.xs.XSModel
import org.mule.weave.v2.module.xmlschema.utils.SchemaHelper.getLSInputList
import org.mule.weave.v2.module.xmlschema.utils.SchemaHelper.getSchemasByTargetNamespace
import org.mule.weave.v2.parser.MessageCollector
import org.mule.weave.v2.parser.ast.header.directives.NamespaceDirective
import org.mule.weave.v2.parser.ast.structure.UriNode
import org.mule.weave.v2.parser.ast.types.WeaveTypeNode
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import org.mule.weave.v2.parser.location.SimpleParserPosition
import org.mule.weave.v2.parser.location.WeaveLocation
import org.mule.weave.v2.parser.phase.PhaseResult
import org.mule.weave.v2.sdk.WeaveResource
import org.mule.weave.v2.sdk.WeaveResourceResolver
import org.w3c.dom.DOMError
import org.w3c.dom.DOMErrorHandler

import java.lang.Boolean.parseBoolean
import java.nio.charset.Charset
import javax.xml.namespace.QName
import scala.collection.mutable

class XmlSchemaTransformationContext(val resource: WeaveResource, val moduleIdentifier: NameIdentifier, val resourceResolver: WeaveResourceResolver) {

  val EXPAND_ENTITIES_PROPERTY = "mule.xml.expandInternalEntities"
  val namespaces: mutable.Map[String, String] = mutable.Map()
  val fileNameToLocation: mutable.Map[String, String] = mutable.Map()
  val types: mutable.Map[QName, WeaveTypeNode] = mutable.Map()
  var lastNamespaceNumber = 0

  lazy val modelResult: PhaseResult[XSModel] = {
    val impl = new XSImplementationImpl()
    val schemaCollector = SchemaCollector.getInstance(Charset.defaultCharset().toString).addSchema(resource.url(), resource.content())
    val schemaByTargetNamespace = getSchemasByTargetNamespace(schemaCollector.collect, isDisallowDoctypeDeclarations, None)
    val loader = impl.createXSLoader(null).asInstanceOf[XSLoaderImpl]
    val resolver = new ResourceResolver(schemaByTargetNamespace, resourceResolver, isDisallowDoctypeDeclarations)
    loader.setParameter(ENTITY_RESOLVER, new EntityResolverWrapper(new DOMEntityResolverWrapper(resolver)))
    loader.setParameter(XERCES_FEATURE_PREFIX + DISALLOW_DOCTYPE_DECL_FEATURE, isDisallowDoctypeDeclarations)
    loader.setParameter(XERCES_FEATURE_PREFIX + HONOUR_ALL_SCHEMALOCATIONS_FEATURE, true)
    var errors: Seq[(String, WeaveLocation)] = Seq()
    loader.setParameter(DOM_ERROR_HANDLER, new DOMErrorHandler {
      override def handleError(error: DOMError): Boolean = {
        val location = error.getLocation
        val position = SimpleParserPosition(location.getByteOffset, location.getLineNumber, location.getColumnNumber, () => "")
        errors = errors :+ (error.getMessage, WeaveLocation(position, position, moduleIdentifier))
        false
      }
    })
    val xsModel = loader.loadInputList(getLSInputList(schemaByTargetNamespace))
    val messageCollector = MessageCollector()
    for (error <- errors) {
      messageCollector.error(InvalidXmlSchemaMessage(error._1), error._2)
    }
    new PhaseResult(Option(xsModel), messageCollector)
  }

  private def isDisallowDoctypeDeclarations: Boolean = {
    val expandEntitiesValue = System.getProperty(EXPAND_ENTITIES_PROPERTY, "false")
    !parseBoolean(expandEntitiesValue)
  }

  def getNamespaceDirectives: List[NamespaceDirective] = {
    namespaces.map(entry => {
      NamespaceDirective(NameIdentifier(entry._2), UriNode(entry._1))
    }).toList
  }

  def getNextNsPrefix: String = {
    val nsPrefix = "ns" + lastNamespaceNumber.toString
    lastNamespaceNumber = lastNamespaceNumber + 1
    nsPrefix
  }

}
