package org.mule.weave.v2.module.xmlschema.handler
import org.mule.apache.xerces.impl.dv.xs.XSSimpleTypeDecl
import org.mule.weave.v2.module.xmlschema.utils.XmlConstants.XSD_BOOLEAN
import org.mule.weave.v2.parser.ast.types.{ TypeReferenceNode, WeaveTypeNode }
import org.mule.weave.v2.parser.ast.variables.NameIdentifier

import javax.xml.namespace.QName

class BooleanHandler extends XmlHandler {

  val BOOLEAN_TYPES: List[QName] = List(XSD_BOOLEAN)

  override def handles(schema: QName): Boolean = BOOLEAN_TYPES.contains(schema)

  override def handle(xsTypeDefinition: XSSimpleTypeDecl, defaultValue: Option[String]): WeaveTypeNode = {
    TypeReferenceNode(NameIdentifier("Boolean"))
  }
}
