package org.mule.weave.v2.module.xmlschema.handler

import org.mule.apache.xerces.impl.dv.xs.XSSimpleTypeDecl
import org.mule.weave.v2.module.xmlschema.utils.XmlConstants
import org.mule.weave.v2.parser.ast.types.TypeReferenceNode
import org.mule.weave.v2.parser.ast.types.WeaveTypeNode
import org.mule.weave.v2.parser.ast.variables.NameIdentifier
import javax.xml.namespace.QName

class NumberHandler extends XmlHandler {

  val NUMBER_TYPES: List[QName] = List(XmlConstants.XSD_BYTE, XmlConstants.XSD_INT, XmlConstants.XSD_INTEGER, XmlConstants.XSD_SHORT,
    XmlConstants.XSD_NEGATIVEINTEGER, XmlConstants.XSD_NONNEGATIVEINTEGER,
    XmlConstants.XSD_NONPOSITIVEINTEGER, XmlConstants.XSD_POSITIVEINTEGER, XmlConstants.XSD_UNSIGNEDBYTE,
    XmlConstants.XSD_UNSIGNEDINT, XmlConstants.XSD_UNSIGNEDSHORT, XmlConstants.XSD_LONG,
    XmlConstants.XSD_UNSIGNEDLONG,
    XmlConstants.XSD_FLOAT, XmlConstants.XSD_DOUBLE, XmlConstants.XSD_DECIMAL)

  override def handles(schema: QName): Boolean = NUMBER_TYPES.contains(schema)

  override def handle(xsTypeDefinition: XSSimpleTypeDecl, defaultValue: Option[String]): WeaveTypeNode = {
    TypeReferenceNode(NameIdentifier("Number"), None, None)
  }
}
