/*
 * Decompiled with CFR 0.152.
 */
package org.mule.wsdl.parser;

import com.ibm.wsdl.extensions.schema.SchemaSerializer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.ExtensionSerializer;
import javax.wsdl.extensions.http.HTTPAddress;
import javax.wsdl.extensions.mime.MIMEPart;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap12.SOAP12Address;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.mule.wsdl.parser.WsdlSchemaCollector;
import org.mule.wsdl.parser.model.OperationModel;
import org.mule.wsdl.parser.model.PortModel;
import org.mule.wsdl.parser.model.ServiceModel;
import org.mule.wsdl.parser.model.WsdlModel;
import org.mule.wsdl.parser.type.InputTypeParser;
import org.mule.wsdl.parser.type.OutputTypeParser;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 #2\u00020\u0001:\u0001#B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00192\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u00192\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010!\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020\u0003H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006$"}, d2={"Lorg/mule/wsdl/parser/WsdlParser;", "", "wsdlLocation", "", "(Ljava/lang/String;)V", "definition", "Ljavax/wsdl/Definition;", "inputTypeParser", "Lorg/mule/wsdl/parser/type/InputTypeParser;", "outputTypeParser", "Lorg/mule/wsdl/parser/type/OutputTypeParser;", "schemaCollector", "Lorg/mule/wsdl/parser/WsdlSchemaCollector;", "wsdl", "Lorg/mule/wsdl/parser/model/WsdlModel;", "getWsdl$mule_wsdl_parser", "()Lorg/mule/wsdl/parser/model/WsdlModel;", "findSoapAddress", "port", "Ljavax/wsdl/Port;", "initExtensionRegistry", "Ljavax/wsdl/extensions/ExtensionRegistry;", "factory", "Ljavax/wsdl/factory/WSDLFactory;", "parseOperations", "", "Lorg/mule/wsdl/parser/model/OperationModel;", "parsePorts", "Lorg/mule/wsdl/parser/model/PortModel;", "service", "Ljavax/wsdl/Service;", "parseServices", "Lorg/mule/wsdl/parser/model/ServiceModel;", "parseWsdl", "location", "Companion", "mule-wsdl-parser"})
public final class WsdlParser {
    private final Definition definition;
    private final WsdlSchemaCollector schemaCollector;
    private final InputTypeParser inputTypeParser;
    private final OutputTypeParser outputTypeParser;
    @NotNull
    private final WsdlModel wsdl;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final WsdlModel getWsdl$mule_wsdl_parser() {
        return this.wsdl;
    }

    /*
     * WARNING - void declaration
     */
    private final List<ServiceModel> parseServices(Definition definition) {
        Object object;
        Collection collection;
        Service item$iv$iv;
        Object $receiver$iv$iv;
        Object $receiver$iv = definition.getServices();
        Map map = $receiver$iv;
        Collection destination$iv$iv = new ArrayList($receiver$iv.size());
        Iterator iterator = $receiver$iv$iv;
        Iterator iterator2 = iterator.entrySet().iterator();
        while (iterator2.hasNext()) {
            Object v;
            void $$_$_v;
            Service service = item$iv$iv = iterator2.next();
            collection = destination$iv$iv;
            void var9_9 = $$_$_v;
            Object v2 = v = var9_9.getValue();
            if (v2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type javax.wsdl.Service");
            }
            object = (Service)v2;
            collection.add(object);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        iterator = $receiver$iv$iv.iterator();
        while (iterator.hasNext()) {
            void s;
            Object item$iv$iv2 = iterator.next();
            item$iv$iv = (Service)item$iv$iv2;
            collection = destination$iv$iv;
            String string = s.getQName().getLocalPart();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"s.qName.localPart");
            QName qName = s.getQName();
            Intrinsics.checkExpressionValueIsNotNull((Object)qName, (String)"s.qName");
            object = new ServiceModel(string, qName, this.parsePorts((Service)s));
            collection.add(object);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<PortModel> parsePorts(Service service) {
        Object object;
        Collection collection;
        Port item$iv$iv;
        Object $receiver$iv$iv;
        Object $receiver$iv = service.getPorts();
        Map map = $receiver$iv;
        Collection destination$iv$iv = new ArrayList($receiver$iv.size());
        Iterator iterator = $receiver$iv$iv;
        Iterator iterator2 = iterator.entrySet().iterator();
        while (iterator2.hasNext()) {
            Object v;
            void $$_$_v;
            Port port = item$iv$iv = iterator2.next();
            collection = destination$iv$iv;
            void var9_9 = $$_$_v;
            Object v2 = v = var9_9.getValue();
            if (v2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type javax.wsdl.Port");
            }
            object = (Port)v2;
            collection.add(object);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        iterator = $receiver$iv$iv.iterator();
        while (iterator.hasNext()) {
            void p;
            Object item$iv$iv2 = iterator.next();
            item$iv$iv = (Port)item$iv$iv2;
            collection = destination$iv$iv;
            String string = p.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"p.name");
            object = new PortModel(string, this.parseOperations((Port)p), this.findSoapAddress((Port)p));
            collection.add(object);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<OperationModel> parseOperations(Port port) {
        Object object;
        BindingOperation v;
        Collection collection;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv = port.getBinding().getBindingOperations();
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        Iterator iterator = $receiver$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object item$iv$iv;
            Object t = item$iv$iv = iterator.next();
            collection = destination$iv$iv;
            void v0 = v;
            if (v0 == null) {
                throw new TypeCastException("null cannot be cast to non-null type javax.wsdl.BindingOperation");
            }
            object = (BindingOperation)v0;
            collection.add(object);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void bop;
            v = (BindingOperation)item$iv$iv;
            collection = destination$iv$iv;
            String string = bop.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"bop.name");
            object = new OperationModel(string, this.inputTypeParser.getParts((BindingOperation)bop), this.outputTypeParser.getParts((BindingOperation)bop));
            collection.add(object);
        }
        return (List)destination$iv$iv;
    }

    private final Definition parseWsdl(String location) {
        try {
            WSDLFactory factory;
            WSDLFactory wSDLFactory = factory = WSDLFactory.newInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)wSDLFactory, (String)"factory");
            ExtensionRegistry registry = this.initExtensionRegistry(wSDLFactory);
            WSDLReader wsdlReader = factory.newWSDLReader();
            wsdlReader.setExtensionRegistry(registry);
            wsdlReader.setFeature("javax.wsdl.verbose", false);
            wsdlReader.setFeature("javax.wsdl.importDocuments", true);
            Definition definition = wsdlReader.readWSDL(location);
            Intrinsics.checkExpressionValueIsNotNull((Object)definition, (String)"wsdlReader.readWSDL(location)");
            return definition;
        }
        catch (WSDLException var5) {
            throw (Throwable)new RuntimeException("");
        }
    }

    private final ExtensionRegistry initExtensionRegistry(WSDLFactory factory) {
        ExtensionRegistry registry = factory.newPopulatedExtensionRegistry();
        registry.registerSerializer(Types.class, new QName("http://www.w3.org/2001/XMLSchema", "schema"), (ExtensionSerializer)new SchemaSerializer());
        QName header = new QName("http://schemas.xmlsoap.org/wsdl/soap/", "header");
        registry.registerDeserializer(MIMEPart.class, header, registry.queryDeserializer(BindingInput.class, header));
        registry.registerSerializer(MIMEPart.class, header, registry.querySerializer(BindingInput.class, header));
        Class<?> clazz = registry.createExtension(BindingInput.class, header).getClass();
        registry.mapExtensionTypes(MIMEPart.class, header, clazz);
        ExtensionRegistry extensionRegistry = registry;
        Intrinsics.checkExpressionValueIsNotNull((Object)extensionRegistry, (String)"registry");
        return extensionRegistry;
    }

    private final String findSoapAddress(Port port) {
        for (Object element : port.getExtensibilityElements()) {
            if (element instanceof SOAPAddress) {
                return ((SOAPAddress)element).getLocationURI();
            }
            if (element instanceof SOAP12Address) {
                return ((SOAP12Address)element).getLocationURI();
            }
            if (!(element instanceof HTTPAddress)) continue;
            return ((HTTPAddress)element).getLocationURI();
        }
        return null;
    }

    private WsdlParser(String wsdlLocation) {
        this.definition = this.parseWsdl(wsdlLocation);
        this.schemaCollector = new WsdlSchemaCollector(this.definition);
        this.inputTypeParser = new InputTypeParser(this.definition, this.schemaCollector.getCollector());
        this.outputTypeParser = new OutputTypeParser(this.definition, this.schemaCollector.getCollector());
        this.wsdl = new WsdlModel(wsdlLocation, this.parseServices(this.definition), this.schemaCollector.getParsedSchemas());
    }

    public /* synthetic */ WsdlParser(@NotNull String wsdlLocation, DefaultConstructorMarker $constructor_marker) {
        this(wsdlLocation);
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/mule/wsdl/parser/WsdlParser$Companion;", "", "()V", "parse", "Lorg/mule/wsdl/parser/model/WsdlModel;", "wsdlLocation", "", "mule-wsdl-parser"})
    public static final class Companion {
        @NotNull
        public final WsdlModel parse(@NotNull String wsdlLocation) {
            Intrinsics.checkParameterIsNotNull((Object)wsdlLocation, (String)"wsdlLocation");
            return new WsdlParser(wsdlLocation, null).getWsdl$mule_wsdl_parser();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

