/*
 * Decompiled with CFR 0.152.
 */
package org.mule.wsdl.parser;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.function.BiConsumer;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Types;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.extensions.schema.SchemaImport;
import javax.wsdl.extensions.schema.SchemaReference;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.mule.metadata.xml.SchemaCollector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\fH\u0002J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\fH\u0002J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\fH\u0002J\u0012\u0010\u0012\u001a\u00020\u000e2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0014\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006H\u0002R\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/mule/wsdl/parser/WsdlSchemaCollector;", "", "definition", "Ljavax/wsdl/Definition;", "(Ljavax/wsdl/Definition;)V", "parsedSchemas", "", "", "getParsedSchemas", "()Ljava/util/Map;", "schemas", "", "Ljavax/wsdl/extensions/schema/Schema;", "addImportedSchemas", "", "schema", "addIncludedSchemas", "addSchema", "collectFromTypes", "types", "Ljavax/wsdl/Types;", "collectSchemas", "getCollector", "Lorg/mule/metadata/xml/SchemaCollector;", "nodeToString", "node", "Lorg/w3c/dom/Node;", "parseSchemas", "mule-wsdl-parser"})
public final class WsdlSchemaCollector {
    private final Map<String, Schema> schemas;
    @NotNull
    private final Map<String, String> parsedSchemas;

    @NotNull
    public final Map<String, String> getParsedSchemas() {
        return this.parsedSchemas;
    }

    @NotNull
    public final SchemaCollector getCollector() {
        SchemaCollector collector = SchemaCollector.getInstance();
        this.parsedSchemas.forEach(new BiConsumer<String, String>(collector){
            final /* synthetic */ SchemaCollector $collector;

            public final void accept(@NotNull String uri, @NotNull String schema) {
                Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
                Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                this.$collector.addSchema(uri, schema);
            }
            {
                this.$collector = schemaCollector;
            }
        });
        SchemaCollector schemaCollector = collector;
        Intrinsics.checkExpressionValueIsNotNull((Object)schemaCollector, (String)"collector");
        return schemaCollector;
    }

    private final Map<String, String> parseSchemas() {
        Map schemaStreams = new LinkedHashMap();
        this.schemas.forEach(new BiConsumer<String, Schema>(this, schemaStreams){
            final /* synthetic */ WsdlSchemaCollector this$0;
            final /* synthetic */ Map $schemaStreams;

            public final void accept(@NotNull String uri, @NotNull Schema schema) {
                Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
                Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
                try {
                    String string = uri;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"uri");
                    Element element = schema.getElement();
                    Intrinsics.checkExpressionValueIsNotNull((Object)element, (String)"schema.element");
                    this.$schemaStreams.put(string, WsdlSchemaCollector.access$nodeToString(this.this$0, element));
                }
                catch (Exception e) {
                    String message = StringsKt.endsWith$default((String)uri, (String)".wsdl", (boolean)false, (int)2, null) ? "Schema embedded in wsdl [" + uri + "]" : "Schema [" + uri + "]";
                    throw (Throwable)new RuntimeException(message + " could not be parsed", e);
                }
            }
            {
                this.this$0 = wsdlSchemaCollector;
                this.$schemaStreams = map;
            }
        });
        return MapsKt.toMap((Map)schemaStreams);
    }

    private final void collectSchemas(Definition definition) {
        this.collectFromTypes(definition.getTypes());
        Iterable $receiver$iv = definition.getImports().values();
        for (Object element$iv : $receiver$iv) {
            Object wsdlImport = element$iv;
            if (!(wsdlImport instanceof Import)) continue;
            Definition definition2 = ((Import)wsdlImport).getDefinition();
            Intrinsics.checkExpressionValueIsNotNull((Object)definition2, (String)"wsdlImport.definition");
            this.collectSchemas(definition2);
        }
    }

    private final void collectFromTypes(Types types) {
        Object object = types;
        if (object != null && (object = object.getExtensibilityElements()) != null) {
            Iterable $receiver$iv = (Iterable)object;
            for (Object element$iv : $receiver$iv) {
                Object element = element$iv;
                if (!(element instanceof Schema)) continue;
                this.addSchema((Schema)element);
            }
        }
    }

    private final void addSchema(Schema schema) {
        String key = schema.getDocumentBaseURI();
        if (!this.schemas.containsKey(key)) {
            String string = key;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"key");
            this.schemas.put(string, schema);
            this.addImportedSchemas(schema);
            this.addIncludedSchemas(schema);
        }
    }

    private final void addImportedSchemas(Schema schema) {
        Iterable $receiver$iv = schema.getImports().values();
        Iterator iterator = $receiver$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv;
            Object v;
            Object t = v = (element$iv = iterator.next());
            if (t == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.Vector<*>");
            }
            Iterable $receiver$iv2 = (Vector)t;
            for (Object element$iv2 : $receiver$iv2) {
                Object e = element$iv2;
                if (!(e instanceof SchemaImport)) continue;
                Schema schema2 = ((SchemaImport)e).getReferencedSchema();
                Intrinsics.checkExpressionValueIsNotNull((Object)schema2, (String)"e.referencedSchema");
                this.addSchema(schema2);
            }
        }
    }

    private final void addIncludedSchemas(Schema schema) {
        Iterable $receiver$iv = schema.getIncludes();
        for (Object element$iv : $receiver$iv) {
            Object include = element$iv;
            if (!(include instanceof SchemaReference)) continue;
            Schema schema2 = ((SchemaReference)include).getReferencedSchema();
            Intrinsics.checkExpressionValueIsNotNull((Object)schema2, (String)"include.referencedSchema");
            this.addSchema(schema2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final String nodeToString(Node node) {
        try {
            Iterator $receiver$iv$iv;
            Iterable $receiver$iv;
            node.normalize();
            XPath xpath = XPathFactory.newInstance().newXPath();
            XPathExpression expr = xpath.compile("//text()[normalize-space()='']");
            Object object = expr.evaluate(node, XPathConstants.NODESET);
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.w3c.dom.NodeList");
            }
            NodeList nodeList = (NodeList)object;
            Iterable iterable = $receiver$iv = (Iterable)new IntRange(0, nodeList.getLength() - 1);
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            Iterator iterator = $receiver$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it;
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator).nextInt();
                Collection collection = destination$iv$iv;
                Node node2 = nodeList.item((int)it);
                collection.add(node2);
            }
            $receiver$iv = (List)destination$iv$iv;
            for (Object element$iv : $receiver$iv) {
                Node it = (Node)element$iv;
                it.getParentNode().removeChild(it);
            }
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            StringWriter writer = new StringWriter();
            transformer.transform(new DOMSource(node), new StreamResult(writer));
            String string = writer.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"writer.toString()");
            return string;
        }
        catch (Exception e) {
            throw (Throwable)new RuntimeException(e);
        }
    }

    public WsdlSchemaCollector(@NotNull Definition definition) {
        Intrinsics.checkParameterIsNotNull((Object)definition, (String)"definition");
        WsdlSchemaCollector wsdlSchemaCollector = this;
        HashMap hashMap = new HashMap();
        wsdlSchemaCollector.schemas = hashMap;
        this.collectSchemas(definition);
        this.parsedSchemas = this.parseSchemas();
    }

    @NotNull
    public static final /* synthetic */ String access$nodeToString(WsdlSchemaCollector $this, @NotNull Node node) {
        return $this.nodeToString(node);
    }
}

