/*
 * Decompiled with CFR 0.152.
 */
package org.mule.wsdl.parser.locator;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import javax.wsdl.xml.WSDLLocator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.cxf.resource.URIResolver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mule.wsdl.parser.exception.WsdlParsingException;
import org.mule.wsdl.parser.locator.GlobalResourceLocator;
import org.mule.wsdl.parser.locator.ResourceLocator;
import org.xml.sax.InputSource;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\n\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0003H\u0016J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0017\u001a\u00020\u0003H\u0002J\b\u0010\u0018\u001a\u00020\u0003H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\f0\u000bj\b\u0012\u0004\u0012\u00020\f`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/mule/wsdl/parser/locator/WsdlLocator;", "Ljavax/wsdl/xml/WSDLLocator;", "wsdlLocation", "", "resourceLocator", "Lorg/mule/wsdl/parser/locator/ResourceLocator;", "(Ljava/lang/String;Lorg/mule/wsdl/parser/locator/ResourceLocator;)V", "fallbackLocator", "Lorg/mule/wsdl/parser/locator/GlobalResourceLocator;", "latestImportUri", "streams", "Ljava/util/ArrayList;", "Ljava/io/InputStream;", "Lkotlin/collections/ArrayList;", "close", "", "getBaseInputSource", "Lorg/xml/sax/InputSource;", "getBaseURI", "getImportInputSource", "parentLocation", "importLocation", "getInputSource", "url", "getLatestImportURI", "mule-wsdl-parser"})
public final class WsdlLocator
implements WSDLLocator {
    private final ArrayList<InputStream> streams;
    private final GlobalResourceLocator fallbackLocator;
    private String latestImportUri;
    private final String wsdlLocation;
    private final ResourceLocator resourceLocator;

    @Nullable
    public InputSource getBaseInputSource() {
        return this.getInputSource(this.wsdlLocation);
    }

    @Nullable
    public InputSource getImportInputSource(@NotNull String parentLocation, @NotNull String importLocation) {
        String resolved;
        String string;
        Intrinsics.checkParameterIsNotNull((Object)parentLocation, (String)"parentLocation");
        Intrinsics.checkParameterIsNotNull((Object)importLocation, (String)"importLocation");
        try {
            String string2 = new URIResolver(parentLocation, importLocation).getURI().toURL().toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"URIResolver(parentLocati\u2026n).uri.toURL().toString()");
            string = string2;
        }
        catch (Exception e) {
            String string3 = new URI(parentLocation).resolve(importLocation).toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"URI(parentLocation).reso\u2026mportLocation).toString()");
            string = string3;
        }
        this.latestImportUri = resolved = string;
        return this.getInputSource(resolved);
    }

    @NotNull
    public String getBaseURI() {
        return this.wsdlLocation;
    }

    @NotNull
    public String getLatestImportURI() {
        return this.latestImportUri;
    }

    public void close() {
        Iterable $this$forEach$iv = this.streams;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            InputStream stream = (InputStream)element$iv;
            boolean bl = false;
            try {
                stream.close();
            }
            catch (IOException iOException) {
            }
        }
    }

    private final InputSource getInputSource(String url) {
        try {
            ResourceLocator locator = this.resourceLocator.handles(url) ? this.resourceLocator : (ResourceLocator)this.fallbackLocator;
            InputStream resource = locator.getResource(url);
            this.streams.add(resource);
            return new InputSource(resource);
        }
        catch (Exception e) {
            throw (Throwable)new WsdlParsingException("Error fetching the resource [" + url + "]: " + e.getMessage(), e);
        }
    }

    public WsdlLocator(@NotNull String wsdlLocation, @NotNull ResourceLocator resourceLocator) {
        Intrinsics.checkParameterIsNotNull((Object)wsdlLocation, (String)"wsdlLocation");
        Intrinsics.checkParameterIsNotNull((Object)resourceLocator, (String)"resourceLocator");
        this.wsdlLocation = wsdlLocation;
        this.resourceLocator = resourceLocator;
        this.streams = new ArrayList();
        this.fallbackLocator = new GlobalResourceLocator();
        this.latestImportUri = this.wsdlLocation;
    }
}

