/*
 * Decompiled with CFR 0.152.
 */
package org.mule.wsdl.parser.locator;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.wsdl.xml.WSDLLocator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.cxf.resource.URIResolver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mule.wsdl.parser.exception.WsdlParsingException;
import org.mule.wsdl.parser.locator.GlobalResourceLocator;
import org.mule.wsdl.parser.locator.ResourceLocator;
import org.xml.sax.InputSource;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\n\u0010\u0010\u001a\u0004\u0018\u00010\fH\u0016J\b\u0010\u0011\u001a\u00020\u0003H\u0016J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0003H\u0016J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0016\u001a\u00020\u0003H\u0002J\b\u0010\u0017\u001a\u00020\u0003H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\n\u001a\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\f0\u000bj\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\f`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/mule/wsdl/parser/locator/WsdlLocator;", "Ljavax/wsdl/xml/WSDLLocator;", "wsdlLocation", "", "resourceLocator", "Lorg/mule/wsdl/parser/locator/ResourceLocator;", "(Ljava/lang/String;Lorg/mule/wsdl/parser/locator/ResourceLocator;)V", "fallbackLocator", "Lorg/mule/wsdl/parser/locator/GlobalResourceLocator;", "latestImportUri", "sources", "Ljava/util/HashMap;", "Lorg/xml/sax/InputSource;", "Lkotlin/collections/HashMap;", "close", "", "getBaseInputSource", "getBaseURI", "getImportInputSource", "parentLocation", "importLocation", "getInputSource", "url", "getLatestImportURI", "mule-wsdl-parser"})
public final class WsdlLocator
implements WSDLLocator {
    private final GlobalResourceLocator fallbackLocator;
    private final HashMap<String, InputSource> sources;
    private String latestImportUri;
    private final String wsdlLocation;
    private final ResourceLocator resourceLocator;

    @Nullable
    public InputSource getBaseInputSource() {
        return this.getInputSource(this.wsdlLocation);
    }

    @Nullable
    public InputSource getImportInputSource(@NotNull String parentLocation, @NotNull String importLocation) {
        Intrinsics.checkParameterIsNotNull((Object)parentLocation, (String)"parentLocation");
        Intrinsics.checkParameterIsNotNull((Object)importLocation, (String)"importLocation");
        String resolved = null;
        resolved = StringsKt.startsWith$default((String)parentLocation, (String)"http://", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)parentLocation, (String)"https://", (boolean)false, (int)2, null) ? new URI(parentLocation).resolve(importLocation).toString() : new URIResolver(parentLocation, importLocation).getURI().toURL().toString();
        this.latestImportUri = resolved;
        Map map = this.sources;
        boolean bl = false;
        Map map2 = map;
        boolean bl2 = false;
        return map2.containsKey(resolved) ? this.sources.get(resolved) : this.getInputSource(resolved);
    }

    @NotNull
    public String getBaseURI() {
        return this.wsdlLocation;
    }

    @NotNull
    public String getLatestImportURI() {
        return this.latestImportUri;
    }

    public void close() {
        Collection<InputSource> collection = this.sources.values();
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"sources.values");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            InputSource source = (InputSource)element$iv;
            boolean bl = false;
            try {
                InputSource inputSource = source;
                Intrinsics.checkExpressionValueIsNotNull((Object)inputSource, (String)"source");
                inputSource.getByteStream().close();
            }
            catch (IOException iOException) {
            }
        }
    }

    private final InputSource getInputSource(String url) {
        try {
            ResourceLocator locator = this.resourceLocator.handles(url) ? this.resourceLocator : (ResourceLocator)this.fallbackLocator;
            InputStream resource = locator.getResource(url);
            InputSource source = new InputSource(resource);
            ((Map)this.sources).put(url, source);
            return source;
        }
        catch (Exception e) {
            throw (Throwable)new WsdlParsingException("Error fetching the resource [" + url + "]: " + e.getMessage(), e);
        }
    }

    public WsdlLocator(@NotNull String wsdlLocation, @NotNull ResourceLocator resourceLocator) {
        Intrinsics.checkParameterIsNotNull((Object)wsdlLocation, (String)"wsdlLocation");
        Intrinsics.checkParameterIsNotNull((Object)resourceLocator, (String)"resourceLocator");
        this.wsdlLocation = wsdlLocation;
        this.resourceLocator = resourceLocator;
        this.fallbackLocator = new GlobalResourceLocator();
        this.sources = new HashMap();
        this.latestImportUri = this.wsdlLocation;
    }
}

