/*
 * Decompiled with CFR 0.152.
 */
package org.mule.policies.model.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.mule.policies.grammar.PoliciesBuilder;
import org.mule.policies.grammar.PoliciesGrammar;
import org.raml.v2.api.loader.DefaultResourceLoader;
import org.raml.v2.api.loader.ResourceLoader;
import org.raml.yagi.framework.grammar.rule.Rule;
import org.raml.yagi.framework.nodes.EmptyErrorNode;
import org.raml.yagi.framework.nodes.ErrorNode;
import org.raml.yagi.framework.nodes.KeyValueNode;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.nodes.ObjectNode;
import org.raml.yagi.framework.nodes.StringNode;
import org.raml.yagi.framework.suggester.ParsingContext;
import org.raml.yagi.framework.suggester.ParsingContextType;
import org.raml.yagi.framework.suggester.Suggestion;
import org.raml.yagi.framework.suggester.Suggestions;
import org.raml.yagi.framework.util.NodeUtils;

public class YamlPolicySuggester {
    private ResourceLoader resourceLoader;

    public YamlPolicySuggester(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public YamlPolicySuggester() {
        this((ResourceLoader)new DefaultResourceLoader());
    }

    public Suggestions suggestions(String document, int offset) {
        ArrayList<Suggestion> result = new ArrayList<Suggestion>();
        ParsingContext ramlParsingContext = this.getContext(document, offset);
        int location = ramlParsingContext.getLocation();
        String content = ramlParsingContext.getContent();
        List<Suggestion> suggestions = this.getSuggestions(ramlParsingContext, document, offset, location);
        if (content.isEmpty()) {
            result.addAll(suggestions);
        } else {
            for (Suggestion suggestion : suggestions) {
                if (!suggestion.getValue().startsWith(content)) continue;
                result.add(suggestion);
            }
        }
        Collections.sort(result);
        return new Suggestions(result, content, location);
    }

    private List<Suggestion> getSuggestions(ParsingContext context, String document, int offset, int location) {
        switch (context.getContextType()) {
            case ITEM: 
            case VALUE: {
                return this.getSuggestionsAt(context, document, offset, location);
            }
        }
        return this.getSuggestionByColumn(context, document, offset, location);
    }

    private List<Suggestion> getSuggestionsAt(ParsingContext context, String document, int offset, int location) {
        Node root = this.getRootNode(document, offset, location);
        Node node = NodeUtils.searchNodeAt((Node)root, (int)location);
        if (node != null) {
            if (node.getParent() instanceof KeyValueNode && node.getParent().getChildren().indexOf(node) == 0) {
                node = node.getParent().getParent();
            }
            List<Node> pathToRoot = this.createPathToRoot(node);
            Rule rootRule = this.getRuleFor();
            return rootRule != null ? rootRule.getSuggestions(pathToRoot, context) : Collections.emptyList();
        }
        return Collections.emptyList();
    }

    private Node getRootNode(String document, int offset, int location) {
        PoliciesBuilder policiesBuilder = new PoliciesBuilder();
        try {
            Node rootNode = policiesBuilder.build(document);
            if (rootNode instanceof StringNode) {
                Node rootNode2 = policiesBuilder.build(this.stripLastChanges(document, offset, location) + "\n\nstub: stub");
                if (rootNode2 instanceof ErrorNode) {
                    return policiesBuilder.build(this.removeChangedLine(document, offset, location) + "\n\nstub: stub");
                }
                return rootNode2;
            }
            if (!(rootNode instanceof ErrorNode)) {
                return rootNode;
            }
            if (rootNode instanceof EmptyErrorNode) {
                return policiesBuilder.build(document + "\n\nstub: stub");
            }
            return policiesBuilder.build(this.removeChangedLine(document, offset, location) + "\n\nstub: stub");
        }
        catch (Exception e) {
            return policiesBuilder.build(this.stripLastChanges(document, offset, location));
        }
    }

    private String removeChangedLine(String document, int offset, int location) {
        String header = document.substring(0, location + 1);
        String footer = this.getFooter1(document, offset);
        return header + footer;
    }

    private String stripLastChanges(String document, int offset, int location) {
        String header = document.substring(0, location + 1);
        String footer = this.getFooter(document, offset);
        return header + footer;
    }

    private List<Suggestion> getSuggestionByColumn(ParsingContext context, String document, int offset, int location) {
        int columnNumber = this.getColumnNumber(document, offset);
        Node root = this.getRootNode(document, offset, location);
        Node node = NodeUtils.searchNodeAt((Node)root, (int)location);
        if (node != null) {
            node = this.getValueNodeAtColumn(columnNumber, node);
            List<Node> pathToRoot = this.createPathToRoot(node);
            Rule rootRule = this.getRuleFor();
            return rootRule != null ? rootRule.getSuggestions(pathToRoot, context) : Collections.emptyList();
        }
        return Collections.emptyList();
    }

    @Nonnull
    private ParsingContext getContext(String document, int offset) {
        int location;
        ParsingContext context = null;
        StringBuilder content = new StringBuilder();
        block5: for (location = offset; location >= 0 && context == null; --location) {
            char character = document.charAt(location);
            switch (character) {
                case ':': {
                    context = new ParsingContext(ParsingContextType.VALUE, this.revertAndTrim(content), location + 1);
                    continue block5;
                }
                case ',': 
                case '-': 
                case '[': 
                case '{': {
                    context = new ParsingContext(ParsingContextType.ITEM, this.revertAndTrim(content), location);
                    continue block5;
                }
                case '\n': {
                    context = new ParsingContext(ParsingContextType.ANY, this.revertAndTrim(content), location);
                    continue block5;
                }
                default: {
                    content.append(character);
                }
            }
        }
        if (context == null) {
            context = new ParsingContext(ParsingContextType.ANY, this.revertAndTrim(content), location);
        }
        return context;
    }

    @Nonnull
    private String revertAndTrim(StringBuilder content) {
        return content.reverse().toString().trim();
    }

    private Node getValueNodeAtColumn(int columnNumber, Node node) {
        if (columnNumber == 0) {
            return node.getRootNode();
        }
        List<Node> path = this.createPathToRoot(node);
        for (Node element : path) {
            if (element instanceof KeyValueNode) {
                if (element.getStartPosition().getColumn() >= columnNumber) continue;
                node = ((KeyValueNode)element).getValue();
                continue;
            }
            if (!(element instanceof ObjectNode) || element.getStartPosition().getColumn() > columnNumber) continue;
            node = element;
        }
        return node;
    }

    @Nonnull
    private List<Node> createPathToRoot(Node node) {
        ArrayList<Node> path = new ArrayList<Node>();
        for (Node parent = node; parent != null; parent = parent.getParent()) {
            path.add(0, parent);
        }
        return path;
    }

    @Nonnull
    private String getFooter(String document, int offset) {
        int loc = offset;
        char current = document.charAt(loc);
        while (loc < document.length() && current != '\n' && current != '}' && current != ']' && current != ',' && ++loc != document.length()) {
            current = document.charAt(loc);
        }
        return loc < document.length() ? document.substring(loc) : "";
    }

    @Nonnull
    private String getFooter1(String document, int offset) {
        return this.getFooter(document, offset + 1);
    }

    private int getColumnNumber(String document, int offset) {
        StringBuilder contextLine = this.getContextLine(document, offset);
        int columnNumber = 0;
        for (int i = 0; i < contextLine.length() && Character.isWhitespace(contextLine.charAt(i)); ++i) {
            ++columnNumber;
        }
        return columnNumber;
    }

    @Nonnull
    private StringBuilder getContextLine(String document, int offset) {
        StringBuilder contextLine = new StringBuilder();
        if (offset < 0) {
            return contextLine;
        }
        int location = offset;
        char character = document.charAt(location);
        while (location > 0 && character != '\n') {
            contextLine.append(character);
            character = document.charAt(--location);
        }
        return contextLine.reverse();
    }

    @Nullable
    public Rule getRuleFor() {
        return new PoliciesGrammar().untitledPolicy();
    }
}

