package amf.plugins.document.vocabularies.registries

import java.util.concurrent.CompletableFuture

import amf.core.remote.FutureConverter._
import amf.core.unsafe.PlatformSecrets
import amf.plugins.document.vocabularies.spec.Dialect



object AMFDialectsRegistry extends PlatformSecrets {
  def register(url:String): CompletableFuture[Dialect] = PlatformDialectRegistry.registerDialect(url).asJava
  def register(url: String, dialectCode: String): CompletableFuture[Dialect] = PlatformDialectRegistry.registerDialect(url, dialectCode).asJava
}
