/*
 * Decompiled with CFR 0.152.
 */
package org.mule.jenkins;

import java.util.ArrayList;
import java.util.List;

public class JenkinsDeploymentException
extends Exception {
    public static final long serialVersionUID = -1L;
    protected List<InfoItem> infoItems = new ArrayList<InfoItem>();

    public JenkinsDeploymentException(String errorContext, String errorCode, String errorMessage) {
        this.addInfo(errorContext, errorCode, errorMessage);
    }

    public JenkinsDeploymentException(String errorContext, String errorCode, String errorMessage, Throwable cause) {
        super(cause);
        this.addInfo(errorContext, errorCode, errorMessage);
    }

    public JenkinsDeploymentException addInfo(String errorContext, String errorCode, String errorText) {
        this.infoItems.add(new InfoItem(errorContext, errorCode, errorText));
        return this;
    }

    public String getCode() {
        StringBuilder builder = new StringBuilder();
        for (int i = this.infoItems.size() - 1; i >= 0; --i) {
            InfoItem info = this.infoItems.get(i);
            builder.append('[');
            builder.append(info.errorContext);
            builder.append(':');
            builder.append(info.errorCode);
            builder.append(']');
        }
        return builder.toString();
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getCode());
        builder.append('\n');
        for (int i = this.infoItems.size() - 1; i >= 0; --i) {
            InfoItem info = this.infoItems.get(i);
            builder.append('[');
            builder.append(info.errorContext);
            builder.append(':');
            builder.append(info.errorCode);
            builder.append(']');
            builder.append(info.errorText);
            if (i <= 0) continue;
            builder.append('\n');
        }
        if (this.getMessage() != null) {
            builder.append('\n');
            if (this.getCause() == null) {
                builder.append(this.getMessage());
            } else if (!this.getMessage().equals(this.getCause().toString())) {
                builder.append(this.getMessage());
            }
        }
        this.appendException(builder, this.getCause());
        return builder.toString();
    }

    private void appendException(StringBuilder builder, Throwable throwable) {
        if (throwable == null) {
            return;
        }
        this.appendException(builder, throwable.getCause());
        builder.append(throwable.toString());
        builder.append('\n');
    }

    protected class InfoItem {
        public String errorContext = null;
        public String errorCode = null;
        public String errorText = null;

        public InfoItem(String contextCode, String errorCode, String errorText) {
            this.errorContext = contextCode;
            this.errorCode = errorCode;
            this.errorText = errorText;
        }
    }
}

