/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module;

import java.util.Map;
import org.mule.api.ConnectionException;
import org.mule.api.annotations.Configurable;
import org.mule.api.annotations.Connect;
import org.mule.api.annotations.ConnectionIdentifier;
import org.mule.api.annotations.Connector;
import org.mule.api.annotations.Disconnect;
import org.mule.api.annotations.Processor;
import org.mule.api.annotations.ValidateConnection;
import org.mule.api.annotations.param.ConnectionKey;
import org.mule.api.annotations.param.Optional;
import org.mule.jenkins.Helper;
import org.mule.jenkins.JenkinsConnectorException;
import org.mule.jenkins.JenkinsDeploymentException;
import org.mule.jenkins.model.BuildInfo;
import org.mule.jenkins.model.JenkinsInfo;
import org.mule.jenkins.model.JenkinsQueueInfo;
import org.mule.jenkins.model.JobInfo;

@Connector(name="jenkins", schemaVersion="1.0", friendlyName="Jenkins")
public class JenkinsConnector {
    @Configurable
    private String jenkinsURL;
    @Configurable
    @Optional
    private String username;
    @Configurable
    @Optional
    private String password;

    public void setJenkinsURL(String jenkinsURL) {
        this.jenkinsURL = jenkinsURL;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Connect
    public void connect(@ConnectionKey String connectionName) throws ConnectionException {
        Helper.setConnectionInfo(this.username, this.password, this.jenkinsURL);
    }

    @Disconnect
    public void disconnect() {
    }

    @ValidateConnection
    public boolean isConnected() {
        return Helper.isConnected();
    }

    @ConnectionIdentifier
    public String connectionId() {
        return "001";
    }

    @Processor
    public JenkinsInfo getJenkinsNodeInfo() throws JenkinsConnectorException {
        return Helper.getJenkinsInfo();
    }

    @Processor
    public JobInfo getJobInfo(String jobName) throws JenkinsConnectorException {
        return Helper.getJenkinsJobInfo(jobName);
    }

    @Processor
    public void buildWithParameters(String jobName, Map<String, String> params) throws JenkinsDeploymentException {
        Helper.buildWithParameters(jobName, params);
    }

    @Processor
    public void build(String jobName) throws JenkinsDeploymentException {
        Helper.build(jobName);
    }

    @Processor
    public JenkinsQueueInfo getQueueInfo() throws JenkinsConnectorException {
        return Helper.getQueueInfo();
    }

    @Processor
    public JobInfo createJob(String jobName) throws JenkinsConnectorException {
        return Helper.createJob(jobName);
    }

    @Processor
    public JobInfo copyJob(String newJobName, String fromJobName) throws JenkinsConnectorException {
        return Helper.copyFromJob(newJobName, fromJobName);
    }

    @Processor
    public void deleteJob(String jobName) throws JenkinsConnectorException {
        Helper.delete(jobName);
    }

    @Processor
    public void enableJob(String jobName) throws JenkinsConnectorException {
        Helper.enableJob(jobName);
    }

    @Processor
    public void disableJob(String jobName) throws JenkinsConnectorException {
        Helper.disableJob(jobName);
    }

    @Processor
    public BuildInfo getJobBuildInfo(String jobName, int buildNumber) throws JenkinsConnectorException {
        return Helper.getJobBuildInfo(jobName, buildNumber);
    }

    @Processor
    public String getJobBuildLog(String jobName, String buildNumber) throws JenkinsConnectorException {
        return Helper.getJobBuildLog(jobName, buildNumber);
    }

    public String getJenkinsURL() {
        return this.jenkinsURL;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }
}

