/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.connectivity;

import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.module.adapters.JenkinsConnectorConnectionIdentifierAdapter;
import org.mule.module.connectivity.JenkinsConnectorConnectionKey;
import org.mule.module.connectivity.JenkinsConnectorConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JenkinsConnectorConnectionFactory
implements KeyedPoolableObjectFactory {
    private static Logger logger = LoggerFactory.getLogger(JenkinsConnectorConnectionFactory.class);
    private JenkinsConnectorConnectionManager connectionManager;

    public JenkinsConnectorConnectionFactory(JenkinsConnectorConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public Object makeObject(Object key) throws Exception {
        if (!(key instanceof JenkinsConnectorConnectionKey)) {
            throw new RuntimeException("Invalid key type");
        }
        JenkinsConnectorConnectionIdentifierAdapter connector = new JenkinsConnectorConnectionIdentifierAdapter();
        connector.setJenkinsURL(this.connectionManager.getJenkinsURL());
        connector.setUsername(this.connectionManager.getUsername());
        connector.setPassword(this.connectionManager.getPassword());
        if (connector instanceof Initialisable) {
            connector.initialise();
        }
        if (connector instanceof MuleContextAware) {
            ((MuleContextAware)connector).setMuleContext(this.connectionManager.getMuleContext());
        }
        if (connector instanceof Startable) {
            connector.start();
        }
        return connector;
    }

    public void destroyObject(Object key, Object obj) throws Exception {
        if (!(key instanceof JenkinsConnectorConnectionKey)) {
            throw new RuntimeException("Invalid key type");
        }
        if (!(obj instanceof JenkinsConnectorConnectionIdentifierAdapter)) {
            throw new RuntimeException("Invalid connector type");
        }
        try {
            ((JenkinsConnectorConnectionIdentifierAdapter)obj).disconnect();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if ((JenkinsConnectorConnectionIdentifierAdapter)obj instanceof Stoppable) {
                ((Stoppable)obj).stop();
            }
            if ((JenkinsConnectorConnectionIdentifierAdapter)obj instanceof Disposable) {
                ((Disposable)obj).dispose();
            }
        }
    }

    public boolean validateObject(Object key, Object obj) {
        if (!(obj instanceof JenkinsConnectorConnectionIdentifierAdapter)) {
            throw new RuntimeException("Invalid connector type");
        }
        try {
            return ((JenkinsConnectorConnectionIdentifierAdapter)obj).isConnected();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public void activateObject(Object key, Object obj) throws Exception {
        if (!(key instanceof JenkinsConnectorConnectionKey)) {
            throw new RuntimeException("Invalid key type");
        }
        if (!(obj instanceof JenkinsConnectorConnectionIdentifierAdapter)) {
            throw new RuntimeException("Invalid connector type");
        }
        if (!((JenkinsConnectorConnectionIdentifierAdapter)obj).isConnected()) {
            ((JenkinsConnectorConnectionIdentifierAdapter)obj).connect(((JenkinsConnectorConnectionKey)key).getConnectionName());
        }
    }

    public void passivateObject(Object key, Object obj) throws Exception {
    }
}

