/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.process;

import org.mule.api.Connection;
import org.mule.api.ConnectionManager;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.UnableToAcquireConnectionException;
import org.mule.api.UnableToReleaseConnectionException;
import org.mule.api.process.ProcessCallback;
import org.mule.api.process.ProcessInterceptor;
import org.mule.api.processor.MessageProcessor;
import org.mule.module.adapters.JenkinsConnectorConnectionIdentifierAdapter;
import org.mule.module.connectivity.JenkinsConnectorConnectionKey;
import org.mule.module.processors.AbstractConnectedProcessor;
import org.mule.module.processors.AbstractExpressionEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedConnectionProcessInterceptor<T>
extends AbstractExpressionEvaluator
implements ProcessInterceptor<T, JenkinsConnectorConnectionIdentifierAdapter> {
    private static Logger logger = LoggerFactory.getLogger(ManagedConnectionProcessInterceptor.class);
    private final ConnectionManager<JenkinsConnectorConnectionKey, JenkinsConnectorConnectionIdentifierAdapter> connectionManager;
    private final MuleContext muleContext;
    private final ProcessInterceptor<T, JenkinsConnectorConnectionIdentifierAdapter> next;

    public ManagedConnectionProcessInterceptor(ProcessInterceptor<T, JenkinsConnectorConnectionIdentifierAdapter> next, ConnectionManager<JenkinsConnectorConnectionKey, JenkinsConnectorConnectionIdentifierAdapter> connectionManager, MuleContext muleContext) {
        this.next = next;
        this.connectionManager = connectionManager;
        this.muleContext = muleContext;
    }

    public T execute(ProcessCallback<T, JenkinsConnectorConnectionIdentifierAdapter> processCallback, JenkinsConnectorConnectionIdentifierAdapter object, MessageProcessor messageProcessor, MuleEvent event) throws Exception {
        Object _transformedConnectionName;
        JenkinsConnectorConnectionIdentifierAdapter connection = null;
        JenkinsConnectorConnectionKey key = null;
        if (messageProcessor != null && messageProcessor instanceof AbstractConnectedProcessor && ((AbstractConnectedProcessor)messageProcessor).getConnectionName() != null) {
            _transformedConnectionName = (String)this.evaluateAndTransform(this.muleContext, event, AbstractConnectedProcessor.class.getDeclaredField("_connectionNameType").getGenericType(), null, ((AbstractConnectedProcessor)messageProcessor).getConnectionName());
            key = new JenkinsConnectorConnectionKey((String)_transformedConnectionName);
        } else {
            key = (JenkinsConnectorConnectionKey)this.connectionManager.getDefaultConnectionKey();
        }
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Attempting to acquire connection using " + key.toString());
            }
            if ((connection = (JenkinsConnectorConnectionIdentifierAdapter)this.connectionManager.acquireConnection((Object)key)) == null) {
                throw new UnableToAcquireConnectionException();
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Connection has been acquired with [id=" + connection.getConnectionIdentifier() + "]");
            }
            _transformedConnectionName = this.next.execute(processCallback, (Object)connection, messageProcessor, event);
            return (T)_transformedConnectionName;
        }
        catch (Exception e) {
            if (processCallback.getManagedExceptions() != null) {
                for (Class exceptionClass : processCallback.getManagedExceptions()) {
                    if (!exceptionClass.isInstance(e)) continue;
                    if (logger.isDebugEnabled()) {
                        logger.debug("An exception ( " + exceptionClass.getName() + ") has been thrown. Destroying the connection with [id=" + connection.getConnectionIdentifier() + "]");
                    }
                    try {
                        this.connectionManager.destroyConnection((Object)key, (Connection)connection);
                        connection = null;
                    }
                    catch (Exception innerException) {
                        logger.error(innerException.getMessage(), (Throwable)innerException);
                    }
                }
            }
            throw e;
        }
        finally {
            try {
                if (connection != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Releasing the connection back into the pool [id=" + connection.getConnectionIdentifier() + "]");
                    }
                    this.connectionManager.releaseConnection((Object)key, (Connection)connection);
                }
            }
            catch (Exception e) {
                throw new UnableToReleaseConnectionException((Throwable)e);
            }
        }
    }
}

