/*
 * Decompiled with CFR 0.152.
 */
package org.mustangproject;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.mustangproject.Allowance;
import org.mustangproject.Charge;
import org.mustangproject.IncludedNote;
import org.mustangproject.Product;
import org.mustangproject.ReferencedDocument;
import org.mustangproject.SubjectCode;
import org.mustangproject.XMLTools;
import org.mustangproject.ZUGFeRD.IReferencedDocument;
import org.mustangproject.ZUGFeRD.IZUGFeRDAllowanceCharge;
import org.mustangproject.ZUGFeRD.IZUGFeRDExportableItem;
import org.mustangproject.util.NodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class Item
implements IZUGFeRDExportableItem {
    protected BigDecimal price = BigDecimal.ZERO;
    protected BigDecimal quantity;
    protected BigDecimal tax;
    protected BigDecimal grossPrice;
    protected BigDecimal lineTotalAmount;
    protected BigDecimal basisQuantity = BigDecimal.ONE;
    protected Date detailedDeliveryPeriodFrom = null;
    protected Date detailedDeliveryPeriodTo = null;
    protected String id;
    protected String referencedLineID = null;
    protected Product product;
    protected ArrayList<String> notes = null;
    protected ArrayList<ReferencedDocument> referencedDocuments = null;
    protected ArrayList<ReferencedDocument> additionalReference = null;
    protected ArrayList<IZUGFeRDAllowanceCharge> Allowances = new ArrayList();
    protected ArrayList<IZUGFeRDAllowanceCharge> Charges = new ArrayList();
    protected List<IncludedNote> includedNotes = null;

    public Item(Product product, BigDecimal price, BigDecimal quantity) {
        this.price = price;
        this.quantity = quantity;
        this.product = product;
    }

    public Item() {
    }

    public Item(NodeList itemChilds, boolean recalcPrice) {
        NodeMap itemMap = new NodeMap(itemChilds);
        itemMap.getAsNodeMap("Item").ifPresent(icnm -> {
            this.setProduct(new Product(itemMap.getNode("Item").get()));
            icnm.getAsString("Name").ifPresent(this.product::setName);
            icnm.getAsString("Description").ifPresent(this.product::setDescription);
            icnm.getAsNodeMap("SellersItemIdentification").ifPresent(SellersItemIdentification -> SellersItemIdentification.getAsString("ID").ifPresent(this.product::setSellerAssignedID));
            icnm.getAsNodeMap("BuyersItemIdentification").ifPresent(BuyersItemIdentification -> BuyersItemIdentification.getAsString("ID").ifPresent(this.product::setBuyerAssignedID));
            icnm.getAsNodeMap("ClassifiedTaxCategory").flatMap(m -> m.getAsBigDecimal("Percent")).ifPresent(this.product::setVATPercent);
        });
        itemMap.getAsNodeMap("AssociatedDocumentLineDocument").ifPresent(icnm -> icnm.getAsString("LineID").ifPresent(this::setId));
        itemMap.getAsNodeMap("Price").ifPresent(icnm -> {
            icnm.getAsBigDecimal("PriceAmount").ifPresent(this::setPrice);
            icnm.getAsBigDecimal("BaseQuantity").ifPresent(this::setBasisQuantity);
        });
        itemMap.getNode("InvoicedQuantity").ifPresent(icn -> {
            this.setQuantity(new BigDecimal(icn.getTextContent().trim()));
            this.product.setUnit(icn.getAttributes().getNamedItem("unitCode").getNodeValue());
        });
        itemMap.getAllNodes("DocumentReference").map(ReferencedDocument::fromNode).forEach(this::addAdditionalReference);
        itemMap.getAsNodeMap("OrderLineReference").flatMap(bordNodes -> bordNodes.getAsString("LineID")).ifPresent(this::addReferencedLineID);
        itemMap.getAsString("ID").ifPresent(this::setId);
        itemMap.getAsString("Note").ifPresent(this::addNote);
        itemMap.getAsNodeMap("SpecifiedLineTradeAgreement", "SpecifiedSupplyChainTradeAgreement").ifPresent(icnm -> {
            icnm.getAsNodeMap("BuyerOrderReferencedDocument").flatMap(bordNodes -> bordNodes.getAsString("LineID")).ifPresent(this::addReferencedLineID);
            icnm.getAsNodeMap("NetPriceProductTradePrice").ifPresent(npptpNodes -> {
                npptpNodes.getAsBigDecimal("ChargeAmount").ifPresent(this::setPrice);
                npptpNodes.getAsBigDecimal("BasisQuantity").ifPresent(this::setBasisQuantity);
            });
            icnm.getAllNodes("AdditionalReferencedDocument").map(ReferencedDocument::fromNode).forEach(this::addReferencedDocument);
        });
        itemMap.getNode("SpecifiedTradeProduct").map(Product::new).ifPresent(this::setProduct);
        itemMap.getNode("SpecifiedTradeProduct").map(Product::new).ifPresent(this::setProduct);
        itemMap.getAsNodeMap("SpecifiedLineTradeDelivery", "SpecifiedSupplyChainTradeDelivery").flatMap(icnm -> icnm.getNode("BilledQuantity", "RequestedQuantity", "DespatchedQuantity")).ifPresent(bq -> {
            Node unitAttr;
            this.setQuantity(new BigDecimal(bq.getTextContent().trim()));
            if (bq.hasAttributes() && (unitAttr = bq.getAttributes().getNamedItem("unitCode")) != null) {
                this.product.setUnit(unitAttr.getNodeValue());
            }
        });
        itemMap.getAsNodeMap("SpecifiedLineTradeSettlement", "SpecifiedSupplyChainTradeSettlement").ifPresent(icnm -> {
            icnm.getAsNodeMap("ApplicableTradeTax").flatMap(cnm -> cnm.getAsBigDecimal("RateApplicablePercent", "ApplicablePercent")).ifPresent(this.product::setVATPercent);
            icnm.getAsNodeMap("SpecifiedTradeAllowanceCharge").ifPresent(stac -> stac.getAsNodeMap("ChargeIndicator").ifPresent(ci -> {
                String isChargeString = ci.getAsString("Indicator").get();
                String percentString = stac.getAsStringOrNull("CalculationPercent");
                String amountString = stac.getAsStringOrNull("ActualAmount");
                String reason = stac.getAsStringOrNull("Reason");
                Charge izac = new Charge();
                izac = isChargeString.equalsIgnoreCase("false") ? new Allowance() : new Charge();
                if (amountString != null) {
                    izac.setTotalAmount(new BigDecimal(amountString));
                }
                izac.setPercent(new BigDecimal(percentString));
                izac.setReason(reason);
                if (isChargeString.equalsIgnoreCase("false")) {
                    this.addAllowance(izac);
                } else {
                    this.addCharge(izac);
                }
            }));
            if (recalcPrice && !BigDecimal.ZERO.equals(this.quantity)) {
                icnm.getAsNodeMap("SpecifiedTradeSettlementLineMonetarySummation").flatMap(cnm -> cnm.getAsBigDecimal("LineTotalAmount")).ifPresent(lineTotal -> this.setPrice(lineTotal.divide(this.quantity, 4, RoundingMode.HALF_UP)));
            }
            icnm.getAllNodes("AdditionalReferencedDocument").map(ReferencedDocument::fromNode).forEach(this::addAdditionalReference);
        });
        itemMap.getAsNodeMap("AssociatedDocumentLineDocument").ifPresent(adld -> {
            ArrayList<IncludedNote> includedNotes = new ArrayList<IncludedNote>();
            adld.getAllNodes("IncludedNote").forEach(item -> {
                String subjectCode = "";
                String content = null;
                NodeList includedNodeChilds = item.getChildNodes();
                for (int issueDateChildIndex = 0; issueDateChildIndex < includedNodeChilds.getLength(); ++issueDateChildIndex) {
                    if (includedNodeChilds.item(issueDateChildIndex).getLocalName() != null && includedNodeChilds.item(issueDateChildIndex).getLocalName().equals("Content")) {
                        content = XMLTools.trimOrNull(includedNodeChilds.item(issueDateChildIndex));
                    }
                    if (includedNodeChilds.item(issueDateChildIndex).getLocalName() == null || !includedNodeChilds.item(issueDateChildIndex).getLocalName().equals("SubjectCode")) continue;
                    subjectCode = XMLTools.trimOrNull(includedNodeChilds.item(issueDateChildIndex));
                }
                boolean foundCode = false;
                for (SubjectCode code : SubjectCode.values()) {
                    if (!code.toString().equals(subjectCode)) continue;
                    includedNotes.add(new IncludedNote(content, code));
                    foundCode = true;
                    break;
                }
                if (!foundCode) {
                    includedNotes.add(new IncludedNote(content, null));
                }
            });
            this.addNotes(includedNotes);
        });
    }

    public Item addReferencedLineID(String s) {
        this.referencedLineID = s;
        return this;
    }

    @Override
    public String getBuyerOrderReferencedDocumentLineID() {
        return this.referencedLineID;
    }

    public BigDecimal getLineTotalAmount() {
        return this.lineTotalAmount;
    }

    public Item setNotesWithSubjectCode(List<IncludedNote> theList) {
        this.includedNotes = theList;
        return this;
    }

    public Item setLineTotalAmount(BigDecimal lineTotalAmount) {
        this.lineTotalAmount = lineTotalAmount;
        return this;
    }

    public BigDecimal getGrossPrice() {
        return this.grossPrice;
    }

    public Item setGrossPrice(BigDecimal grossPrice) {
        this.grossPrice = grossPrice;
        return this;
    }

    public BigDecimal getTax() {
        return this.tax;
    }

    public Item setTax(BigDecimal tax) {
        this.tax = tax;
        return this;
    }

    public Item setId(String id) {
        this.id = id;
        return this;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public BigDecimal getPrice() {
        return this.price;
    }

    public Item setPrice(BigDecimal price) {
        this.price = price;
        return this;
    }

    @Override
    public BigDecimal getBasisQuantity() {
        return this.basisQuantity;
    }

    public Item setBasisQuantity(BigDecimal basis) {
        this.basisQuantity = basis;
        return this;
    }

    @Override
    public BigDecimal getQuantity() {
        return this.quantity;
    }

    public Item setQuantity(BigDecimal quantity) {
        this.quantity = quantity;
        return this;
    }

    @Override
    public Product getProduct() {
        return this.product;
    }

    @Override
    public IZUGFeRDAllowanceCharge[] getItemAllowances() {
        if (this.Allowances.isEmpty()) {
            return null;
        }
        return this.Allowances.toArray(new IZUGFeRDAllowanceCharge[0]);
    }

    @Override
    public IZUGFeRDAllowanceCharge[] getItemCharges() {
        if (this.Charges.isEmpty()) {
            return null;
        }
        return this.Charges.toArray(new IZUGFeRDAllowanceCharge[0]);
    }

    @Override
    public String[] getNotes() {
        if (this.notes == null) {
            return null;
        }
        return this.notes.toArray(new String[0]);
    }

    public Item setProduct(Product product) {
        this.product = product;
        return this;
    }

    public Item addCharge(IZUGFeRDAllowanceCharge izac) {
        this.Charges.add(izac);
        return this;
    }

    public Item addAllowance(IZUGFeRDAllowanceCharge izac) {
        this.Allowances.add(izac);
        return this;
    }

    public Item addNote(String text) {
        if (this.notes == null) {
            this.notes = new ArrayList();
        }
        this.notes.add(text);
        this.addNote(IncludedNote.unspecifiedNote(text));
        return this;
    }

    public Item addNote(IncludedNote theNote) {
        if (this.includedNotes == null) {
            this.includedNotes = new ArrayList<IncludedNote>();
        }
        this.includedNotes.add(theNote);
        return this;
    }

    public Item addReferencedDocument(ReferencedDocument doc) {
        if (this.referencedDocuments == null) {
            this.referencedDocuments = new ArrayList();
        }
        this.referencedDocuments.add(doc);
        return this;
    }

    @Override
    public IReferencedDocument[] getReferencedDocuments() {
        if (this.referencedDocuments == null) {
            return null;
        }
        return this.referencedDocuments.toArray(new IReferencedDocument[0]);
    }

    public Item addAdditionalReference(ReferencedDocument doc) {
        if (this.additionalReference == null) {
            this.additionalReference = new ArrayList();
        }
        this.additionalReference.add(doc);
        return this;
    }

    @Override
    public IReferencedDocument[] getAdditionalReferences() {
        if (this.additionalReference == null) {
            return null;
        }
        return this.additionalReference.toArray(new IReferencedDocument[0]);
    }

    public Item setDetailedDeliveryPeriod(Date from, Date to) {
        this.detailedDeliveryPeriodFrom = from;
        this.detailedDeliveryPeriodTo = to;
        return this;
    }

    @Override
    public Date getDetailedDeliveryPeriodFrom() {
        return this.detailedDeliveryPeriodFrom;
    }

    @Override
    public Date getDetailedDeliveryPeriodTo() {
        return this.detailedDeliveryPeriodTo;
    }

    public IZUGFeRDExportableItem addNotes(Collection<IncludedNote> notes) {
        if (notes == null) {
            return this;
        }
        if (this.includedNotes == null) {
            this.includedNotes = new ArrayList<IncludedNote>();
        }
        this.includedNotes.addAll(notes);
        return this;
    }

    @Override
    public List<IncludedNote> getNotesWithSubjectCode() {
        return this.includedNotes;
    }
}

