/*
 * Decompiled with CFR 0.152.
 */
package org.mustangproject;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.io.IOUtils;
import org.dom4j.io.XMLWriter;
import org.mustangproject.ZUGFeRD.ZUGFeRDDateFormat;
import org.w3c.dom.Node;

public class XMLTools
extends XMLWriter {
    public String escapeAttributeEntities(String s) {
        return super.escapeAttributeEntities(s);
    }

    public String escapeElementEntities(String s) {
        return super.escapeElementEntities(s);
    }

    public static String nDigitFormat(BigDecimal value, int scale) {
        return value.setScale(scale, RoundingMode.HALF_UP).toPlainString();
    }

    public static String getNodeValue(Node node) {
        if (node != null && node.getFirstChild() != null) {
            return node.getFirstChild().getNodeValue();
        }
        return "";
    }

    public static BigDecimal tryBigDecimal(String nodeValue) {
        try {
            return new BigDecimal(nodeValue);
        }
        catch (Exception e) {
            try {
                return BigDecimal.valueOf(Float.valueOf(nodeValue).floatValue());
            }
            catch (Exception ex) {
                return new BigDecimal("0.00");
            }
        }
    }

    public static BigDecimal tryBigDecimal(Node node) {
        String nodeValue = XMLTools.getNodeValue(node);
        if (nodeValue.isEmpty()) {
            return null;
        }
        return XMLTools.tryBigDecimal(nodeValue);
    }

    public static String nDigitFormatDecimalRange(BigDecimal value, int maxDecimals, int minDecimals) {
        int curDecimals;
        if (maxDecimals < minDecimals || maxDecimals < 0 || minDecimals < 0) {
            throw new IllegalArgumentException("Invalid scale range provided");
        }
        for (curDecimals = maxDecimals; curDecimals > minDecimals && value.setScale(curDecimals, RoundingMode.HALF_UP).compareTo(value.setScale(curDecimals - 1, RoundingMode.HALF_UP)) == 0; --curDecimals) {
        }
        return value.setScale(curDecimals, RoundingMode.HALF_UP).toPlainString();
    }

    public static Date tryDate(Node node) {
        String nodeValue = XMLTools.getNodeValue(node);
        if (nodeValue.isEmpty()) {
            return null;
        }
        return XMLTools.tryDate(nodeValue);
    }

    public static Date tryDate(String toParse) {
        SimpleDateFormat formatter = ZUGFeRDDateFormat.DATE.getFormatter();
        try {
            return formatter.parse(toParse);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String encodeXML(CharSequence s) {
        if (s == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            int c = s.charAt(i);
            if (c >= 55296 && c <= 56319 && i + 1 < len) {
                c = c - 55232 << 10 | s.charAt(++i) & 0x3FF;
            }
            if (c < 128) {
                if (c < 32 && c != 9 && c != 13 && c != 10) {
                    sb.append("&#xfffd;");
                    continue;
                }
                switch (c) {
                    case 38: {
                        sb.append("&amp;");
                        break;
                    }
                    case 62: {
                        sb.append("&gt;");
                        break;
                    }
                    case 60: {
                        sb.append("&lt;");
                        break;
                    }
                    default: {
                        sb.append((char)c);
                        break;
                    }
                }
                continue;
            }
            if (c >= 55296 && c <= 57343 || c == 65534 || c == 65535) {
                sb.append("&#xfffd;");
                continue;
            }
            sb.append("&#x");
            sb.append(Integer.toHexString(c));
            sb.append(';');
        }
        return sb.toString();
    }

    public static byte[] removeBOM(byte[] zugferdRaw) {
        byte[] zugferdData;
        if (zugferdRaw[0] == -17 && zugferdRaw[1] == -69 && zugferdRaw[2] == -65) {
            zugferdData = new byte[zugferdRaw.length - 3];
            System.arraycopy(zugferdRaw, 3, zugferdData, 0, zugferdRaw.length - 3);
        } else {
            zugferdData = zugferdRaw;
        }
        return zugferdData;
    }

    public static byte[] getBytesFromStream(InputStream fileinput) throws IOException {
        return IOUtils.toByteArray((InputStream)fileinput);
    }

    public static String trimOrNull(Node node) {
        String textContent;
        if (node != null && (textContent = node.getTextContent()) != null) {
            return textContent.trim();
        }
        return null;
    }
}

