/*
 * Decompiled with CFR 0.152.
 */
package org.mustangproject;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.math.BigDecimal;
import org.mustangproject.XMLTools;
import org.mustangproject.ZUGFeRD.IZUGFeRDCashDiscount;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class CashDiscount
implements IZUGFeRDCashDiscount {
    protected BigDecimal percent;
    protected Integer days = null;

    public CashDiscount(BigDecimal percent, int days) {
        this.percent = percent;
        this.days = days;
    }

    public CashDiscount() {
    }

    public BigDecimal getPercent() {
        return this.percent;
    }

    public CashDiscount setPercent(BigDecimal percent) {
        this.percent = percent;
        return this;
    }

    public Integer getDays() {
        return this.days;
    }

    public CashDiscount setDays(Integer days) {
        this.days = days;
        return this;
    }

    @Override
    @JsonIgnore
    public String getAsCII() {
        return "<ram:SpecifiedTradePaymentTerms><ram:Description>Cash Discount</ram:Description> <ram:ApplicableTradePaymentDiscountTerms>  <ram:BasisPeriodMeasure unitCode=\"DAY\">" + this.days + "</ram:BasisPeriodMeasure>  <ram:CalculationPercent>" + XMLTools.nDigitFormat(this.percent, 3) + "</ram:CalculationPercent> </ram:ApplicableTradePaymentDiscountTerms></ram:SpecifiedTradePaymentTerms>";
    }

    @Override
    @JsonIgnore
    public String getAsXRechnung() {
        return "#SKONTO#TAGE=" + this.days + "#PROZENT=" + XMLTools.nDigitFormat(this.percent, 2) + "#\n";
    }
}

