/*
 * Decompiled with CFR 0.152.
 */
package org.mustangproject.ZUGFeRD;

import jakarta.activation.DataSource;
import jakarta.activation.FileDataSource;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.TransformerException;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.PDDocumentNameDictionary;
import org.apache.pdfbox.pdmodel.PDEmbeddedFilesNameTreeNode;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.PDMetadata;
import org.apache.pdfbox.pdmodel.common.filespecification.PDComplexFileSpecification;
import org.apache.pdfbox.pdmodel.common.filespecification.PDEmbeddedFile;
import org.apache.pdfbox.pdmodel.documentinterchange.logicalstructure.PDMarkInfo;
import org.apache.pdfbox.pdmodel.documentinterchange.logicalstructure.PDStructureTreeRoot;
import org.apache.pdfbox.pdmodel.graphics.color.PDOutputIntent;
import org.apache.xmpbox.XMPMetadata;
import org.apache.xmpbox.schema.AdobePDFSchema;
import org.apache.xmpbox.schema.DublinCoreSchema;
import org.apache.xmpbox.schema.PDFAIdentificationSchema;
import org.apache.xmpbox.schema.XMPBasicSchema;
import org.apache.xmpbox.schema.XMPSchema;
import org.apache.xmpbox.type.AbstractField;
import org.apache.xmpbox.type.ArrayProperty;
import org.apache.xmpbox.type.BadFieldValueException;
import org.apache.xmpbox.xml.DomXmpParser;
import org.apache.xmpbox.xml.XmpParsingException;
import org.apache.xmpbox.xml.XmpSerializer;
import org.mustangproject.EStandard;
import org.mustangproject.FileAttachment;
import org.mustangproject.ZUGFeRD.ByteArrayDataSource;
import org.mustangproject.ZUGFeRD.CustomXMLProvider;
import org.mustangproject.ZUGFeRD.IExportableTransaction;
import org.mustangproject.ZUGFeRD.IExporter;
import org.mustangproject.ZUGFeRD.IXMLProvider;
import org.mustangproject.ZUGFeRD.OXPullProvider;
import org.mustangproject.ZUGFeRD.PDFAConformanceLevel;
import org.mustangproject.ZUGFeRD.Profile;
import org.mustangproject.ZUGFeRD.Profiles;
import org.mustangproject.ZUGFeRD.XMPSchemaPDFAExtensions;
import org.mustangproject.ZUGFeRD.XMPSchemaZugferd;
import org.mustangproject.ZUGFeRD.ZUGFeRDExporterFromA3;

public class OXExporterFromA3
extends ZUGFeRDExporterFromA3 {
    protected PDFAConformanceLevel conformanceLevel = PDFAConformanceLevel.UNICODE;
    protected ArrayList<FileAttachment> fileAttachments = new ArrayList();
    protected boolean overwrite = true;
    private boolean disableAutoClose;
    private boolean fileAttached = false;
    private Profile profile = null;
    private boolean documentPrepared = false;
    protected PDMetadata metadata = null;
    protected String producer = "mustangproject";
    protected String creator = "mustangproject";
    protected String creatorTool = "mustangproject";
    @Deprecated
    protected String author;
    @Deprecated
    protected String title;
    @Deprecated
    protected String subject;
    protected String orderXDocumentType = "ORDER";
    private boolean attachZUGFeRDHeaders = true;

    @Override
    public OXExporterFromA3 load(String pdfFilename) throws IOException {
        this.ensurePDFIsValid((DataSource)new FileDataSource(pdfFilename));
        try (FileInputStream pdf = new FileInputStream(pdfFilename);){
            OXExporterFromA3 oXExporterFromA3 = this.load(OXExporterFromA3.readAllBytes(pdf));
            return oXExporterFromA3;
        }
    }

    @Override
    public IXMLProvider getProvider() {
        return this.xmlProvider;
    }

    @Override
    public OXExporterFromA3 setProfile(Profile p) {
        this.profile = p;
        if (this.xmlProvider != null) {
            this.xmlProvider.setProfile(p);
        }
        return this;
    }

    @Override
    public OXExporterFromA3 setProfile(String profilename) {
        this.profile = Profiles.getByName(profilename);
        if (this.xmlProvider != null) {
            this.xmlProvider.setProfile(this.profile);
        }
        return this;
    }

    @Override
    public OXExporterFromA3 addAdditionalFile(String name, byte[] content) {
        this.fileAttachments.add(new FileAttachment(name, "text/xml", "Supplement", content).setDescription("ZUGFeRD extension/additional data"));
        return this;
    }

    @Override
    public OXExporterFromA3 load(byte[] pdfBinary) throws IOException {
        this.ensurePDFIsValid(new ByteArrayDataSource(new ByteArrayInputStream(pdfBinary)));
        this.doc = Loader.loadPDF((byte[])pdfBinary);
        return this;
    }

    @Override
    public void attachFile(FileAttachment file) {
        this.fileAttachments.add(file);
    }

    @Override
    public void attachFile(String filename, byte[] data, String mimetype, String relation) {
        FileAttachment fa = new FileAttachment(filename, mimetype, relation, data);
        this.fileAttachments.add(fa);
    }

    @Override
    public void export(String ZUGFeRDfilename) throws IOException {
        if (!this.documentPrepared) {
            this.prepareDocument();
        }
        if (!this.fileAttached && this.attachZUGFeRDHeaders) {
            throw new IOException("File must be attached (usually with setTransaction) before perfoming this operation");
        }
        this.doc.save(ZUGFeRDfilename);
        if (!this.disableAutoClose) {
            this.close();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.doc != null) {
            this.doc.close();
        }
    }

    @Override
    public void export(OutputStream output) throws IOException {
        if (!this.documentPrepared) {
            this.prepareDocument();
        }
        if (!this.fileAttached && this.attachZUGFeRDHeaders) {
            throw new IOException("File must be attached (usually with setTransaction) before perfoming this operation");
        }
        this.doc.save(output);
        if (!this.disableAutoClose) {
            this.close();
        }
    }

    @Override
    public void PDFAttachGenericFile(String filename, String relationship, String description, String subType, byte[] data) throws IOException {
        this.PDFAttachGenericFile(this.doc, filename, relationship, description, subType, data);
    }

    @Override
    public void PDFAttachGenericFile(PDDocument doc, String filename, String relationship, String description, String subType, byte[] data) throws IOException {
        COSArray cosArray;
        this.fileAttached = true;
        PDComplexFileSpecification fs = new PDComplexFileSpecification();
        fs.setFile(filename);
        COSDictionary dict = fs.getCOSObject();
        dict.setName("AFRelationship", relationship);
        dict.setString("UF", filename);
        dict.setString("Desc", description);
        ByteArrayInputStream fakeFile = new ByteArrayInputStream(data);
        PDEmbeddedFile ef = new PDEmbeddedFile(doc, (InputStream)fakeFile);
        ef.setSubtype(subType);
        ef.setSize(data.length);
        ef.setCreationDate((Calendar)new GregorianCalendar());
        ef.setModDate(Calendar.getInstance());
        fs.setEmbeddedFile(ef);
        dict = fs.getCOSObject();
        COSDictionary efDict = (COSDictionary)dict.getDictionaryObject(COSName.EF);
        COSBase lowerLevelFile = efDict.getItem(COSName.F);
        efDict.setItem(COSName.UF, lowerLevelFile);
        PDDocumentNameDictionary names = new PDDocumentNameDictionary(doc.getDocumentCatalog());
        PDEmbeddedFilesNameTreeNode efTree = names.getEmbeddedFiles();
        if (efTree == null) {
            efTree = new PDEmbeddedFilesNameTreeNode();
        }
        HashMap<String, PDComplexFileSpecification> namesMap = new HashMap<String, PDComplexFileSpecification>();
        Map oldNamesMap = efTree.getNames();
        if (oldNamesMap != null) {
            for (String key : oldNamesMap.keySet()) {
                namesMap.put(key, (PDComplexFileSpecification)oldNamesMap.get(key));
            }
        }
        namesMap.put(filename, fs);
        efTree.setNames(namesMap);
        names.setEmbeddedFiles(efTree);
        doc.getDocumentCatalog().setNames(names);
        COSBase AFEntry = doc.getDocumentCatalog().getCOSObject().getItem("AF");
        if (AFEntry == null) {
            cosArray = new COSArray();
            cosArray.add((COSObjectable)fs);
            doc.getDocumentCatalog().getCOSObject().setItem("AF", (COSBase)cosArray);
        } else if (AFEntry instanceof COSArray) {
            cosArray = (COSArray)AFEntry;
            cosArray.add((COSObjectable)fs);
            doc.getDocumentCatalog().getCOSObject().setItem("AF", (COSBase)cosArray);
        } else if (AFEntry instanceof COSObject && ((COSObject)AFEntry).getObject() instanceof COSArray) {
            cosArray = (COSArray)((COSObject)AFEntry).getObject();
            cosArray.add((COSObjectable)fs);
        } else {
            throw new IOException("Unexpected object type for PDFDocument/Catalog/COSDictionary/Item(AF)");
        }
    }

    @Override
    public OXExporterFromA3 setXML(byte[] zugferdData) throws IOException {
        CustomXMLProvider cus = new CustomXMLProvider();
        cus.setXML(zugferdData);
        this.setXMLProvider(cus);
        this.prepare();
        return this;
    }

    @Override
    public OXExporterFromA3 load(InputStream pdfSource) throws IOException {
        return this.load(OXExporterFromA3.readAllBytes(pdfSource));
    }

    @Override
    public boolean ensurePDFIsValid(DataSource dataSource) throws IOException {
        return true;
    }

    private static byte[] readAllBytes(InputStream in) throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)in, (OutputStream)buffer);
        return buffer.toByteArray();
    }

    @Override
    public OXExporterFromA3 setConformanceLevel(PDFAConformanceLevel newLevel) {
        this.conformanceLevel = newLevel;
        return this;
    }

    @Override
    public OXExporterFromA3 setCreator(String creator) {
        this.creator = creator;
        return this;
    }

    @Override
    public OXExporterFromA3 setCreatorTool(String creatorTool) {
        this.creatorTool = creatorTool;
        return this;
    }

    @Override
    public OXExporterFromA3 setProducer(String producer) {
        this.producer = producer;
        return this;
    }

    public OXExporterFromA3 setOrderXDocumentType(String orderXDocumentType) {
        this.orderXDocumentType = orderXDocumentType;
        return this;
    }

    @Override
    protected OXExporterFromA3 setAttachZUGFeRDHeaders(boolean attachHeaders) {
        this.attachZUGFeRDHeaders = attachHeaders;
        return this;
    }

    @Override
    protected void addXMP(XMPMetadata metadata) {
        if (this.attachZUGFeRDHeaders) {
            XMPSchemaZugferd zf = new XMPSchemaZugferd(metadata, 1, true, this.xmlProvider.getProfile(), "urn:factur-x:pdfa:CrossIndustryDocument:1p0#", "fx", "order-x.xml");
            zf.setType(this.orderXDocumentType);
            metadata.addSchema((XMPSchema)zf);
            XMPSchemaPDFAExtensions pdfaex = new XMPSchemaPDFAExtensions(this, metadata, 1, this.attachZUGFeRDHeaders, EStandard.orderx);
            pdfaex.setZUGFeRDVersion(1);
            metadata.addSchema((XMPSchema)pdfaex);
        }
    }

    @Override
    public IExporter setTransaction(IExportableTransaction trans) throws IOException {
        this.trans = trans;
        return this.prepare();
    }

    @Override
    public IExporter prepare() throws IOException {
        this.prepareDocument();
        this.xmlProvider.generateXML(this.trans);
        String filename = "order-x.xml";
        this.PDFAttachGenericFile(this.doc, filename, "Alternative", "Order metadata conforming to the Order-X standard (https://www.ferd-net.de/standards/order-x/index.html)", "text/xml", this.xmlProvider.getXML());
        for (FileAttachment attachment : this.fileAttachments) {
            this.PDFAttachGenericFile(this.doc, attachment.getFilename(), attachment.getRelation(), attachment.getDescription(), attachment.getMimetype(), attachment.getData());
        }
        return this;
    }

    @Override
    protected XMPMetadata getXmpMetadata() throws IOException {
        PDMetadata meta = this.doc.getDocumentCatalog().getMetadata();
        if (meta != null && meta.getLength() > 0) {
            try {
                DomXmpParser xmpParser = new DomXmpParser();
                return xmpParser.parse(meta.toByteArray());
            }
            catch (IOException | XmpParsingException e) {
                throw new IOException(e);
            }
        }
        return XMPMetadata.createXMPMetadata();
    }

    @Override
    protected byte[] serializeXmpMetadata(XMPMetadata xmpMetadata) throws TransformerException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        new XmpSerializer().serialize(xmpMetadata, (OutputStream)buffer, true);
        return buffer.toByteArray();
    }

    @Override
    protected void writeAdobePDFSchema(XMPMetadata xmp) {
        AdobePDFSchema pdf = this.getAdobePDFSchema(xmp);
        if (this.overwrite || this.isEmpty(pdf.getProducer())) {
            pdf.setProducer(this.producer);
        }
    }

    @Override
    protected AdobePDFSchema getAdobePDFSchema(XMPMetadata xmp) {
        AdobePDFSchema pdf = xmp.getAdobePDFSchema();
        if (pdf != null) {
            if (this.overwrite) {
                xmp.removeSchema((XMPSchema)pdf);
            } else {
                return pdf;
            }
        }
        return xmp.createAndAddAdobePDFSchema();
    }

    @Override
    protected void writePDFAIdentificationSchema(XMPMetadata xmp) {
        PDFAIdentificationSchema pdfaid = this.getPDFAIdentificationSchema(xmp);
        if (this.overwrite || this.isEmpty(pdfaid.getConformance())) {
            try {
                pdfaid.setConformance(this.conformanceLevel.getLetter());
            }
            catch (BadFieldValueException ex) {
                throw new RuntimeException(ex);
            }
        }
        pdfaid.setPart(Integer.valueOf(3));
    }

    @Override
    protected PDFAIdentificationSchema getPDFAIdentificationSchema(XMPMetadata xmp) {
        PDFAIdentificationSchema pdfaid = xmp.getPDFAIdentificationSchema();
        if (pdfaid != null) {
            if (this.overwrite) {
                xmp.removeSchema((XMPSchema)pdfaid);
            } else {
                return pdfaid;
            }
        }
        return xmp.createAndAddPDFAIdentificationSchema();
    }

    @Override
    protected void writeDublinCoreSchema(XMPMetadata xmp) {
        ArrayProperty titleProperty;
        DublinCoreSchema dc = this.getDublinCoreSchema(xmp);
        if (dc.getFormat() == null) {
            dc.setFormat("application/pdf");
        }
        if ((this.overwrite || dc.getCreators() == null || dc.getCreators().isEmpty()) && this.creator != null) {
            dc.addCreator(this.creator);
        }
        if ((this.overwrite || dc.getDates() == null || dc.getDates().isEmpty()) && this.creator != null) {
            dc.addDate(Calendar.getInstance());
        }
        if ((titleProperty = dc.getTitleProperty()) != null) {
            if (this.overwrite && !this.isEmpty(this.title)) {
                dc.removeProperty((AbstractField)titleProperty);
                dc.setTitle(this.title);
            } else if (titleProperty.getElementsAsString().stream().anyMatch("Untitled"::equalsIgnoreCase)) {
                dc.removeProperty((AbstractField)titleProperty);
            }
        } else if (!this.isEmpty(this.title)) {
            dc.setTitle(this.title);
        }
    }

    @Override
    protected DublinCoreSchema getDublinCoreSchema(XMPMetadata xmp) {
        DublinCoreSchema dc = xmp.getDublinCoreSchema();
        if (dc != null) {
            if (this.overwrite) {
                xmp.removeSchema((XMPSchema)dc);
            } else {
                return dc;
            }
        }
        return xmp.createAndAddDublinCoreSchema();
    }

    @Override
    protected void writeXMLBasicSchema(XMPMetadata xmp) {
        XMPBasicSchema xsb = this.getXmpBasicSchema(xmp);
        if (this.overwrite || this.isEmpty(xsb.getCreatorTool()) || "UnknownApplication".equals(xsb.getCreatorTool())) {
            xsb.setCreatorTool(this.creatorTool);
        }
        if (this.overwrite || xsb.getCreateDate() == null) {
            xsb.setCreateDate(Calendar.getInstance());
        }
    }

    @Override
    protected XMPBasicSchema getXmpBasicSchema(XMPMetadata xmp) {
        XMPBasicSchema xsb = xmp.getXMPBasicSchema();
        if (xsb != null) {
            if (this.overwrite) {
                xmp.removeSchema((XMPSchema)xsb);
            } else {
                return xsb;
            }
        }
        return xmp.createAndAddXMPBasicSchema();
    }

    @Override
    protected void writeDocumentInformation() {
        String fullProducer = this.producer + " (via mustangproject.org 2.16.1)";
        PDDocumentInformation info = this.doc.getDocumentInformation();
        if (this.overwrite || info.getCreationDate() == null) {
            info.setCreationDate(Calendar.getInstance());
        }
        if (this.overwrite || info.getModificationDate() == null) {
            info.setModificationDate(Calendar.getInstance());
        }
        if (this.overwrite || this.isEmpty(info.getAuthor()) && !this.isEmpty(this.author)) {
            info.setAuthor(this.author);
        }
        if (this.overwrite || this.isEmpty(info.getProducer()) && !this.isEmpty(fullProducer)) {
            info.setProducer(fullProducer);
        }
        if (this.overwrite || this.isEmpty(info.getCreator()) && !this.isEmpty(this.creator)) {
            info.setCreator(this.creator);
        }
        if (this.overwrite || this.isEmpty(info.getTitle()) && !this.isEmpty(this.title)) {
            info.setTitle(this.title);
        }
        if (this.overwrite || this.isEmpty(info.getSubject()) && !this.isEmpty(this.subject)) {
            info.setSubject(this.subject);
        }
    }

    @Override
    protected void addSRGBOutputIntend() throws IOException {
        if (!this.doc.getDocumentCatalog().getOutputIntents().isEmpty()) {
            return;
        }
        InputStream colorProfile = Thread.currentThread().getContextClassLoader().getResourceAsStream("sRGB.icc");
        if (colorProfile != null) {
            PDOutputIntent intent = new PDOutputIntent(this.doc, colorProfile);
            intent.setInfo("sRGB IEC61966-2.1");
            intent.setOutputCondition("sRGB IEC61966-2.1");
            intent.setOutputConditionIdentifier("sRGB IEC61966-2.1");
            intent.setRegistryName("http://www.color.org");
            this.doc.getDocumentCatalog().addOutputIntent(intent);
        }
    }

    @Override
    protected void setMarked() {
        PDDocumentCatalog catalog = this.doc.getDocumentCatalog();
        if (catalog.getMarkInfo() == null) {
            catalog.setMarkInfo(new PDMarkInfo(this.doc.getPages().getCOSObject()));
        }
        catalog.getMarkInfo().setMarked(true);
    }

    @Override
    protected void addStructureTreeRoot() {
        if (this.doc.getDocumentCatalog().getStructureTreeRoot() == null) {
            this.doc.getDocumentCatalog().setStructureTreeRoot(new PDStructureTreeRoot());
        }
    }

    @Override
    public boolean isAutoCloseDisabled() {
        return this.disableAutoClose;
    }

    @Override
    public OXExporterFromA3 disableAutoClose(boolean disableAutoClose) {
        this.disableAutoClose = disableAutoClose;
        return this;
    }

    @Override
    protected void setXMLProvider(IXMLProvider p) {
        this.xmlProvider = p;
        if (this.profile != null) {
            this.xmlProvider.setProfile(this.profile);
        }
    }

    @Override
    public OXExporterFromA3 setZUGFeRDVersion(int version) {
        OXPullProvider z2p = new OXPullProvider();
        this.setXMLProvider(z2p);
        return this;
    }

    private boolean isEmpty(String string) {
        return string == null || string.isEmpty();
    }
}

