/*
 * Decompiled with CFR 0.152.
 */
package org.mustangproject.ZUGFeRD;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.mustangproject.FileAttachment;
import org.mustangproject.IncludedNote;
import org.mustangproject.ReferencedDocument;
import org.mustangproject.XMLTools;
import org.mustangproject.ZUGFeRD.IAbsoluteValueProvider;
import org.mustangproject.ZUGFeRD.IDesignatedProductClassification;
import org.mustangproject.ZUGFeRD.IExportableTransaction;
import org.mustangproject.ZUGFeRD.IReferencedDocument;
import org.mustangproject.ZUGFeRD.IXMLProvider;
import org.mustangproject.ZUGFeRD.IZUGFeRDAllowanceCharge;
import org.mustangproject.ZUGFeRD.IZUGFeRDCashDiscount;
import org.mustangproject.ZUGFeRD.IZUGFeRDExportableItem;
import org.mustangproject.ZUGFeRD.IZUGFeRDExportableTradeParty;
import org.mustangproject.ZUGFeRD.IZUGFeRDPaymentDiscountTerms;
import org.mustangproject.ZUGFeRD.IZUGFeRDPaymentTerms;
import org.mustangproject.ZUGFeRD.IZUGFeRDTradeSettlement;
import org.mustangproject.ZUGFeRD.IZUGFeRDTradeSettlementDebit;
import org.mustangproject.ZUGFeRD.IZUGFeRDTradeSettlementPayment;
import org.mustangproject.ZUGFeRD.LineCalculator;
import org.mustangproject.ZUGFeRD.Profile;
import org.mustangproject.ZUGFeRD.Profiles;
import org.mustangproject.ZUGFeRD.TransactionCalculator;
import org.mustangproject.ZUGFeRD.VATAmount;
import org.mustangproject.ZUGFeRD.ZUGFeRDDateFormat;
import org.mustangproject.ZUGFeRD.model.TaxCategoryCodeTypeConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZUGFeRD2PullProvider
implements IXMLProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZUGFeRD2PullProvider.class);
    protected byte[] zugferdData;
    protected IExportableTransaction trans;
    protected TransactionCalculator calc;
    private String paymentTermsDescription;
    protected Profile profile = Profiles.getByName("EN16931");

    @Override
    public void setTest() {
    }

    protected String vatFormat(BigDecimal value) {
        return XMLTools.nDigitFormat(value, 2);
    }

    protected String currencyFormat(BigDecimal value) {
        return XMLTools.nDigitFormat(value, 2);
    }

    protected String priceFormat(BigDecimal value) {
        return XMLTools.nDigitFormatDecimalRange(value, 18, 4);
    }

    protected String quantityFormat(BigDecimal value) {
        return XMLTools.nDigitFormatDecimalRange(value, 18, 4);
    }

    @Override
    public byte[] getXML() {
        byte[] res = this.zugferdData;
        StringWriter sw = new StringWriter();
        Document document = null;
        try {
            document = DocumentHelper.parseText((String)new String(this.zugferdData));
        }
        catch (DocumentException e1) {
            LOGGER.error("Failed to parse ZUGFeRD data", (Throwable)e1);
        }
        try {
            OutputFormat format = OutputFormat.createPrettyPrint();
            format.setTrimText(false);
            XMLWriter writer = new XMLWriter((Writer)sw, format);
            writer.write(document);
            res = sw.toString().getBytes(StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            LOGGER.error("Failed to write ZUGFeRD data", (Throwable)e);
        }
        return res;
    }

    @Override
    public Profile getProfile() {
        return this.profile;
    }

    protected String getTradePartyAsXML(IZUGFeRDExportableTradeParty party, boolean isSender, boolean isShipToTradeParty) {
        Object xml = "";
        if (party.getID() != null) {
            xml = (String)xml + "<ram:ID>" + XMLTools.encodeXML(party.getID()) + "</ram:ID>";
        }
        if (party.getGlobalIDScheme() != null && party.getGlobalID() != null) {
            xml = (String)xml + "<ram:GlobalID schemeID=\"" + XMLTools.encodeXML(party.getGlobalIDScheme()) + "\">" + XMLTools.encodeXML(party.getGlobalID()) + "</ram:GlobalID>";
        }
        xml = (String)xml + "<ram:Name>" + XMLTools.encodeXML(party.getName()) + "</ram:Name>";
        if (party.getDescription() != null) {
            xml = (String)xml + "<ram:Description>" + XMLTools.encodeXML(party.getDescription()) + "</ram:Description>";
        }
        if (party.getLegalOrganisation() != null) {
            xml = (String)xml + "<ram:SpecifiedLegalOrganization> ";
            if (party.getLegalOrganisation().getSchemedID() != null) {
                xml = this.profile == Profiles.getByName("Minimum") ? (String)xml + "<ram:ID>" + XMLTools.encodeXML(party.getLegalOrganisation().getSchemedID().getID()) + "</ram:ID>" : (String)xml + "<ram:ID schemeID=\"" + XMLTools.encodeXML(party.getLegalOrganisation().getSchemedID().getScheme()) + "\">" + XMLTools.encodeXML(party.getLegalOrganisation().getSchemedID().getID()) + "</ram:ID>";
            }
            if (party.getLegalOrganisation().getTradingBusinessName() != null) {
                xml = (String)xml + "<ram:TradingBusinessName>" + XMLTools.encodeXML(party.getLegalOrganisation().getTradingBusinessName()) + "</ram:TradingBusinessName>";
            }
            xml = (String)xml + "</ram:SpecifiedLegalOrganization>";
        }
        if (party.getContact() != null && (isSender || this.profile == Profiles.getByName("EN16931") || this.profile == Profiles.getByName("Extended") || this.profile == Profiles.getByName("XRechnung"))) {
            xml = (String)xml + "<ram:DefinedTradeContact>";
            if (party.getContact().getName() != null) {
                xml = (String)xml + "<ram:PersonName>" + XMLTools.encodeXML(party.getContact().getName()) + "</ram:PersonName>";
            }
            if (party.getContact().getPhone() != null) {
                xml = (String)xml + "<ram:TelephoneUniversalCommunication><ram:CompleteNumber>" + XMLTools.encodeXML(party.getContact().getPhone()) + "</ram:CompleteNumber></ram:TelephoneUniversalCommunication>";
            }
            if (party.getContact().getFax() != null && this.profile == Profiles.getByName("Extended")) {
                xml = (String)xml + "<ram:FaxUniversalCommunication><ram:CompleteNumber>" + XMLTools.encodeXML(party.getContact().getFax()) + "</ram:CompleteNumber></ram:FaxUniversalCommunication>";
            }
            if (party.getContact().getEMail() != null) {
                xml = (String)xml + "<ram:EmailURIUniversalCommunication><ram:URIID>" + XMLTools.encodeXML(party.getContact().getEMail()) + "</ram:URIID></ram:EmailURIUniversalCommunication>";
            }
            xml = (String)xml + "</ram:DefinedTradeContact>";
        }
        xml = (String)xml + "<ram:PostalTradeAddress>";
        if (party.getZIP() != null) {
            xml = (String)xml + "<ram:PostcodeCode>" + XMLTools.encodeXML(party.getZIP()) + "</ram:PostcodeCode>";
        }
        if (party.getStreet() != null) {
            xml = (String)xml + "<ram:LineOne>" + XMLTools.encodeXML(party.getStreet()) + "</ram:LineOne>";
        }
        if (party.getAdditionalAddress() != null) {
            xml = (String)xml + "<ram:LineTwo>" + XMLTools.encodeXML(party.getAdditionalAddress()) + "</ram:LineTwo>";
        }
        if (party.getAdditionalAddressExtension() != null) {
            xml = (String)xml + "<ram:LineThree>" + XMLTools.encodeXML(party.getAdditionalAddressExtension()) + "</ram:LineThree>";
        }
        if (party.getLocation() != null) {
            xml = (String)xml + "<ram:CityName>" + XMLTools.encodeXML(party.getLocation()) + "</ram:CityName>";
        }
        xml = (String)xml + "<ram:CountryID>" + XMLTools.encodeXML(party.getCountry()) + "</ram:CountryID></ram:PostalTradeAddress>";
        if (party.getUriUniversalCommunicationID() != null && party.getUriUniversalCommunicationIDScheme() != null) {
            xml = (String)xml + "<ram:URIUniversalCommunication><ram:URIID schemeID=\"" + party.getUriUniversalCommunicationIDScheme() + "\">" + XMLTools.encodeXML(party.getUriUniversalCommunicationID()) + "</ram:URIID></ram:URIUniversalCommunication>";
        }
        if (party.getVATID() != null && !isShipToTradeParty) {
            xml = (String)xml + "<ram:SpecifiedTaxRegistration><ram:ID schemeID=\"VA\">" + XMLTools.encodeXML(party.getVATID()) + "</ram:ID></ram:SpecifiedTaxRegistration>";
        }
        if (party.getTaxID() != null && !isShipToTradeParty) {
            xml = (String)xml + "<ram:SpecifiedTaxRegistration><ram:ID schemeID=\"FC\">" + XMLTools.encodeXML(party.getTaxID()) + "</ram:ID></ram:SpecifiedTaxRegistration>";
        }
        return xml;
    }

    protected String getTradePartyPayeeAsXML(IZUGFeRDExportableTradeParty party) {
        Object xml = "";
        if (party.getID() != null) {
            xml = (String)xml + "<ram:ID>" + XMLTools.encodeXML(party.getID()) + "</ram:ID>";
        }
        if (party.getGlobalIDScheme() != null && party.getGlobalID() != null) {
            xml = (String)xml + "<ram:GlobalID schemeID=\"" + XMLTools.encodeXML(party.getGlobalIDScheme()) + "\">" + XMLTools.encodeXML(party.getGlobalID()) + "</ram:GlobalID>";
        }
        xml = (String)xml + "<ram:Name>" + XMLTools.encodeXML(party.getName()) + "</ram:Name>";
        if (party.getLegalOrganisation() != null) {
            xml = (String)xml + "<ram:SpecifiedLegalOrganization> ";
            if (party.getLegalOrganisation().getSchemedID() != null) {
                xml = (String)xml + "<ram:ID schemeID=\"" + XMLTools.encodeXML(party.getLegalOrganisation().getSchemedID().getScheme()) + "\">" + XMLTools.encodeXML(party.getLegalOrganisation().getSchemedID().getID()) + "</ram:ID>";
            }
            xml = (String)xml + "</ram:SpecifiedLegalOrganization>";
        }
        return xml;
    }

    protected String getAllowanceChargeStr(IZUGFeRDAllowanceCharge allowance, IAbsoluteValueProvider item) {
        Object percentage = "";
        String chargeIndicator = "false";
        if (allowance.getPercent() != null && this.profile == Profiles.getByName("Extended")) {
            percentage = "<ram:CalculationPercent>" + this.vatFormat(allowance.getPercent()) + "</ram:CalculationPercent>";
            percentage = (String)percentage + "<ram:BasisAmount>" + item.getValue() + "</ram:BasisAmount>";
        }
        if (allowance.isCharge()) {
            chargeIndicator = "true";
        }
        Object reason = "";
        if (allowance.getReason() != null && (this.profile == Profiles.getByName("Extended") || this.profile == Profiles.getByName("XRechnung")) || this.profile == Profiles.getByName("EN16931")) {
            reason = "<ram:Reason>" + XMLTools.encodeXML(allowance.getReason()) + "</ram:Reason>";
        }
        Object reasonCode = "";
        if (allowance.getReasonCode() != null) {
            reasonCode = "<ram:ReasonCode>" + allowance.getReasonCode() + "</ram:ReasonCode>";
        }
        String allowanceChargeStr = "<ram:AppliedTradeAllowanceCharge><ram:ChargeIndicator><udt:Indicator>" + chargeIndicator + "</udt:Indicator></ram:ChargeIndicator>" + (String)percentage + "<ram:ActualAmount>" + this.priceFormat(allowance.getTotalAmount(item)) + "</ram:ActualAmount>" + (String)reasonCode + (String)reason + "</ram:AppliedTradeAllowanceCharge>";
        return allowanceChargeStr;
    }

    protected String getItemTotalAllowanceChargeStr(IZUGFeRDAllowanceCharge allowance, IAbsoluteValueProvider item) {
        Object percentage = "";
        String chargeIndicator = "false";
        if (allowance.getPercent() != null && this.profile == Profiles.getByName("Extended")) {
            percentage = "<ram:CalculationPercent>" + this.vatFormat(allowance.getPercent()) + "</ram:CalculationPercent>";
            percentage = (String)percentage + "<ram:BasisAmount>" + item.getValue() + "</ram:BasisAmount>";
        }
        if (allowance.isCharge()) {
            chargeIndicator = "true";
        }
        Object reason = "";
        if (allowance.getReason() != null && (this.profile == Profiles.getByName("Extended") || this.profile == Profiles.getByName("XRechnung"))) {
            reason = "<ram:Reason>" + XMLTools.encodeXML(allowance.getReason()) + "</ram:Reason>";
        }
        Object reasonCode = "";
        if (allowance.getReasonCode() != null && this.profile == Profiles.getByName("XRechnung")) {
            reasonCode = "<ram:ReasonCode>" + allowance.getReasonCode() + "</ram:ReasonCode>";
        }
        String itemTotalAllowanceChargeStr = "<ram:SpecifiedTradeAllowanceCharge><ram:ChargeIndicator><udt:Indicator>" + chargeIndicator + "</udt:Indicator></ram:ChargeIndicator>" + (String)percentage + "<ram:ActualAmount>" + this.currencyFormat(allowance.getTotalAmount(item)) + "</ram:ActualAmount>" + (String)reasonCode + (String)reason + "</ram:SpecifiedTradeAllowanceCharge>";
        return itemTotalAllowanceChargeStr;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void generateXML(IExportableTransaction trans) {
        int currentTaxPercent2;
        Object object;
        this.trans = trans;
        this.calc = new TransactionCalculator(trans);
        boolean hasDueDate = trans.getDueDate() != null;
        SimpleDateFormat germanDateFormat = new SimpleDateFormat("dd.MM.yyyy");
        Object exemptionReason = "";
        if (trans.getPaymentTermDescription() != null) {
            this.paymentTermsDescription = XMLTools.encodeXML(trans.getPaymentTermDescription());
        }
        if (this.profile == Profiles.getByName("XRechnung") && trans.getCashDiscounts() != null && trans.getCashDiscounts().length > 0) {
            for (IZUGFeRDCashDiscount iZUGFeRDCashDiscount : trans.getCashDiscounts()) {
                if (this.paymentTermsDescription == null) {
                    this.paymentTermsDescription = "";
                }
                this.paymentTermsDescription = this.paymentTermsDescription + iZUGFeRDCashDiscount.getAsXRechnung();
            }
        } else if (this.paymentTermsDescription == null && trans.getDocumentCode() != "384" && trans.getDocumentCode() != "381" && trans.getDueDate() != null) {
            this.paymentTermsDescription = "Please remit until " + germanDateFormat.format(trans.getDueDate());
        }
        String typecode = "380";
        if (trans.getDocumentCode() != null) {
            typecode = trans.getDocumentCode();
        }
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><rsm:CrossIndustryInvoice xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:rsm=\"urn:un:unece:uncefact:data:standard:CrossIndustryInvoice:100\" xmlns:ram=\"urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:100\" xmlns:udt=\"urn:un:unece:uncefact:data:standard:UnqualifiedDataType:100\" xmlns:qdt=\"urn:un:unece:uncefact:data:standard:QualifiedDataType:100\"><!-- generated by: mustangproject.org v" + ZUGFeRD2PullProvider.class.getPackage().getImplementationVersion() + "--><rsm:ExchangedDocumentContext>\n";
        if (this.getProfile() == Profiles.getByName("XRechnung")) {
            xml = xml + "<ram:BusinessProcessSpecifiedDocumentContextParameter>\n<ram:ID>urn:fdc:peppol.eu:2017:poacc:billing:01:1.0</ram:ID>\n</ram:BusinessProcessSpecifiedDocumentContextParameter>\n";
        }
        xml = xml + "<ram:GuidelineSpecifiedDocumentContextParameter><ram:ID>" + this.getProfile().getID() + "</ram:ID></ram:GuidelineSpecifiedDocumentContextParameter></rsm:ExchangedDocumentContext><rsm:ExchangedDocument><ram:ID>" + XMLTools.encodeXML(trans.getNumber()) + "</ram:ID><ram:TypeCode>" + typecode + "</ram:TypeCode><ram:IssueDateTime>" + ZUGFeRDDateFormat.DATE.udtFormat(trans.getIssueDate()) + "</ram:IssueDateTime>" + this.buildNotes(trans) + "</rsm:ExchangedDocument><rsm:SupplyChainTradeTransaction>";
        int lineID = 0;
        for (IZUGFeRDExportableItem iZUGFeRDExportableItem : trans.getZFItems()) {
            String lineIDStr = Integer.toString(++lineID);
            if (iZUGFeRDExportableItem.getId() != null) {
                lineIDStr = iZUGFeRDExportableItem.getId();
            }
            if (iZUGFeRDExportableItem.getProduct().getTaxExemptionReason() != null) {
                exemptionReason = "<ram:ExemptionReason>" + XMLTools.encodeXML(iZUGFeRDExportableItem.getProduct().getTaxExemptionReason()) + "</ram:ExemptionReason>";
            }
            LineCalculator lc = new LineCalculator(iZUGFeRDExportableItem);
            if (this.getProfile() == Profiles.getByName("Minimum") || this.getProfile() == Profiles.getByName("BasicWL")) continue;
            xml = xml + "<ram:IncludedSupplyChainTradeLineItem><ram:AssociatedDocumentLineDocument><ram:LineID>" + lineIDStr + "</ram:LineID>" + this.buildItemNotes(iZUGFeRDExportableItem) + "</ram:AssociatedDocumentLineDocument><ram:SpecifiedTradeProduct>";
            if (iZUGFeRDExportableItem.getProduct().getGlobalIDScheme() != null && iZUGFeRDExportableItem.getProduct().getGlobalID() != null) {
                xml = xml + "<ram:GlobalID schemeID=\"" + XMLTools.encodeXML(iZUGFeRDExportableItem.getProduct().getGlobalIDScheme()) + "\">" + XMLTools.encodeXML(iZUGFeRDExportableItem.getProduct().getGlobalID()) + "</ram:GlobalID>";
            }
            if (iZUGFeRDExportableItem.getProduct().getSellerAssignedID() != null) {
                xml = xml + "<ram:SellerAssignedID>" + XMLTools.encodeXML(iZUGFeRDExportableItem.getProduct().getSellerAssignedID()) + "</ram:SellerAssignedID>";
            }
            if (iZUGFeRDExportableItem.getProduct().getBuyerAssignedID() != null) {
                xml = xml + "<ram:BuyerAssignedID>" + XMLTools.encodeXML(iZUGFeRDExportableItem.getProduct().getBuyerAssignedID()) + "</ram:BuyerAssignedID>";
            }
            Object allowanceChargeStr = "";
            if (iZUGFeRDExportableItem.getItemAllowances() != null && iZUGFeRDExportableItem.getItemAllowances().length > 0) {
                for (IZUGFeRDAllowanceCharge allowance : iZUGFeRDExportableItem.getItemAllowances()) {
                    allowanceChargeStr = (String)allowanceChargeStr + this.getAllowanceChargeStr(allowance, iZUGFeRDExportableItem);
                }
            }
            if (iZUGFeRDExportableItem.getItemCharges() != null && iZUGFeRDExportableItem.getItemCharges().length > 0) {
                for (IZUGFeRDAllowanceCharge charge : iZUGFeRDExportableItem.getItemCharges()) {
                    allowanceChargeStr = (String)allowanceChargeStr + this.getAllowanceChargeStr(charge, iZUGFeRDExportableItem);
                }
            }
            Object itemTotalAllowanceChargeStr = "";
            if (iZUGFeRDExportableItem.getItemTotalAllowances() != null && iZUGFeRDExportableItem.getItemTotalAllowances().length > 0) {
                for (IZUGFeRDAllowanceCharge itemTotalAllowance : iZUGFeRDExportableItem.getItemTotalAllowances()) {
                    itemTotalAllowanceChargeStr = (String)itemTotalAllowanceChargeStr + this.getItemTotalAllowanceChargeStr(itemTotalAllowance, iZUGFeRDExportableItem);
                }
            }
            xml = xml + "<ram:Name>" + XMLTools.encodeXML(iZUGFeRDExportableItem.getProduct().getName()) + "</ram:Name>";
            if (iZUGFeRDExportableItem.getProduct().getDescription().length() > 0) {
                xml = xml + "<ram:Description>" + XMLTools.encodeXML(iZUGFeRDExportableItem.getProduct().getDescription()) + "</ram:Description>";
            }
            if (iZUGFeRDExportableItem.getProduct().getClassifications() != null && iZUGFeRDExportableItem.getProduct().getClassifications().length > 0) {
                for (IDesignatedProductClassification classification : iZUGFeRDExportableItem.getProduct().getClassifications()) {
                    xml = xml + "<ram:DesignatedProductClassification><ram:ClassCode listId=\"" + XMLTools.encodeXML(classification.getClassCode().getListID()) + "\"";
                    if (classification.getClassCode().getListVersionID() != null) {
                        xml = xml + " listVersionID=\"" + XMLTools.encodeXML(classification.getClassCode().getListVersionID()) + "\"";
                    }
                    xml = xml + ">" + classification.getClassCode().getCode() + "</ram:ClassCode>";
                    if (classification.getClassName() != null) {
                        xml = xml + "<ram:ClassName>" + XMLTools.encodeXML(classification.getClassName()) + "</ram:ClassName>";
                    }
                    xml = xml + "</ram:DesignatedProductClassification>";
                }
            }
            if (iZUGFeRDExportableItem.getProduct().getAttributes() != null) {
                for (Map.Entry<String, String> entry : iZUGFeRDExportableItem.getProduct().getAttributes().entrySet()) {
                    xml = xml + "<ram:ApplicableProductCharacteristic><ram:Description>" + XMLTools.encodeXML(entry.getKey()) + "</ram:Description><ram:Value>" + XMLTools.encodeXML(entry.getValue()) + "</ram:Value></ram:ApplicableProductCharacteristic>";
                }
            }
            if (iZUGFeRDExportableItem.getProduct().getCountryOfOrigin() != null) {
                xml = xml + "<ram:OriginTradeCountry><ram:ID>" + XMLTools.encodeXML(iZUGFeRDExportableItem.getProduct().getCountryOfOrigin()) + "</ram:ID></ram:OriginTradeCountry>";
            }
            xml = xml + "</ram:SpecifiedTradeProduct><ram:SpecifiedLineTradeAgreement>";
            if (iZUGFeRDExportableItem.getReferencedDocuments() != null) {
                for (IReferencedDocument currentReferencedDocument : iZUGFeRDExportableItem.getReferencedDocuments()) {
                    xml = xml + "<ram:AdditionalReferencedDocument><ram:IssuerAssignedID>" + XMLTools.encodeXML(currentReferencedDocument.getIssuerAssignedID()) + "</ram:IssuerAssignedID><ram:TypeCode>" + XMLTools.encodeXML(currentReferencedDocument.getTypeCode()) + "</ram:TypeCode><ram:ReferenceTypeCode>" + XMLTools.encodeXML(currentReferencedDocument.getReferenceTypeCode()) + "</ram:ReferenceTypeCode></ram:AdditionalReferencedDocument>";
                }
            }
            if (iZUGFeRDExportableItem.getBuyerOrderReferencedDocumentLineID() != null) {
                xml = xml + "<ram:BuyerOrderReferencedDocument> <ram:LineID>" + XMLTools.encodeXML(iZUGFeRDExportableItem.getBuyerOrderReferencedDocumentLineID()) + "</ram:LineID></ram:BuyerOrderReferencedDocument>";
            }
            if (!((String)allowanceChargeStr).isEmpty()) {
                xml = xml + "<ram:GrossPriceProductTradePrice><ram:ChargeAmount>" + this.priceFormat(lc.getPriceGross()) + "</ram:ChargeAmount><ram:BasisQuantity unitCode=\"" + XMLTools.encodeXML(iZUGFeRDExportableItem.getProduct().getUnit()) + "\">" + this.quantityFormat(iZUGFeRDExportableItem.getBasisQuantity()) + "</ram:BasisQuantity>" + (String)allowanceChargeStr + "</ram:GrossPriceProductTradePrice>";
            }
            xml = xml + "<ram:NetPriceProductTradePrice><ram:ChargeAmount>" + this.priceFormat(lc.getPrice()) + "</ram:ChargeAmount><ram:BasisQuantity unitCode=\"" + XMLTools.encodeXML(iZUGFeRDExportableItem.getProduct().getUnit()) + "\">" + this.quantityFormat(iZUGFeRDExportableItem.getBasisQuantity()) + "</ram:BasisQuantity></ram:NetPriceProductTradePrice></ram:SpecifiedLineTradeAgreement><ram:SpecifiedLineTradeDelivery><ram:BilledQuantity unitCode=\"" + XMLTools.encodeXML(iZUGFeRDExportableItem.getProduct().getUnit()) + "\">" + this.quantityFormat(iZUGFeRDExportableItem.getQuantity()) + "</ram:BilledQuantity></ram:SpecifiedLineTradeDelivery><ram:SpecifiedLineTradeSettlement><ram:ApplicableTradeTax><ram:TypeCode>VAT</ram:TypeCode>" + (String)exemptionReason + "<ram:CategoryCode>" + iZUGFeRDExportableItem.getProduct().getTaxCategoryCode() + "</ram:CategoryCode><ram:RateApplicablePercent>" + this.vatFormat(iZUGFeRDExportableItem.getProduct().getVATPercent()) + "</ram:RateApplicablePercent></ram:ApplicableTradeTax>";
            if (iZUGFeRDExportableItem.getDetailedDeliveryPeriodFrom() != null || iZUGFeRDExportableItem.getDetailedDeliveryPeriodTo() != null) {
                xml = xml + "<ram:BillingSpecifiedPeriod>";
                if (iZUGFeRDExportableItem.getDetailedDeliveryPeriodFrom() != null) {
                    xml = xml + "<ram:StartDateTime>" + ZUGFeRDDateFormat.DATE.udtFormat(iZUGFeRDExportableItem.getDetailedDeliveryPeriodFrom()) + "</ram:StartDateTime>";
                }
                if (iZUGFeRDExportableItem.getDetailedDeliveryPeriodTo() != null) {
                    xml = xml + "<ram:EndDateTime>" + ZUGFeRDDateFormat.DATE.udtFormat(iZUGFeRDExportableItem.getDetailedDeliveryPeriodTo()) + "</ram:EndDateTime>";
                }
                xml = xml + "</ram:BillingSpecifiedPeriod>";
            }
            xml = xml + (String)itemTotalAllowanceChargeStr;
            xml = xml + "<ram:SpecifiedTradeSettlementLineMonetarySummation><ram:LineTotalAmount>" + this.currencyFormat(lc.getItemTotalNetAmount()) + "</ram:LineTotalAmount></ram:SpecifiedTradeSettlementLineMonetarySummation>";
            if (iZUGFeRDExportableItem.getAdditionalReferences() != null) {
                for (IReferencedDocument currentReference : iZUGFeRDExportableItem.getAdditionalReferences()) {
                    xml = xml + "<ram:AdditionalReferencedDocument><ram:IssuerAssignedID>" + XMLTools.encodeXML(currentReference.getIssuerAssignedID()) + "</ram:IssuerAssignedID><ram:TypeCode>130</ram:TypeCode><ram:ReferenceTypeCode>" + XMLTools.encodeXML(currentReference.getReferenceTypeCode()) + "</ram:ReferenceTypeCode></ram:AdditionalReferencedDocument>";
                }
            } else if (iZUGFeRDExportableItem.getAdditionalReferencedDocumentID() != null) {
                xml = xml + "<ram:AdditionalReferencedDocument><ram:IssuerAssignedID>" + iZUGFeRDExportableItem.getAdditionalReferencedDocumentID() + "</ram:IssuerAssignedID><ram:TypeCode>130</ram:TypeCode></ram:AdditionalReferencedDocument>";
            }
            xml = xml + "</ram:SpecifiedLineTradeSettlement></ram:IncludedSupplyChainTradeLineItem>";
        }
        xml = xml + "<ram:ApplicableHeaderTradeAgreement>";
        if (trans.getReferenceNumber() != null) {
            xml = xml + "<ram:BuyerReference>" + XMLTools.encodeXML(trans.getReferenceNumber()) + "</ram:BuyerReference>";
        }
        xml = xml + "<ram:SellerTradeParty>" + this.getTradePartyAsXML(trans.getSender(), true, false) + "</ram:SellerTradeParty><ram:BuyerTradeParty>";
        xml = xml + this.getTradePartyAsXML(trans.getRecipient(), false, false);
        xml = xml + "</ram:BuyerTradeParty>";
        if (trans.getSellerOrderReferencedDocumentID() != null) {
            xml = xml + "<ram:SellerOrderReferencedDocument><ram:IssuerAssignedID>" + XMLTools.encodeXML(trans.getSellerOrderReferencedDocumentID()) + "</ram:IssuerAssignedID></ram:SellerOrderReferencedDocument>";
        }
        if (trans.getBuyerOrderReferencedDocumentID() != null) {
            xml = xml + "<ram:BuyerOrderReferencedDocument><ram:IssuerAssignedID>" + XMLTools.encodeXML(trans.getBuyerOrderReferencedDocumentID()) + "</ram:IssuerAssignedID></ram:BuyerOrderReferencedDocument>";
        }
        if (trans.getContractReferencedDocument() != null) {
            xml = xml + "<ram:ContractReferencedDocument><ram:IssuerAssignedID>" + XMLTools.encodeXML(trans.getContractReferencedDocument()) + "</ram:IssuerAssignedID></ram:ContractReferencedDocument>";
        }
        if (trans.getAdditionalReferencedDocuments() != null) {
            for (FileAttachment fileAttachment : trans.getAdditionalReferencedDocuments()) {
                String documentContent = new String(Base64.getEncoder().encodeToString(fileAttachment.getData()));
                xml = xml + "<ram:AdditionalReferencedDocument><ram:IssuerAssignedID>" + fileAttachment.getFilename() + "</ram:IssuerAssignedID><ram:TypeCode>916</ram:TypeCode><ram:Name>" + fileAttachment.getDescription() + "</ram:Name><ram:AttachmentBinaryObject mimeCode=\"" + fileAttachment.getMimetype() + "\"\nfilename=\"" + fileAttachment.getFilename() + "\">" + documentContent + "</ram:AttachmentBinaryObject></ram:AdditionalReferencedDocument>";
            }
        }
        if (trans.getSpecifiedProcuringProjectID() != null) {
            xml = xml + "<ram:SpecifiedProcuringProject><ram:ID>" + XMLTools.encodeXML(trans.getSpecifiedProcuringProjectID()) + "</ram:ID>";
            if (trans.getSpecifiedProcuringProjectName() != null) {
                xml = xml + "<ram:Name>" + XMLTools.encodeXML(trans.getSpecifiedProcuringProjectName()) + "</ram:Name>";
            }
            xml = xml + "</ram:SpecifiedProcuringProject>";
        }
        xml = xml + "</ram:ApplicableHeaderTradeAgreement>";
        xml = xml + "<ram:ApplicableHeaderTradeDelivery>";
        if (this.trans.getDeliveryAddress() != null) {
            xml = xml + "<ram:ShipToTradeParty>" + this.getTradePartyAsXML(this.trans.getDeliveryAddress(), false, true) + "</ram:ShipToTradeParty>";
        }
        if (trans.getDeliveryDate() != null) {
            xml = xml + "<ram:ActualDeliverySupplyChainEvent><ram:OccurrenceDateTime>";
            xml = xml + ZUGFeRDDateFormat.DATE.udtFormat(trans.getDeliveryDate());
            xml = xml + "</ram:OccurrenceDateTime>";
            xml = xml + "</ram:ActualDeliverySupplyChainEvent>";
        }
        if (trans.getDespatchAdviceReferencedDocumentID() != null) {
            xml = xml + "<ram:DespatchAdviceReferencedDocument>";
            xml = xml + "<ram:IssuerAssignedID>" + XMLTools.encodeXML(trans.getDespatchAdviceReferencedDocumentID()) + "</ram:IssuerAssignedID>";
            xml = xml + "</ram:DespatchAdviceReferencedDocument>";
        }
        xml = xml + "</ram:ApplicableHeaderTradeDelivery>";
        xml = xml + "<ram:ApplicableHeaderTradeSettlement>";
        if (trans.getCreditorReferenceID() != null && this.getProfile() != Profiles.getByName("Minimum")) {
            xml = xml + "<ram:CreditorReferenceID>" + XMLTools.encodeXML(trans.getCreditorReferenceID()) + "</ram:CreditorReferenceID>";
        }
        if (trans.getNumber() != null && this.getProfile() != Profiles.getByName("Minimum")) {
            xml = xml + "<ram:PaymentReference>" + XMLTools.encodeXML(trans.getNumber()) + "</ram:PaymentReference>";
        }
        xml = xml + "<ram:InvoiceCurrencyCode>" + trans.getCurrency() + "</ram:InvoiceCurrencyCode>";
        if (this.trans.getPayee() != null) {
            xml = xml + "<ram:PayeeTradeParty>" + this.getTradePartyPayeeAsXML(this.trans.getPayee()) + "</ram:PayeeTradeParty>";
        }
        if (trans.getTradeSettlementPayment() != null) {
            for (IZUGFeRDTradeSettlementPayment iZUGFeRDTradeSettlementPayment : trans.getTradeSettlementPayment()) {
                if (iZUGFeRDTradeSettlementPayment == null) continue;
                hasDueDate = true;
                if (this.getProfile() == Profiles.getByName("Minimum")) continue;
                xml = xml + iZUGFeRDTradeSettlementPayment.getSettlementXML();
            }
        }
        if (trans.getTradeSettlement() != null) {
            for (IZUGFeRDTradeSettlement iZUGFeRDTradeSettlement : trans.getTradeSettlement()) {
                if (iZUGFeRDTradeSettlement == null) continue;
                if (iZUGFeRDTradeSettlement instanceof IZUGFeRDTradeSettlementPayment) {
                    hasDueDate = true;
                }
                if (this.getProfile() == Profiles.getByName("Minimum")) continue;
                xml = xml + iZUGFeRDTradeSettlement.getSettlementXML();
            }
        }
        if (trans.getDocumentCode() == "384" || trans.getDocumentCode() == "381") {
            hasDueDate = false;
        }
        HashMap<BigDecimal, VATAmount> hashMap = this.calc.getVATPercentAmountMap();
        for (BigDecimal currentTaxPercent2 : hashMap.keySet()) {
            VATAmount vATAmount = (VATAmount)hashMap.get(currentTaxPercent2);
            if (vATAmount == null) continue;
            String amountCategoryCode = vATAmount.getCategoryCode();
            String amountDueDateTypeCode = vATAmount.getDueDateTypeCode();
            boolean displayExemptionReason = TaxCategoryCodeTypeConstants.CATEGORY_CODES_WITH_EXEMPTION_REASON.contains(amountCategoryCode);
            if (this.getProfile() == Profiles.getByName("Minimum")) continue;
            Object exemptionReasonTextXML = "";
            if (displayExemptionReason && vATAmount.getVatExemptionReasonText() != null) {
                exemptionReasonTextXML = "<ram:ExemptionReason>" + XMLTools.encodeXML(vATAmount.getVatExemptionReasonText()) + "</ram:ExemptionReason>";
            }
            xml = xml + "<ram:ApplicableTradeTax><ram:CalculatedAmount>" + this.currencyFormat(vATAmount.getCalculated()) + "</ram:CalculatedAmount><ram:TypeCode>VAT</ram:TypeCode>" + (String)exemptionReasonTextXML + "<ram:BasisAmount>" + this.currencyFormat(vATAmount.getBasis()) + "</ram:BasisAmount><ram:CategoryCode>" + amountCategoryCode + "</ram:CategoryCode>" + (String)(amountDueDateTypeCode != null ? "<ram:DueDateTypeCode>" + amountDueDateTypeCode + "</ram:DueDateTypeCode>" : "") + "<ram:RateApplicablePercent>" + this.vatFormat(currentTaxPercent2) + "</ram:RateApplicablePercent></ram:ApplicableTradeTax>";
        }
        if (trans.getDetailedDeliveryPeriodFrom() != null || trans.getDetailedDeliveryPeriodTo() != null) {
            xml = xml + "<ram:BillingSpecifiedPeriod>";
            if (trans.getDetailedDeliveryPeriodFrom() != null) {
                xml = xml + "<ram:StartDateTime>" + ZUGFeRDDateFormat.DATE.udtFormat(trans.getDetailedDeliveryPeriodFrom()) + "</ram:StartDateTime>";
            }
            if (trans.getDetailedDeliveryPeriodTo() != null) {
                xml = xml + "<ram:EndDateTime>" + ZUGFeRDDateFormat.DATE.udtFormat(trans.getDetailedDeliveryPeriodTo()) + "</ram:EndDateTime>";
            }
            xml = xml + "</ram:BillingSpecifiedPeriod>";
        }
        if (trans.getZFCharges() != null && trans.getZFCharges().length > 0) {
            if (this.profile == Profiles.getByName("XRechnung") || this.profile == Profiles.getByName("EN16931") || this.profile == Profiles.getByName("EXTENDED")) {
                void var11_35;
                object = trans.getZFCharges();
                currentTaxPercent2 = ((IZUGFeRDAllowanceCharge[])object).length;
                boolean bl = false;
                while (var11_35 < currentTaxPercent2) {
                    Object charge = object[var11_35];
                    xml = xml + "<ram:SpecifiedTradeAllowanceCharge><ram:ChargeIndicator><udt:Indicator>true</udt:Indicator></ram:ChargeIndicator><ram:ActualAmount>" + this.currencyFormat(charge.getTotalAmount(this.calc)) + "</ram:ActualAmount>";
                    if (charge.getReasonCode() != null) {
                        xml = xml + "<ram:ReasonCode>" + charge.getReasonCode() + "</ram:ReasonCode>";
                    }
                    if (charge.getReason() != null) {
                        xml = xml + "<ram:Reason>" + XMLTools.encodeXML(charge.getReason()) + "</ram:Reason>";
                    }
                    xml = xml + "<ram:CategoryTradeTax><ram:TypeCode>VAT</ram:TypeCode><ram:CategoryCode>" + charge.getCategoryCode() + "</ram:CategoryCode>";
                    if (charge.getTaxPercent() != null) {
                        xml = xml + "<ram:RateApplicablePercent>" + this.vatFormat(charge.getTaxPercent()) + "</ram:RateApplicablePercent>";
                    }
                    xml = xml + "</ram:CategoryTradeTax></ram:SpecifiedTradeAllowanceCharge>";
                    ++var11_35;
                }
            } else {
                for (BigDecimal currentTaxPercent3 : hashMap.keySet()) {
                    if (this.calc.getChargesForPercent(currentTaxPercent3).compareTo(BigDecimal.ZERO) == 0) continue;
                    xml = xml + "<ram:SpecifiedTradeAllowanceCharge><ram:ChargeIndicator><udt:Indicator>true</udt:Indicator></ram:ChargeIndicator><ram:ActualAmount>" + this.currencyFormat(this.calc.getChargesForPercent(currentTaxPercent3)) + "</ram:ActualAmount><ram:Reason>" + XMLTools.encodeXML(this.calc.getChargeReasonForPercent(currentTaxPercent3)) + "</ram:Reason><ram:CategoryTradeTax><ram:TypeCode>VAT</ram:TypeCode><ram:CategoryCode>" + ((VATAmount)hashMap.get(currentTaxPercent3)).getCategoryCode() + "</ram:CategoryCode><ram:RateApplicablePercent>" + this.vatFormat(currentTaxPercent3) + "</ram:RateApplicablePercent></ram:CategoryTradeTax></ram:SpecifiedTradeAllowanceCharge>";
                }
            }
        }
        if (trans.getZFAllowances() != null && trans.getZFAllowances().length > 0) {
            if (this.profile == Profiles.getByName("XRechnung")) {
                void var11_37;
                object = trans.getZFAllowances();
                currentTaxPercent2 = ((IZUGFeRDAllowanceCharge[])object).length;
                boolean bl = false;
                while (var11_37 < currentTaxPercent2) {
                    Object allowance = object[var11_37];
                    xml = xml + "<ram:SpecifiedTradeAllowanceCharge><ram:ChargeIndicator><udt:Indicator>false</udt:Indicator></ram:ChargeIndicator><ram:ActualAmount>" + this.currencyFormat(allowance.getTotalAmount(this.calc)) + "</ram:ActualAmount>";
                    if (allowance.getReason() != null) {
                        xml = xml + "<ram:Reason>" + XMLTools.encodeXML(allowance.getReason()) + "</ram:Reason>";
                    }
                    if (allowance.getReasonCode() != null) {
                        xml = xml + "<ram:ReasonCode>" + allowance.getReasonCode() + "</ram:ReasonCode>";
                    }
                    xml = xml + "<ram:CategoryTradeTax><ram:TypeCode>VAT</ram:TypeCode><ram:CategoryCode>" + allowance.getCategoryCode() + "</ram:CategoryCode>";
                    if (allowance.getTaxPercent() != null) {
                        xml = xml + "<ram:RateApplicablePercent>" + this.vatFormat(allowance.getTaxPercent()) + "</ram:RateApplicablePercent>";
                    }
                    xml = xml + "</ram:CategoryTradeTax></ram:SpecifiedTradeAllowanceCharge>";
                    ++var11_37;
                }
            } else {
                for (BigDecimal currentTaxPercent4 : hashMap.keySet()) {
                    if (this.calc.getAllowancesForPercent(currentTaxPercent4).compareTo(BigDecimal.ZERO) == 0) continue;
                    xml = xml + "<ram:SpecifiedTradeAllowanceCharge><ram:ChargeIndicator><udt:Indicator>false</udt:Indicator></ram:ChargeIndicator><ram:ActualAmount>" + this.currencyFormat(this.calc.getAllowancesForPercent(currentTaxPercent4)) + "</ram:ActualAmount><ram:Reason>" + XMLTools.encodeXML(this.calc.getAllowanceReasonForPercent(currentTaxPercent4)) + "</ram:Reason><ram:CategoryTradeTax><ram:TypeCode>VAT</ram:TypeCode><ram:CategoryCode>" + ((VATAmount)hashMap.get(currentTaxPercent4)).getCategoryCode() + "</ram:CategoryCode><ram:RateApplicablePercent>" + this.vatFormat(currentTaxPercent4) + "</ram:RateApplicablePercent></ram:CategoryTradeTax></ram:SpecifiedTradeAllowanceCharge>";
                }
            }
        }
        if (trans.getPaymentTerms() == null && this.getProfile() != Profiles.getByName("Minimum") && (this.paymentTermsDescription != null || trans.getTradeSettlement() != null || hasDueDate)) {
            xml = xml + "<ram:SpecifiedTradePaymentTerms>";
            if (this.paymentTermsDescription != null) {
                xml = xml + "<ram:Description>" + this.paymentTermsDescription + "</ram:Description>";
            }
            if (trans.getDueDate() != null) {
                xml = xml + "<ram:DueDateDateTime>" + ZUGFeRDDateFormat.DATE.udtFormat(trans.getDueDate()) + "</ram:DueDateDateTime>";
            }
            if (trans.getTradeSettlement() != null) {
                void var11_39;
                object = trans.getTradeSettlement();
                currentTaxPercent2 = ((Object)object).length;
                boolean bl = false;
                while (var11_39 < currentTaxPercent2) {
                    Object payment = object[var11_39];
                    if (payment != null && payment instanceof IZUGFeRDTradeSettlementDebit) {
                        xml = xml + payment.getPaymentXML();
                    }
                    ++var11_39;
                }
            }
            xml = xml + "</ram:SpecifiedTradePaymentTerms>";
        } else {
            xml = xml + this.buildPaymentTermsXml();
        }
        if (this.profile == Profiles.getByName("Extended") && trans.getCashDiscounts() != null && trans.getCashDiscounts().length > 0) {
            void var11_41;
            object = trans.getCashDiscounts();
            currentTaxPercent2 = ((Object)object).length;
            boolean bl = false;
            while (var11_41 < currentTaxPercent2) {
                Object discount = object[var11_41];
                xml = xml + discount.getAsCII();
                ++var11_41;
            }
        }
        String allowanceTotalLine = "<ram:AllowanceTotalAmount>" + this.currencyFormat(this.calc.getAllowancesForPercent(null)) + "</ram:AllowanceTotalAmount>";
        String chargesTotalLine = "<ram:ChargeTotalAmount>" + this.currencyFormat(this.calc.getChargesForPercent(null)) + "</ram:ChargeTotalAmount>";
        xml = xml + "<ram:SpecifiedTradeSettlementHeaderMonetarySummation>";
        if (this.getProfile() != Profiles.getByName("Minimum") && this.getProfile() != Profiles.getByName("BASICWL")) {
            xml = xml + "<ram:LineTotalAmount>" + this.currencyFormat(this.calc.getTotal()) + "</ram:LineTotalAmount>";
            xml = xml + chargesTotalLine + allowanceTotalLine;
        }
        xml = xml + "<ram:TaxBasisTotalAmount>" + this.currencyFormat(this.calc.getTaxBasis()) + "</ram:TaxBasisTotalAmount><ram:TaxTotalAmount currencyID=\"" + trans.getCurrency() + "\">" + this.currencyFormat(this.calc.getGrandTotal().subtract(this.calc.getTaxBasis())) + "</ram:TaxTotalAmount>";
        if (trans.getRoundingAmount() != null) {
            xml = xml + "<ram:RoundingAmount>" + this.currencyFormat(trans.getRoundingAmount()) + "</ram:RoundingAmount>";
        }
        xml = xml + "<ram:GrandTotalAmount>" + this.currencyFormat(this.calc.getGrandTotal()) + "</ram:GrandTotalAmount>";
        if (this.getProfile() != Profiles.getByName("Minimum")) {
            xml = xml + "<ram:TotalPrepaidAmount>" + this.currencyFormat(this.calc.getTotalPrepaid()) + "</ram:TotalPrepaidAmount>";
        }
        xml = xml + "<ram:DuePayableAmount>" + this.currencyFormat(this.calc.getDuePayable()) + "</ram:DuePayableAmount></ram:SpecifiedTradeSettlementHeaderMonetarySummation>";
        if (trans.getInvoiceReferencedDocumentID() != null) {
            xml = xml + "<ram:InvoiceReferencedDocument><ram:IssuerAssignedID>" + XMLTools.encodeXML(trans.getInvoiceReferencedDocumentID()) + "</ram:IssuerAssignedID>";
            if (trans.getInvoiceReferencedIssueDate() != null) {
                xml = xml + "<ram:FormattedIssueDateTime>" + ZUGFeRDDateFormat.DATE.qdtFormat(trans.getInvoiceReferencedIssueDate()) + "</ram:FormattedIssueDateTime>";
            }
            xml = xml + "</ram:InvoiceReferencedDocument>";
        }
        if (trans.getInvoiceReferencedDocuments() != null) {
            for (ReferencedDocument doc : trans.getInvoiceReferencedDocuments()) {
                xml = xml + "<ram:InvoiceReferencedDocument><ram:IssuerAssignedID>" + XMLTools.encodeXML(doc.getIssuerAssignedID()) + "</ram:IssuerAssignedID>";
                if (doc.getFormattedIssueDateTime() != null) {
                    xml = xml + "<ram:FormattedIssueDateTime>" + ZUGFeRDDateFormat.DATE.qdtFormat(doc.getFormattedIssueDateTime()) + "</ram:FormattedIssueDateTime>";
                }
                xml = xml + "</ram:InvoiceReferencedDocument>";
            }
        }
        xml = xml + "</ram:ApplicableHeaderTradeSettlement>";
        xml = xml + "</rsm:SupplyChainTradeTransaction></rsm:CrossIndustryInvoice>";
        byte[] byArray = xml.getBytes(StandardCharsets.UTF_8);
        this.zugferdData = XMLTools.removeBOM(byArray);
    }

    protected String buildItemNotes(IZUGFeRDExportableItem currentItem) {
        if (currentItem.getNotes() == null) {
            return "";
        }
        return Arrays.stream(currentItem.getNotes()).map(IncludedNote::unspecifiedNote).map(IncludedNote::toCiiXml).collect(Collectors.joining());
    }

    protected String buildNotes(IExportableTransaction exportableTransaction) {
        ArrayList<IncludedNote> includedNotes = new ArrayList<IncludedNote>();
        Optional.ofNullable(exportableTransaction.getNotesWithSubjectCode()).ifPresent(includedNotes::addAll);
        if (exportableTransaction.getNotes() != null) {
            for (String currentNote : exportableTransaction.getNotes()) {
                includedNotes.add(IncludedNote.unspecifiedNote(currentNote));
            }
        }
        if (exportableTransaction.rebateAgreementExists()) {
            includedNotes.add(IncludedNote.discountBonusNote("Es bestehen Rabatt- und Bonusvereinbarungen."));
        }
        Optional.ofNullable(exportableTransaction.getOwnOrganisationFullPlaintextInfo()).ifPresent(info -> includedNotes.add(IncludedNote.regulatoryNote(info)));
        Optional.ofNullable(exportableTransaction.getSubjectNote()).ifPresent(note -> includedNotes.add(IncludedNote.unspecifiedNote(note)));
        return includedNotes.stream().map(IncludedNote::toCiiXml).collect(Collectors.joining(""));
    }

    @Override
    public void setProfile(Profile p) {
        this.profile = p;
    }

    private String buildPaymentTermsXml() {
        IZUGFeRDPaymentTerms paymentTerms = this.trans.getPaymentTerms();
        if (paymentTerms == null) {
            return "";
        }
        Object paymentTermsXml = "<ram:SpecifiedTradePaymentTerms>";
        IZUGFeRDPaymentDiscountTerms discountTerms = paymentTerms.getDiscountTerms();
        Date dueDate = paymentTerms.getDueDate();
        if (dueDate != null && discountTerms != null && discountTerms.getBaseDate() != null) {
            throw new IllegalStateException("if paymentTerms.dueDate is specified, paymentTerms.discountTerms.baseDate has not to be specified");
        }
        paymentTermsXml = (String)paymentTermsXml + "<ram:Description>" + paymentTerms.getDescription() + "</ram:Description>";
        if (dueDate != null) {
            paymentTermsXml = (String)paymentTermsXml + "<ram:DueDateDateTime>";
            paymentTermsXml = (String)paymentTermsXml + ZUGFeRDDateFormat.DATE.udtFormat(dueDate);
            paymentTermsXml = (String)paymentTermsXml + "</ram:DueDateDateTime>";
        }
        if (this.trans.getTradeSettlement() != null) {
            for (IZUGFeRDTradeSettlement payment : this.trans.getTradeSettlement()) {
                if (payment == null || !(payment instanceof IZUGFeRDTradeSettlementDebit)) continue;
                paymentTermsXml = (String)paymentTermsXml + payment.getPaymentXML();
            }
        }
        if (discountTerms != null) {
            paymentTermsXml = (String)paymentTermsXml + "<ram:ApplicableTradePaymentDiscountTerms>";
            String currency = this.trans.getCurrency();
            String basisAmount = this.currencyFormat(this.calc.getGrandTotal());
            paymentTermsXml = (String)paymentTermsXml + "<ram:BasisAmount currencyID=\"" + currency + "\">" + basisAmount + "</ram:BasisAmount>";
            paymentTermsXml = (String)paymentTermsXml + "<ram:CalculationPercent>" + discountTerms.getCalculationPercentage().toString() + "</ram:CalculationPercent>";
            if (discountTerms.getBaseDate() != null) {
                Date baseDate = discountTerms.getBaseDate();
                paymentTermsXml = (String)paymentTermsXml + "<ram:BasisDateTime>";
                paymentTermsXml = (String)paymentTermsXml + ZUGFeRDDateFormat.DATE.udtFormat(baseDate);
                paymentTermsXml = (String)paymentTermsXml + "</ram:BasisDateTime>";
                paymentTermsXml = (String)paymentTermsXml + "<ram:BasisPeriodMeasure unitCode=\"" + discountTerms.getBasePeriodUnitCode() + "\">" + discountTerms.getBasePeriodMeasure() + "</ram:BasisPeriodMeasure>";
            }
            paymentTermsXml = (String)paymentTermsXml + "</ram:ApplicableTradePaymentDiscountTerms>";
        }
        paymentTermsXml = (String)paymentTermsXml + "</ram:SpecifiedTradePaymentTerms>";
        return paymentTermsXml;
    }
}

