/*
 * Decompiled with CFR 0.152.
 */
package org.mustangproject.ZUGFeRD;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.mustangproject.EStandard;
import org.mustangproject.XMLTools;
import org.mustangproject.ZUGFeRD.IExportableTransaction;
import org.mustangproject.ZUGFeRD.IXMLProvider;
import org.mustangproject.ZUGFeRD.IZUGFeRDExportableItem;
import org.mustangproject.ZUGFeRD.IZUGFeRDExportableTradeParty;
import org.mustangproject.ZUGFeRD.Profile;
import org.mustangproject.ZUGFeRD.Profiles;
import org.mustangproject.ZUGFeRD.TransactionCalculator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UBLDAPullProvider
implements IXMLProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(UBLDAPullProvider.class);
    protected IExportableTransaction trans;
    protected TransactionCalculator calc;
    byte[] ublData;
    protected Profile profile = Profiles.getByName(EStandard.ubldespatchadvice, "basic", 1);

    @Override
    public void generateXML(IExportableTransaction trans) {
        this.trans = trans;
        this.calc = new TransactionCalculator(trans);
        SimpleDateFormat ublDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<DespatchAdvice xmlns=\"urn:oasis:names:specification:ubl:schema:xsd:DespatchAdvice-2\" xmlns:cac=\"urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2\" xmlns:cbc=\"urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2\" xmlns:cec=\"urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2\" xmlns:csc=\"urn:oasis:names:specification:ubl:schema:xsd:CommonSignatureComponents-2\">\n  <cbc:UBLVersionID>2.2</cbc:UBLVersionID>\n  <cbc:CustomizationID>1Lieferschein</cbc:CustomizationID>\n  <cbc:ProfileID>ubl-xml-only</cbc:ProfileID>\n  <cbc:ID>" + XMLTools.encodeXML(trans.getNumber()) + "</cbc:ID>\n  <cbc:IssueDate>" + ublDateFormat.format(trans.getIssueDate()) + "</cbc:IssueDate>\n  <cbc:DespatchAdviceTypeCode>900</cbc:DespatchAdviceTypeCode>\n";
        if (trans.getReferenceNumber() != null) {
            xml = xml + "<cac:OrderReference>  <cbc:ID>" + XMLTools.encodeXML(trans.getNumber()) + "</cbc:ID></cac:OrderReference>\n";
        }
        xml = xml + "  <cac:DespatchSupplierParty>" + this.getPartyXML(trans.getSender()) + "</cac:DespatchSupplierParty>\n  <cac:DeliveryCustomerParty>" + this.getPartyXML(trans.getRecipient()) + "</cac:DeliveryCustomerParty>\n";
        if (trans.getDeliveryDate() != null) {
            xml = xml + "   <cac:Shipment><cbc:ID>1</cbc:ID><cac:Delivery><cbc:ActualDeliveryDate>" + ublDateFormat.format(trans.getDeliveryDate()) + "</cbc:ActualDeliveryDate></cac:Delivery></cac:Shipment>";
        }
        int i = 1;
        for (IZUGFeRDExportableItem item : trans.getZFItems()) {
            xml = xml + "  <cac:DespatchLine>\n    <cbc:ID>" + XMLTools.encodeXML(Integer.toString(i++)) + "</cbc:ID>\n    <cbc:DeliveredQuantity unitCode=\"" + XMLTools.encodeXML(item.getProduct().getUnit()) + "\">" + item.getQuantity() + "</cbc:DeliveredQuantity>\n    <cac:OrderLineReference>\n      <cbc:LineID>" + XMLTools.encodeXML(item.getBuyerOrderReferencedDocumentLineID()) + "</cbc:LineID>\n    </cac:OrderLineReference>\n    <cac:Item>\n      <cbc:Name>" + XMLTools.encodeXML(item.getProduct().getName()) + "</cbc:Name>\n    </cac:Item>\n  </cac:DespatchLine>\n";
        }
        xml = xml + "</DespatchAdvice>\n";
        byte[] ublRaw = xml.getBytes(StandardCharsets.UTF_8);
        this.ublData = XMLTools.removeBOM(ublRaw);
    }

    public String getPartyXML(IZUGFeRDExportableTradeParty tp) {
        return "<cac:Party>\n      <cac:PostalAddress>\n        <cbc:CityName>" + XMLTools.encodeXML(tp.getLocation()) + "</cbc:CityName>\n        <cac:AddressLine>\n          <cbc:Line>" + XMLTools.encodeXML(tp.getName()) + "</cbc:Line>\n        </cac:AddressLine>\n        <cac:AddressLine>\n          <cbc:Line>" + XMLTools.encodeXML(tp.getStreet()) + "</cbc:Line>\n        </cac:AddressLine>\n        <cac:Country>\n          <cbc:IdentificationCode>" + XMLTools.encodeXML(tp.getCountry()) + "</cbc:IdentificationCode>\n        </cac:Country>\n      </cac:PostalAddress>\n    </cac:Party>";
    }

    @Override
    public byte[] getXML() {
        byte[] res = this.ublData;
        StringWriter sw = new StringWriter();
        Document document = null;
        try {
            document = DocumentHelper.parseText((String)new String(this.ublData));
        }
        catch (DocumentException e1) {
            LOGGER.error("Failed to parse UBL", (Throwable)e1);
        }
        try {
            OutputFormat format = OutputFormat.createPrettyPrint();
            format.setTrimText(false);
            XMLWriter writer = new XMLWriter((Writer)sw, format);
            writer.write(document);
            res = sw.toString().getBytes(StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            LOGGER.error("Failed to write XML", (Throwable)e);
        }
        return res;
    }

    @Override
    public void setTest() {
    }

    @Override
    public void setProfile(Profile p) {
        this.profile = p;
    }

    @Override
    public Profile getProfile() {
        return this.profile;
    }
}

