/*
 * Decompiled with CFR 0.152.
 */
package org.mustangproject.ZUGFeRD;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.mustangproject.XMLTools;
import org.mustangproject.ZUGFeRD.IExportableTransaction;
import org.mustangproject.ZUGFeRD.IZUGFeRDExportableItem;
import org.mustangproject.ZUGFeRD.IZUGFeRDPaymentDiscountTerms;
import org.mustangproject.ZUGFeRD.IZUGFeRDPaymentTerms;
import org.mustangproject.ZUGFeRD.IZUGFeRDTradeSettlement;
import org.mustangproject.ZUGFeRD.IZUGFeRDTradeSettlementDebit;
import org.mustangproject.ZUGFeRD.IZUGFeRDTradeSettlementPayment;
import org.mustangproject.ZUGFeRD.LineCalculator;
import org.mustangproject.ZUGFeRD.Profile;
import org.mustangproject.ZUGFeRD.Profiles;
import org.mustangproject.ZUGFeRD.TransactionCalculator;
import org.mustangproject.ZUGFeRD.VATAmount;
import org.mustangproject.ZUGFeRD.ZUGFeRD2PullProvider;
import org.mustangproject.ZUGFeRD.ZUGFeRDDateFormat;
import org.mustangproject.ZUGFeRD.model.TaxCategoryCodeTypeConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZUGFeRD1PullProvider
extends ZUGFeRD2PullProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZUGFeRD1PullProvider.class);
    protected byte[] zugferdData;
    private String paymentTermsDescription;
    protected Profile profile = Profiles.getByName("COMFORT", 1);

    @Override
    public void setTest() {
    }

    @Override
    protected String vatFormat(BigDecimal value) {
        return XMLTools.nDigitFormat(value, 2);
    }

    @Override
    protected String currencyFormat(BigDecimal value) {
        return XMLTools.nDigitFormat(value, 2);
    }

    @Override
    protected String priceFormat(BigDecimal value) {
        return XMLTools.nDigitFormat(value, 4);
    }

    @Override
    protected String quantityFormat(BigDecimal value) {
        return XMLTools.nDigitFormat(value, 4);
    }

    @Override
    public Profile getProfile() {
        return this.profile;
    }

    @Override
    public byte[] getXML() {
        byte[] res = this.zugferdData;
        StringWriter sw = new StringWriter();
        Document document = null;
        try {
            document = DocumentHelper.parseText((String)new String(this.zugferdData));
        }
        catch (DocumentException e1) {
            LOGGER.error("Failed to parse ZUGFeRD data", (Throwable)e1);
        }
        try {
            OutputFormat format = OutputFormat.createPrettyPrint();
            format.setTrimText(false);
            XMLWriter writer = new XMLWriter((Writer)sw, format);
            writer.write(document);
            res = sw.toString().getBytes(StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            LOGGER.error("Failed to write ZUGFeRD data", (Throwable)e);
        }
        return res;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void generateXML(IExportableTransaction trans) {
        this.trans = trans;
        this.calc = new TransactionCalculator(trans);
        boolean hasDueDate = false;
        SimpleDateFormat germanDateFormat = new SimpleDateFormat("dd.MM.yyyy");
        Object exemptionReason = "";
        if (trans.getPaymentTermDescription() != null) {
            this.paymentTermsDescription = trans.getPaymentTermDescription();
        }
        if (this.paymentTermsDescription == null) {
            this.paymentTermsDescription = "Zahlbar ohne Abzug bis " + germanDateFormat.format(trans.getDueDate());
        }
        Object senderReg = "";
        if (trans.getOwnOrganisationFullPlaintextInfo() != null) {
            senderReg = "<ram:IncludedNote><ram:Content>" + XMLTools.encodeXML(trans.getOwnOrganisationFullPlaintextInfo()) + "</ram:Content><ram:SubjectCode>REG</ram:SubjectCode></ram:IncludedNote>";
        }
        String rebateAgreement = "";
        if (trans.rebateAgreementExists()) {
            rebateAgreement = "<ram:IncludedNote><ram:Content>Es bestehen Rabatt- und Bonusvereinbarungen.</ram:Content><ram:SubjectCode>AAK</ram:SubjectCode></ram:IncludedNote>";
        }
        Object subjectNote = "";
        if (trans.getSubjectNote() != null) {
            subjectNote = "<ram:IncludedNote><ram:Content>" + XMLTools.encodeXML(trans.getSubjectNote()) + "</ram:Content></ram:IncludedNote>";
        }
        String typecode = "380";
        if (trans.getDocumentCode() != null) {
            typecode = trans.getDocumentCode();
        }
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><rsm:CrossIndustryDocument xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:rsm=\"urn:ferd:CrossIndustryDocument:invoice:1p0\" xmlns:ram=\"urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:12\" xmlns:udt=\"urn:un:unece:uncefact:data:standard:UnqualifiedDataType:15\"><!-- generated by: mustangproject.org v" + ZUGFeRD1PullProvider.class.getPackage().getImplementationVersion() + "--><rsm:SpecifiedExchangedDocumentContext><ram:GuidelineSpecifiedDocumentContextParameter><ram:ID>" + this.getProfile().getID() + "</ram:ID></ram:GuidelineSpecifiedDocumentContextParameter></rsm:SpecifiedExchangedDocumentContext><rsm:HeaderExchangedDocument><ram:ID>" + XMLTools.encodeXML(trans.getNumber()) + "</ram:ID><ram:Name>RECHNUNG</ram:Name><ram:TypeCode>" + typecode + "</ram:TypeCode><ram:IssueDateTime>" + ZUGFeRDDateFormat.DATE.udtFormat(trans.getIssueDate()) + "</ram:IssueDateTime>" + (String)subjectNote + rebateAgreement + (String)senderReg + "</rsm:HeaderExchangedDocument><rsm:SpecifiedSupplyChainTradeTransaction>";
        xml = xml + "<ram:ApplicableSupplyChainTradeAgreement>";
        if (trans.getReferenceNumber() != null) {
            xml = xml + "<ram:BuyerReference>" + XMLTools.encodeXML(trans.getReferenceNumber()) + "</ram:BuyerReference>";
        }
        xml = xml + "<ram:SellerTradeParty>";
        xml = xml + this.getTradePartyAsXML(trans.getSender(), true, false);
        xml = xml + "</ram:SellerTradeParty><ram:BuyerTradeParty>";
        xml = xml + this.getTradePartyAsXML(trans.getRecipient(), false, false);
        if (trans.getOwnVATID() != null && trans.getOwnOrganisationName() != null) {
            xml = xml + "<ram:SpecifiedTaxRegistration><ram:ID schemeID=\"VA\">" + XMLTools.encodeXML(trans.getOwnVATID()) + "</ram:ID></ram:SpecifiedTaxRegistration>";
        }
        xml = xml + "</ram:BuyerTradeParty>";
        if (trans.getSellerOrderReferencedDocumentID() != null) {
            xml = xml + "<ram:SellerOrderReferencedDocument><ram:IssuerAssignedID>" + XMLTools.encodeXML(trans.getSellerOrderReferencedDocumentID()) + "</ram:IssuerAssignedID></ram:SellerOrderReferencedDocument>";
        }
        if (trans.getBuyerOrderReferencedDocumentID() != null) {
            xml = xml + "<ram:BuyerOrderReferencedDocument><ram:IssuerAssignedID>" + XMLTools.encodeXML(trans.getBuyerOrderReferencedDocumentID()) + "</ram:IssuerAssignedID></ram:BuyerOrderReferencedDocument>";
        }
        xml = xml + "</ram:ApplicableSupplyChainTradeAgreement><ram:ApplicableSupplyChainTradeDelivery>";
        if (this.trans.getDeliveryAddress() != null) {
            xml = xml + "<ram:ShipToTradeParty>" + this.getTradePartyAsXML(this.trans.getDeliveryAddress(), false, true) + "</ram:ShipToTradeParty>";
        }
        xml = xml + "<ram:ActualDeliverySupplyChainEvent><ram:OccurrenceDateTime>";
        if (trans.getDeliveryDate() == null) {
            throw new IllegalStateException("No delivery date provided");
        }
        xml = xml + ZUGFeRDDateFormat.DATE.udtFormat(trans.getDeliveryDate());
        xml = xml + "</ram:OccurrenceDateTime>";
        xml = xml + "</ram:ActualDeliverySupplyChainEvent></ram:ApplicableSupplyChainTradeDelivery><ram:ApplicableSupplyChainTradeSettlement><ram:PaymentReference>" + XMLTools.encodeXML(trans.getNumber()) + "</ram:PaymentReference><ram:InvoiceCurrencyCode>" + trans.getCurrency() + "</ram:InvoiceCurrencyCode>";
        if (trans.getTradeSettlementPayment() != null) {
            for (IZUGFeRDTradeSettlement iZUGFeRDTradeSettlement : trans.getTradeSettlementPayment()) {
                if (iZUGFeRDTradeSettlement == null) continue;
                hasDueDate = true;
                xml = xml + iZUGFeRDTradeSettlement.getSettlementXML();
            }
        }
        if (trans.getTradeSettlement() != null) {
            for (IZUGFeRDTradeSettlement iZUGFeRDTradeSettlement : trans.getTradeSettlement()) {
                if (iZUGFeRDTradeSettlement == null) continue;
                if (iZUGFeRDTradeSettlement instanceof IZUGFeRDTradeSettlementPayment) {
                    hasDueDate = true;
                }
                xml = xml + iZUGFeRDTradeSettlement.getSettlementXML();
            }
        }
        HashMap<BigDecimal, VATAmount> VATPercentAmountMap = this.calc.getVATPercentAmountMap();
        for (BigDecimal currentTaxPercent : VATPercentAmountMap.keySet()) {
            VATAmount vATAmount = VATPercentAmountMap.get(currentTaxPercent);
            if (vATAmount == null) continue;
            String amountCategoryCode = vATAmount.getCategoryCode();
            String amountDueDateTypeCode = vATAmount.getDueDateTypeCode();
            boolean displayExemptionReason = TaxCategoryCodeTypeConstants.CATEGORY_CODES_WITH_EXEMPTION_REASON.contains(amountCategoryCode);
            xml = xml + "<ram:ApplicableTradeTax><ram:CalculatedAmount currencyID=\"" + trans.getCurrency() + "\">" + this.currencyFormat(vATAmount.getCalculated()) + "</ram:CalculatedAmount><ram:TypeCode>VAT</ram:TypeCode>" + (String)(displayExemptionReason ? exemptionReason : "") + "<ram:BasisAmount currencyID=\"" + trans.getCurrency() + "\">" + this.currencyFormat(vATAmount.getBasis()) + "</ram:BasisAmount><ram:CategoryCode>" + vATAmount.getCategoryCode() + "</ram:CategoryCode>" + (String)(amountDueDateTypeCode != null ? "<ram:DueDateTypeCode>" + amountDueDateTypeCode + "</ram:DueDateTypeCode>" : "") + "<ram:ApplicablePercent>" + this.vatFormat(currentTaxPercent) + "</ram:ApplicablePercent></ram:ApplicableTradeTax>";
        }
        if (trans.getPaymentTerms() == null) {
            xml = xml + "<ram:SpecifiedTradePaymentTerms><ram:Description>" + this.paymentTermsDescription + "</ram:Description>";
            if (trans.getTradeSettlement() != null) {
                void var13_23;
                IZUGFeRDTradeSettlement[] iZUGFeRDTradeSettlementArray = trans.getTradeSettlement();
                int currentTaxPercent = iZUGFeRDTradeSettlementArray.length;
                boolean bl = false;
                while (var13_23 < currentTaxPercent) {
                    IZUGFeRDTradeSettlement payment = iZUGFeRDTradeSettlementArray[var13_23];
                    if (payment != null && payment instanceof IZUGFeRDTradeSettlementDebit) {
                        xml = xml + payment.getPaymentXML();
                    }
                    ++var13_23;
                }
            }
            if (hasDueDate && trans.getDueDate() != null) {
                xml = xml + "<ram:DueDateDateTime>" + ZUGFeRDDateFormat.DATE.udtFormat(trans.getDueDate()) + "</ram:DueDateDateTime>";
            }
            xml = xml + "</ram:SpecifiedTradePaymentTerms>";
        } else {
            xml = xml + this.buildPaymentTermsXml();
        }
        xml = xml + "<ram:SpecifiedTradeSettlementMonetarySummation><ram:LineTotalAmount currencyID=\"" + trans.getCurrency() + "\">" + this.currencyFormat(this.calc.getTotal()) + "</ram:LineTotalAmount><ram:ChargeTotalAmount currencyID=\"" + trans.getCurrency() + "\">" + this.currencyFormat(this.calc.getChargeTotal()) + "</ram:ChargeTotalAmount><ram:AllowanceTotalAmount currencyID=\"" + trans.getCurrency() + "\">" + this.currencyFormat(this.calc.getAllowanceTotal()) + "</ram:AllowanceTotalAmount><ram:TaxBasisTotalAmount currencyID=\"" + trans.getCurrency() + "\">" + this.currencyFormat(this.calc.getTaxBasis()) + "</ram:TaxBasisTotalAmount><ram:TaxTotalAmount currencyID=\"" + trans.getCurrency() + "\">" + this.currencyFormat(this.calc.getGrandTotal().subtract(this.calc.getTaxBasis())) + "</ram:TaxTotalAmount><ram:GrandTotalAmount currencyID=\"" + trans.getCurrency() + "\">" + this.currencyFormat(this.calc.getGrandTotal()) + "</ram:GrandTotalAmount><ram:TotalPrepaidAmount currencyID=\"" + trans.getCurrency() + "\">" + this.currencyFormat(this.calc.getTotalPrepaid()) + "</ram:TotalPrepaidAmount><ram:DuePayableAmount currencyID=\"" + trans.getCurrency() + "\">" + this.currencyFormat(this.calc.getGrandTotal().subtract(this.calc.getTotalPrepaid())) + "</ram:DuePayableAmount></ram:SpecifiedTradeSettlementMonetarySummation></ram:ApplicableSupplyChainTradeSettlement>";
        int lineID = 0;
        for (IZUGFeRDExportableItem currentItem : trans.getZFItems()) {
            ++lineID;
            if (currentItem.getProduct().getTaxExemptionReason() != null) {
                exemptionReason = "<ram:ExemptionReason>" + XMLTools.encodeXML(currentItem.getProduct().getTaxExemptionReason()) + "</ram:ExemptionReason>";
            }
            LineCalculator lc = new LineCalculator(currentItem);
            xml = xml + "<ram:IncludedSupplyChainTradeLineItem><ram:AssociatedDocumentLineDocument><ram:LineID>" + lineID + "</ram:LineID></ram:AssociatedDocumentLineDocument><ram:SpecifiedSupplyChainTradeAgreement><ram:GrossPriceProductTradePrice><ram:ChargeAmount currencyID=\"" + trans.getCurrency() + "\">" + this.priceFormat(lc.getPriceGross()) + "</ram:ChargeAmount><ram:BasisQuantity unitCode=\"" + XMLTools.encodeXML(currentItem.getProduct().getUnit()) + "\">" + this.quantityFormat(currentItem.getBasisQuantity()) + "</ram:BasisQuantity></ram:GrossPriceProductTradePrice><ram:NetPriceProductTradePrice><ram:ChargeAmount currencyID=\"" + trans.getCurrency() + "\">" + this.priceFormat(currentItem.getPrice()) + "</ram:ChargeAmount><ram:BasisQuantity unitCode=\"" + XMLTools.encodeXML(currentItem.getProduct().getUnit()) + "\">" + this.quantityFormat(currentItem.getBasisQuantity()) + "</ram:BasisQuantity></ram:NetPriceProductTradePrice></ram:SpecifiedSupplyChainTradeAgreement><ram:SpecifiedSupplyChainTradeDelivery><ram:BilledQuantity unitCode=\"" + XMLTools.encodeXML(currentItem.getProduct().getUnit()) + "\">" + this.quantityFormat(currentItem.getQuantity()) + "</ram:BilledQuantity></ram:SpecifiedSupplyChainTradeDelivery><ram:SpecifiedSupplyChainTradeSettlement><ram:ApplicableTradeTax><ram:TypeCode>VAT</ram:TypeCode>" + (String)exemptionReason + "<ram:CategoryCode>" + currentItem.getProduct().getTaxCategoryCode() + "</ram:CategoryCode><ram:ApplicablePercent>" + this.vatFormat(currentItem.getProduct().getVATPercent()) + "</ram:ApplicablePercent></ram:ApplicableTradeTax><ram:SpecifiedTradeSettlementMonetarySummation><ram:LineTotalAmount currencyID=\"" + trans.getCurrency() + "\">" + this.currencyFormat(lc.getItemTotalNetAmount()) + "</ram:LineTotalAmount></ram:SpecifiedTradeSettlementMonetarySummation>";
            if (currentItem.getAdditionalReferences() != null) {
                xml = xml + "<ram:AdditionalReferencedDocument><ram:ID>" + currentItem.getAdditionalReferences()[0].getIssuerAssignedID() + "</ram:ID><ram:TypeCode>130</ram:TypeCode></ram:AdditionalReferencedDocument>";
            } else if (currentItem.getAdditionalReferencedDocumentID() != null) {
                xml = xml + "<ram:AdditionalReferencedDocument><ram:ID>" + currentItem.getAdditionalReferencedDocumentID() + "</ram:ID><ram:TypeCode>130</ram:TypeCode></ram:AdditionalReferencedDocument>";
            }
            xml = xml + "</ram:SpecifiedSupplyChainTradeSettlement><ram:SpecifiedTradeProduct>";
            if (currentItem.getProduct().getSellerAssignedID() != null) {
                xml = xml + "<ram:SellerAssignedID>" + XMLTools.encodeXML(currentItem.getProduct().getSellerAssignedID()) + "</ram:SellerAssignedID>";
            }
            if (currentItem.getProduct().getBuyerAssignedID() != null) {
                xml = xml + "<ram:BuyerAssignedID>" + XMLTools.encodeXML(currentItem.getProduct().getBuyerAssignedID()) + "</ram:BuyerAssignedID>";
            }
            xml = xml + "<ram:Name>" + XMLTools.encodeXML(currentItem.getProduct().getName()) + "</ram:Name><ram:Description>" + XMLTools.encodeXML(currentItem.getProduct().getDescription()) + "</ram:Description></ram:SpecifiedTradeProduct></ram:IncludedSupplyChainTradeLineItem>";
        }
        xml = xml + "</rsm:SpecifiedSupplyChainTradeTransaction></rsm:CrossIndustryDocument>";
        byte[] zugferdRaw = xml.getBytes(StandardCharsets.UTF_8);
        this.zugferdData = XMLTools.removeBOM(zugferdRaw);
    }

    @Override
    public void setProfile(Profile p) {
        this.profile = p;
    }

    private String buildPaymentTermsXml() {
        Object paymentTermsXml = "<ram:SpecifiedTradePaymentTerms>";
        IZUGFeRDPaymentTerms paymentTerms = this.trans.getPaymentTerms();
        IZUGFeRDPaymentDiscountTerms discountTerms = paymentTerms.getDiscountTerms();
        Date dueDate = paymentTerms.getDueDate();
        if (dueDate != null && discountTerms != null && discountTerms.getBaseDate() != null) {
            throw new IllegalStateException("if paymentTerms.dueDate is specified, paymentTerms.discountTerms.baseDate has not to be specified");
        }
        paymentTermsXml = (String)paymentTermsXml + "<ram:Description>" + paymentTerms.getDescription() + "</ram:Description>";
        if (dueDate != null) {
            paymentTermsXml = (String)paymentTermsXml + "<ram:DueDateDateTime>";
            paymentTermsXml = (String)paymentTermsXml + ZUGFeRDDateFormat.DATE.udtFormat(dueDate);
            paymentTermsXml = (String)paymentTermsXml + "</ram:DueDateDateTime>";
        }
        if (discountTerms != null) {
            paymentTermsXml = (String)paymentTermsXml + "<ram:ApplicableTradePaymentDiscountTerms>";
            String currency = this.trans.getCurrency();
            String basisAmount = this.currencyFormat(this.calc.getGrandTotal());
            paymentTermsXml = (String)paymentTermsXml + "<ram:BasisAmount currencyID=\"" + currency + "\">" + basisAmount + "</ram:BasisAmount>";
            paymentTermsXml = (String)paymentTermsXml + "<ram:CalculationPercent>" + discountTerms.getCalculationPercentage().toString() + "</ram:CalculationPercent>";
            if (discountTerms.getBaseDate() != null) {
                Date baseDate = discountTerms.getBaseDate();
                paymentTermsXml = (String)paymentTermsXml + "<ram:BasisDateTime>";
                paymentTermsXml = (String)paymentTermsXml + ZUGFeRDDateFormat.DATE.udtFormat(baseDate);
                paymentTermsXml = (String)paymentTermsXml + "</ram:BasisDateTime>";
                paymentTermsXml = (String)paymentTermsXml + "<ram:BasisPeriodMeasure unitCode=\"" + discountTerms.getBasePeriodUnitCode() + "\">" + discountTerms.getBasePeriodMeasure() + "</ram:BasisPeriodMeasure>";
            }
            paymentTermsXml = (String)paymentTermsXml + "</ram:ApplicableTradePaymentDiscountTerms>";
        }
        paymentTermsXml = (String)paymentTermsXml + "</ram:SpecifiedTradePaymentTerms>";
        return paymentTermsXml;
    }
}

