/*
 * Decompiled with CFR 0.152.
 */
package org.mustangproject;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mustangproject.Allowance;
import org.mustangproject.Charge;
import org.mustangproject.ClassCode;
import org.mustangproject.DesignatedProductClassification;
import org.mustangproject.SchemedID;
import org.mustangproject.ZUGFeRD.IDesignatedProductClassification;
import org.mustangproject.ZUGFeRD.IZUGFeRDExportableProduct;
import org.mustangproject.util.NodeMap;
import org.w3c.dom.Node;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class Product
implements IZUGFeRDExportableProduct {
    protected String unit;
    protected String name;
    protected String sellerAssignedID;
    protected String buyerAssignedID;
    protected String description = "";
    protected String taxExemptionReason = null;
    protected String taxCategoryCode = null;
    protected BigDecimal VATPercent;
    protected boolean isReverseCharge = false;
    protected boolean isIntraCommunitySupply = false;
    protected SchemedID globalId = null;
    protected String countryOfOrigin = null;
    protected ArrayList<Charge> charges = new ArrayList();
    protected ArrayList<Allowance> allowances = new ArrayList();
    protected HashMap<String, String> attributes = new HashMap();
    protected List<IDesignatedProductClassification> classifications = new ArrayList<IDesignatedProductClassification>();

    public Product(String name, String description, String unit, BigDecimal VATPercent) {
        this.unit = unit;
        this.name = name;
        this.description = description;
        this.VATPercent = VATPercent;
    }

    public Product(Node node) {
        NodeMap nodeMap = new NodeMap(node);
        nodeMap.getNode("GlobalID").ifPresent(idNode -> {
            if (idNode.hasAttributes() && idNode.getAttributes().getNamedItem("schemeID") != null) {
                this.globalId = new SchemedID().setScheme(idNode.getAttributes().getNamedItem("schemeID").getNodeValue()).setId(idNode.getTextContent());
            }
        });
        nodeMap.getAsString("SellerAssignedID").ifPresent(this::setSellerAssignedID);
        nodeMap.getAsString("BuyerAssignedID").ifPresent(this::setBuyerAssignedID);
        nodeMap.getAsString("Name").ifPresent(this::setName);
        nodeMap.getAsString("Description").ifPresent(this::setDescription);
        nodeMap.getAllNodes("ApplicableProductCharacteristic").map(NodeMap::new).forEach(apcNodes -> {
            String key = apcNodes.getAsStringOrNull("Description");
            String value = apcNodes.getAsStringOrNull("Value");
            if (key != null && value != null) {
                if (this.attributes == null) {
                    this.attributes = new HashMap();
                }
                this.attributes.put(key, value);
            }
        });
        nodeMap.getAsNodeMap("AdditionalItemProperty").ifPresent(aipNodes -> {
            String name = aipNodes.getAsStringOrNull("Name");
            String val = aipNodes.getAsStringOrNull("Value");
            if (name != null && val != null) {
                if (this.attributes == null) {
                    this.attributes = new HashMap();
                }
                this.attributes.put(name, val);
            }
        });
        nodeMap.getAsNodeMap("CommodityClassification").ifPresent(dpcNodes -> {
            String className = dpcNodes.getAsStringOrNull("ClassName");
            dpcNodes.getNode("ItemClassificationCode").map(ClassCode::fromNode).ifPresent(classCode -> this.classifications.add(new DesignatedProductClassification((ClassCode)classCode, className)));
        });
        nodeMap.getAsNodeMap("DesignatedProductClassification").ifPresent(dpcNodes -> {
            String className = dpcNodes.getAsStringOrNull("ClassName");
            dpcNodes.getNode("ClassCode").map(ClassCode::fromNode).ifPresent(classCode -> this.classifications.add(new DesignatedProductClassification((ClassCode)classCode, className)));
        });
        nodeMap.getAsNodeMap("OriginTradeCountry").flatMap(nodes -> nodes.getNode("ID")).map(Node::getTextContent).ifPresent(this::setCountryOfOrigin);
    }

    public Product() {
    }

    @Override
    public String getGlobalID() {
        if (this.globalId == null) {
            return null;
        }
        return this.globalId.getID();
    }

    @Override
    public String getGlobalIDScheme() {
        if (this.globalId == null) {
            return null;
        }
        return this.globalId.getScheme();
    }

    public Product addGlobalID(SchemedID schemedID) {
        this.globalId = schemedID;
        return this;
    }

    @Override
    public String getTaxExemptionReason() {
        return this.taxExemptionReason;
    }

    public Product setTaxExemptionReason(String taxExemptionReasonText) {
        this.taxExemptionReason = taxExemptionReasonText;
        return this;
    }

    @Override
    public String getTaxCategoryCode() {
        if (this.taxCategoryCode == null) {
            return IZUGFeRDExportableProduct.super.getTaxCategoryCode();
        }
        return this.taxCategoryCode;
    }

    public Product setTaxCategoryCode(String code) {
        this.taxCategoryCode = code;
        return this;
    }

    @Override
    public String getSellerAssignedID() {
        return this.sellerAssignedID;
    }

    public Product setSellerAssignedID(String sellerAssignedID) {
        this.sellerAssignedID = sellerAssignedID;
        return this;
    }

    @Override
    public String getBuyerAssignedID() {
        return this.buyerAssignedID;
    }

    public Product setBuyerAssignedID(String buyerAssignedID) {
        this.buyerAssignedID = buyerAssignedID;
        return this;
    }

    @Override
    @JsonIgnore
    public boolean isReverseCharge() {
        return this.isReverseCharge;
    }

    @Override
    @JsonIgnore
    public boolean isIntraCommunitySupply() {
        return this.isIntraCommunitySupply;
    }

    public Product setReverseCharge() {
        this.isReverseCharge = true;
        this.setVATPercent(BigDecimal.ZERO);
        return this;
    }

    public Product setIntraCommunitySupply() {
        this.isIntraCommunitySupply = true;
        this.setVATPercent(BigDecimal.ZERO);
        this.setTaxExemptionReason("Intra-community supply");
        this.setTaxCategoryCode("K");
        return this;
    }

    @Override
    public String getUnit() {
        return this.unit;
    }

    public Product setUnit(String unit) {
        this.unit = unit;
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Product setName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public Product setDescription(String description) {
        this.description = description;
        return this;
    }

    @Override
    public BigDecimal getVATPercent() {
        return this.VATPercent;
    }

    public Product setVATPercent(BigDecimal VATPercent) {
        this.VATPercent = VATPercent == null ? BigDecimal.ZERO : VATPercent;
        return this;
    }

    @Override
    public String getCountryOfOrigin() {
        return this.countryOfOrigin;
    }

    public Product setCountryOfOrigin(String countryOfOrigin) {
        this.countryOfOrigin = countryOfOrigin;
        return this;
    }

    @Override
    public HashMap<String, String> getAttributes() {
        if (this.attributes.isEmpty()) {
            return null;
        }
        return this.attributes;
    }

    public Product setAttributes(Map<String, String> attributes) {
        this.attributes.clear();
        if (attributes != null) {
            this.attributes.putAll(attributes);
        }
        return this;
    }

    public Product addAttribute(String name, String value) {
        this.attributes.put(name, value);
        return this;
    }

    @Override
    public IDesignatedProductClassification[] getClassifications() {
        if (this.classifications.isEmpty()) {
            return null;
        }
        return this.classifications.toArray(new IDesignatedProductClassification[0]);
    }

    public Product setClassifications(IDesignatedProductClassification[] classifications) {
        this.classifications.clear();
        if (classifications != null) {
            this.classifications.addAll(Arrays.asList(classifications));
        }
        return this;
    }

    @JsonSetter(value="classifications")
    public Product setClassificationsClass(DesignatedProductClassification[] classifications) {
        this.classifications.clear();
        if (classifications != null) {
            this.classifications.addAll(Arrays.asList(classifications));
        }
        return this;
    }

    public Product addClassification(IDesignatedProductClassification classification) {
        this.classifications.add(classification);
        return this;
    }

    public Product addCharge(Charge e) {
        this.charges.add(e);
        return this;
    }

    public Product addAllowance(Allowance a) {
        this.allowances.add(a);
        return this;
    }

    public Product setCharges(ArrayList<Charge> charges) {
        this.charges = charges;
        return this;
    }

    public Charge[] getCharges() {
        if (this.charges.size() == 0) {
            return null;
        }
        Charge[] chargeArr = new Charge[this.charges.size()];
        return this.charges.toArray(chargeArr);
    }

    public Allowance[] getAllowances() {
        if (this.allowances.size() == 0) {
            return null;
        }
        Allowance[] allowanceArr = new Allowance[this.allowances.size()];
        return this.allowances.toArray(allowanceArr);
    }

    public Product setAllowances(ArrayList<Allowance> allowances) {
        this.allowances = allowances;
        return this;
    }
}

