/*
 * Decompiled with CFR 0.152.
 */
package org.mustangproject.ZUGFeRD;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.text.ParseException;
import org.mustangproject.XMLTools;
import org.mustangproject.ZUGFeRD.ZUGFeRDExportException;
import org.mustangproject.ZUGFeRD.ZUGFeRDImporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XRechnungImporter
extends ZUGFeRDImporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(XRechnungImporter.class);

    public XRechnungImporter(byte[] rawXml) {
        try {
            this.setRawXML(rawXml);
            this.containsMeta = true;
        }
        catch (IOException | ParseException e) {
            LOGGER.error("Failed to set raw XML", (Throwable)e);
            throw new ZUGFeRDExportException(e);
        }
    }

    public XRechnungImporter(String filename) {
        try {
            this.setRawXML(Files.readAllBytes(Paths.get(filename, new String[0])));
            this.containsMeta = true;
        }
        catch (IOException | ParseException e) {
            LOGGER.error("Failed to set raw XML", (Throwable)e);
            throw new ZUGFeRDExportException(e);
        }
    }

    public XRechnungImporter(InputStream fileinput) {
        try {
            this.setRawXML(XMLTools.getBytesFromStream(fileinput));
            this.containsMeta = true;
        }
        catch (IOException | ParseException e) {
            LOGGER.error("Failed to set raw XML", (Throwable)e);
            throw new ZUGFeRDExportException(e);
        }
    }
}

