/*
 * Decompiled with CFR 0.152.
 */
package org.mustangproject.ZUGFeRD;

import java.io.IOException;
import java.io.InputStream;
import javax.activation.DataSource;
import org.apache.pdfbox.preflight.PreflightDocument;
import org.apache.pdfbox.preflight.exception.ValidationException;
import org.apache.pdfbox.preflight.parser.PreflightParser;
import org.mustangproject.ZUGFeRD.IZUGFeRDExporter;
import org.mustangproject.ZUGFeRD.OXExporterFromA3;
import org.mustangproject.ZUGFeRD.PDFAConformanceLevel;
import org.mustangproject.ZUGFeRD.Profile;

public class OXExporterFromA1
extends OXExporterFromA3
implements IZUGFeRDExporter {
    protected boolean ignorePDFAErrors = false;

    public OXExporterFromA1 ignorePDFAErrors() {
        this.ignorePDFAErrors = true;
        return this;
    }

    private static boolean isValidA1(DataSource dataSource) throws IOException {
        return OXExporterFromA1.getPDFAParserValidationResult(new PreflightParser(dataSource));
    }

    @Override
    public String getNamespaceForVersion(int ver) {
        return "urn:factur-x:pdfa:CrossIndustryDocument:1p0#";
    }

    @Override
    public String getPrefixForVersion(int ver) {
        return "fx";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean getPDFAParserValidationResult(PreflightParser parser) throws IOException {
        parser.parse();
        try (PreflightDocument document = parser.getPreflightDocument();){
            document.validate();
            boolean bl = document.getResult().isValid();
            return bl;
        }
        catch (ValidationException e) {
            return false;
        }
    }

    @Override
    public OXExporterFromA1 setProfile(Profile p) {
        return (OXExporterFromA1)super.setProfile(p);
    }

    @Override
    public OXExporterFromA1 setProfile(String profileName) {
        return (OXExporterFromA1)super.setProfile(profileName);
    }

    @Override
    public boolean ensurePDFIsValid(DataSource dataSource) throws IOException {
        if (!this.ignorePDFAErrors && !OXExporterFromA1.isValidA1(dataSource)) {
            throw new IOException("File is not a valid PDF/A input file");
        }
        return true;
    }

    public OXExporterFromA1() {
        this.setZUGFeRDVersion(2);
    }

    @Override
    public OXExporterFromA1 load(String pdfFilename) throws IOException {
        return (OXExporterFromA1)super.load(pdfFilename);
    }

    @Override
    public OXExporterFromA1 load(byte[] pdfBinary) throws IOException {
        return (OXExporterFromA1)super.load(pdfBinary);
    }

    @Override
    public OXExporterFromA1 load(InputStream pdfSource) throws IOException {
        return (OXExporterFromA1)super.load(pdfSource);
    }

    @Override
    public OXExporterFromA1 setCreator(String creator) {
        return (OXExporterFromA1)super.setCreator(creator);
    }

    @Override
    public OXExporterFromA1 setConformanceLevel(PDFAConformanceLevel newLevel) {
        return (OXExporterFromA1)super.setConformanceLevel(newLevel);
    }

    @Override
    public OXExporterFromA1 setProducer(String producer) {
        return (OXExporterFromA1)super.setProducer(producer);
    }

    @Override
    public OXExporterFromA1 setZUGFeRDVersion(int version) {
        return (OXExporterFromA1)super.setZUGFeRDVersion(version);
    }

    @Override
    public OXExporterFromA1 setXML(byte[] zugferdData) throws IOException {
        return (OXExporterFromA1)super.setXML(zugferdData);
    }

    @Override
    public OXExporterFromA1 disableAutoClose(boolean disableAutoClose) {
        return (OXExporterFromA1)super.disableAutoClose(disableAutoClose);
    }

    public OXExporterFromA1 convertOnly() {
        this.setAttachZUGFeRDHeaders(false);
        return this;
    }
}

