/*
 * Decompiled with CFR 0.152.
 */
package org.mustangproject;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import org.mustangproject.Product;
import org.mustangproject.ReferencedDocument;
import org.mustangproject.ZUGFeRD.IReferencedDocument;
import org.mustangproject.ZUGFeRD.IZUGFeRDAllowanceCharge;
import org.mustangproject.ZUGFeRD.IZUGFeRDExportableItem;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Item
implements IZUGFeRDExportableItem {
    protected BigDecimal price;
    protected BigDecimal quantity;
    protected BigDecimal tax;
    protected BigDecimal grossPrice;
    protected BigDecimal lineTotalAmount;
    protected BigDecimal basisQuantity = BigDecimal.ONE;
    protected Date detailedDeliveryPeriodFrom = null;
    protected Date detailedDeliveryPeriodTo = null;
    protected String id;
    protected String referencedLineID = null;
    protected Product product;
    protected ArrayList<String> notes = null;
    protected ArrayList<ReferencedDocument> referencedDocuments = null;
    protected ArrayList<IZUGFeRDAllowanceCharge> Allowances = new ArrayList();
    protected ArrayList<IZUGFeRDAllowanceCharge> Charges = new ArrayList();

    public Item(Product product, BigDecimal price, BigDecimal quantity) {
        this.price = price;
        this.quantity = quantity;
        this.product = product;
    }

    public Item() {
    }

    public Item addReferencedLineID(String s) {
        this.referencedLineID = s;
        return this;
    }

    @Override
    public String getBuyerOrderReferencedDocumentLineID() {
        return this.referencedLineID;
    }

    public BigDecimal getLineTotalAmount() {
        return this.lineTotalAmount;
    }

    public Item setLineTotalAmount(BigDecimal lineTotalAmount) {
        this.lineTotalAmount = lineTotalAmount;
        return this;
    }

    public BigDecimal getGrossPrice() {
        return this.grossPrice;
    }

    public Item setGrossPrice(BigDecimal grossPrice) {
        this.grossPrice = grossPrice;
        return this;
    }

    public BigDecimal getTax() {
        return this.tax;
    }

    public Item setTax(BigDecimal tax) {
        this.tax = tax;
        return this;
    }

    public Item setId(String id) {
        this.id = id;
        return this;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public BigDecimal getPrice() {
        return this.price;
    }

    public Item setPrice(BigDecimal price) {
        this.price = price;
        return this;
    }

    @Override
    public BigDecimal getBasisQuantity() {
        return this.basisQuantity;
    }

    public Item setBasisQuantity(BigDecimal basis) {
        this.basisQuantity = basis;
        return this;
    }

    @Override
    public BigDecimal getQuantity() {
        return this.quantity;
    }

    public Item setQuantity(BigDecimal quantity) {
        this.quantity = quantity;
        return this;
    }

    @Override
    public Product getProduct() {
        return this.product;
    }

    @Override
    public IZUGFeRDAllowanceCharge[] getItemAllowances() {
        if (this.Allowances.isEmpty()) {
            return null;
        }
        return this.Allowances.toArray(new IZUGFeRDAllowanceCharge[0]);
    }

    @Override
    public IZUGFeRDAllowanceCharge[] getItemCharges() {
        if (this.Charges.isEmpty()) {
            return null;
        }
        return this.Charges.toArray(new IZUGFeRDAllowanceCharge[0]);
    }

    @Override
    public String[] getNotes() {
        if (this.notes == null) {
            return null;
        }
        return this.notes.toArray(new String[0]);
    }

    public Item setProduct(Product product) {
        this.product = product;
        return this;
    }

    public Item addCharge(IZUGFeRDAllowanceCharge izac) {
        this.Charges.add(izac);
        return this;
    }

    public Item addAllowance(IZUGFeRDAllowanceCharge izac) {
        this.Allowances.add(izac);
        return this;
    }

    public Item addNote(String text) {
        if (this.notes == null) {
            this.notes = new ArrayList();
        }
        this.notes.add(text);
        return this;
    }

    public Item addReferencedDocument(ReferencedDocument doc) {
        if (this.referencedDocuments == null) {
            this.referencedDocuments = new ArrayList();
        }
        this.referencedDocuments.add(doc);
        return this;
    }

    @Override
    public IReferencedDocument[] getReferencedDocuments() {
        if (this.referencedDocuments == null) {
            return null;
        }
        return this.referencedDocuments.toArray(new IReferencedDocument[0]);
    }

    public Item setDetailedDeliveryPeriod(Date from, Date to) {
        this.detailedDeliveryPeriodFrom = from;
        this.detailedDeliveryPeriodTo = to;
        return this;
    }

    @Override
    public Date getDetailedDeliveryPeriodFrom() {
        return this.detailedDeliveryPeriodFrom;
    }

    @Override
    public Date getDetailedDeliveryPeriodTo() {
        return this.detailedDeliveryPeriodTo;
    }
}

