/*
 * Decompiled with CFR 0.152.
 */
package org.mustangproject.ZUGFeRD;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mustangproject.EStandard;
import org.mustangproject.FileAttachment;
import org.mustangproject.XMLTools;
import org.mustangproject.ZUGFeRD.IExportableTransaction;
import org.mustangproject.ZUGFeRD.IXMLProvider;
import org.mustangproject.ZUGFeRD.IZUGFeRDAllowanceCharge;
import org.mustangproject.ZUGFeRD.IZUGFeRDExportableItem;
import org.mustangproject.ZUGFeRD.IZUGFeRDExportableTradeParty;
import org.mustangproject.ZUGFeRD.IZUGFeRDPaymentDiscountTerms;
import org.mustangproject.ZUGFeRD.IZUGFeRDPaymentTerms;
import org.mustangproject.ZUGFeRD.IZUGFeRDTradeSettlement;
import org.mustangproject.ZUGFeRD.IZUGFeRDTradeSettlementDebit;
import org.mustangproject.ZUGFeRD.IZUGFeRDTradeSettlementPayment;
import org.mustangproject.ZUGFeRD.LineCalculator;
import org.mustangproject.ZUGFeRD.Profile;
import org.mustangproject.ZUGFeRD.Profiles;
import org.mustangproject.ZUGFeRD.TransactionCalculator;
import org.mustangproject.ZUGFeRD.VATAmount;
import org.mustangproject.ZUGFeRD.ZUGFeRD2PullProvider;
import org.mustangproject.ZUGFeRD.ZUGFeRDDateFormat;
import org.mustangproject.ZUGFeRD.model.TaxCategoryCodeTypeConstants;

public class OXPullProvider
extends ZUGFeRD2PullProvider
implements IXMLProvider {
    protected IExportableTransaction trans;
    protected TransactionCalculator calc;
    private String paymentTermsDescription;
    protected Profile profile = Profiles.getByName(EStandard.orderx, "basic", 1);

    /*
     * WARNING - void declaration
     */
    @Override
    public void generateXML(IExportableTransaction trans) {
        this.trans = trans;
        this.calc = new TransactionCalculator(trans);
        boolean hasDueDate = false;
        SimpleDateFormat germanDateFormat = new SimpleDateFormat("dd.MM.yyyy");
        String exemptionReason = "";
        if (trans.getPaymentTermDescription() != null) {
            this.paymentTermsDescription = XMLTools.encodeXML(trans.getPaymentTermDescription());
        }
        if (this.paymentTermsDescription == null && trans.getDocumentCode() != "384") {
            this.paymentTermsDescription = "Zahlbar ohne Abzug bis " + germanDateFormat.format(trans.getDueDate());
        }
        String senderReg = "";
        if (trans.getOwnOrganisationFullPlaintextInfo() != null) {
            senderReg = "<ram:IncludedNote><ram:Content>" + XMLTools.encodeXML(trans.getOwnOrganisationFullPlaintextInfo()) + "</ram:Content><ram:SubjectCode>REG</ram:SubjectCode></ram:IncludedNote>";
        }
        String rebateAgreement = "";
        if (trans.rebateAgreementExists()) {
            rebateAgreement = "<ram:IncludedNote><ram:Content>Es bestehen Rabatt- und Bonusvereinbarungen.</ram:Content><ram:SubjectCode>AAK</ram:SubjectCode></ram:IncludedNote>";
        }
        String subjectNote = "";
        if (trans.getSubjectNote() != null) {
            subjectNote = "<ram:IncludedNote><ram:Content>" + XMLTools.encodeXML(trans.getSubjectNote()) + "</ram:Content></ram:IncludedNote>";
        }
        String typecode = "220";
        String notes = "";
        if (trans.getNotes() != null) {
            for (String currentNote : trans.getNotes()) {
                notes = notes + "<ram:IncludedNote><ram:Content>" + XMLTools.encodeXML(currentNote) + "</ram:Content></ram:IncludedNote>";
            }
        }
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><rsm:SCRDMCCBDACIOMessageStructure\nxmlns:rsm=\"urn:un:unece:uncefact:data:SCRDMCCBDACIOMessageStructure:100\"\nxmlns:udt=\"urn:un:unece:uncefact:data:standard:UnqualifiedDataType:128\"\nxmlns:qdt=\"urn:un:unece:uncefact:data:standard:QualifiedDataType:128\"\nxmlns:ram=\"urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:128\"\nxmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><rsm:ExchangedDocumentContext><ram:BusinessProcessSpecifiedDocumentContextParameter><ram:ID>A1</ram:ID></ram:BusinessProcessSpecifiedDocumentContextParameter><ram:GuidelineSpecifiedDocumentContextParameter><ram:ID>" + this.getProfile().getID() + "</ram:ID></ram:GuidelineSpecifiedDocumentContextParameter></rsm:ExchangedDocumentContext><rsm:ExchangedDocument><ram:ID>" + XMLTools.encodeXML(trans.getNumber()) + "</ram:ID><ram:TypeCode>" + "220" + "</ram:TypeCode><ram:IssueDateTime>" + ZUGFeRDDateFormat.DATE.udtFormat(trans.getIssueDate()) + "</ram:IssueDateTime>" + notes + subjectNote + rebateAgreement + senderReg + "</rsm:ExchangedDocument><rsm:SupplyChainTradeTransaction>";
        int lineID = 0;
        for (IZUGFeRDExportableItem currentItem : trans.getZFItems()) {
            int n;
            ++lineID;
            if (currentItem.getProduct().getTaxExemptionReason() != null) {
                // empty if block
            }
            notes = "";
            if (currentItem.getNotes() != null) {
                for (String currentNote : currentItem.getNotes()) {
                    notes = notes + "<ram:IncludedNote><ram:Content>" + XMLTools.encodeXML(currentNote) + "</ram:Content></ram:IncludedNote>";
                }
            }
            LineCalculator lineCalculator = new LineCalculator(currentItem);
            xml = xml + "<ram:IncludedSupplyChainTradeLineItem><ram:AssociatedDocumentLineDocument><ram:LineID>" + lineID + "</ram:LineID>" + notes + "</ram:AssociatedDocumentLineDocument><ram:SpecifiedTradeProduct>";
            if (currentItem.getProduct().getSellerAssignedID() != null) {
                xml = xml + "<ram:SellerAssignedID>" + XMLTools.encodeXML(currentItem.getProduct().getSellerAssignedID()) + "</ram:SellerAssignedID>";
            }
            if (currentItem.getProduct().getBuyerAssignedID() != null) {
                xml = xml + "<ram:BuyerAssignedID>" + XMLTools.encodeXML(currentItem.getProduct().getBuyerAssignedID()) + "</ram:BuyerAssignedID>";
            }
            String allowanceChargeStr = "";
            if (currentItem.getItemAllowances() != null && currentItem.getItemAllowances().length > 0) {
                IZUGFeRDAllowanceCharge[] iZUGFeRDAllowanceChargeArray = currentItem.getItemAllowances();
                int n2 = iZUGFeRDAllowanceChargeArray.length;
                for (n = 0; n < n2; ++n) {
                    IZUGFeRDAllowanceCharge allowance = iZUGFeRDAllowanceChargeArray[n];
                    allowanceChargeStr = allowanceChargeStr + this.getAllowanceChargeStr(allowance, currentItem);
                }
            }
            if (currentItem.getItemCharges() != null && currentItem.getItemCharges().length > 0) {
                IZUGFeRDAllowanceCharge[] iZUGFeRDAllowanceChargeArray = currentItem.getItemCharges();
                int n3 = iZUGFeRDAllowanceChargeArray.length;
                for (n = 0; n < n3; ++n) {
                    IZUGFeRDAllowanceCharge charge = iZUGFeRDAllowanceChargeArray[n];
                    allowanceChargeStr = allowanceChargeStr + this.getAllowanceChargeStr(charge, currentItem);
                }
            }
            xml = xml + "<ram:Name>" + XMLTools.encodeXML(currentItem.getProduct().getName()) + "</ram:Name><ram:Description>" + XMLTools.encodeXML(currentItem.getProduct().getDescription()) + "</ram:Description></ram:SpecifiedTradeProduct><ram:SpecifiedLineTradeAgreement>";
            if (currentItem.getBuyerOrderReferencedDocumentLineID() != null) {
                xml = xml + "<ram:BuyerOrderReferencedDocument> \n<ram:LineID>" + XMLTools.encodeXML(currentItem.getBuyerOrderReferencedDocumentLineID()) + "</ram:LineID></ram:BuyerOrderReferencedDocument>";
            }
            xml = xml + "<ram:GrossPriceProductTradePrice><ram:ChargeAmount>" + this.priceFormat(lineCalculator.getPriceGross()) + "</ram:ChargeAmount><ram:BasisQuantity unitCode=\"" + XMLTools.encodeXML(currentItem.getProduct().getUnit()) + "\">" + this.quantityFormat(currentItem.getBasisQuantity()) + "</ram:BasisQuantity>" + allowanceChargeStr + "</ram:GrossPriceProductTradePrice><ram:NetPriceProductTradePrice><ram:ChargeAmount>" + this.priceFormat(lineCalculator.getPrice()) + "</ram:ChargeAmount><ram:BasisQuantity unitCode=\"" + XMLTools.encodeXML(currentItem.getProduct().getUnit()) + "\">" + this.quantityFormat(currentItem.getBasisQuantity()) + "</ram:BasisQuantity></ram:NetPriceProductTradePrice></ram:SpecifiedLineTradeAgreement><ram:SpecifiedLineTradeDelivery><ram:RequestedQuantity unitCode=\"" + XMLTools.encodeXML(currentItem.getProduct().getUnit()) + "\">" + this.quantityFormat(currentItem.getQuantity()) + "</ram:RequestedQuantity></ram:SpecifiedLineTradeDelivery><ram:SpecifiedLineTradeSettlement><ram:ApplicableTradeTax><ram:TypeCode>VAT</ram:TypeCode>" + "" + "<ram:CategoryCode>" + currentItem.getProduct().getTaxCategoryCode() + "</ram:CategoryCode><ram:RateApplicablePercent>" + this.vatFormat(currentItem.getProduct().getVATPercent()) + "</ram:RateApplicablePercent></ram:ApplicableTradeTax>";
            if (currentItem.getDetailedDeliveryPeriodFrom() != null || currentItem.getDetailedDeliveryPeriodTo() != null) {
                xml = xml + "<ram:BillingSpecifiedPeriod>";
                if (currentItem.getDetailedDeliveryPeriodFrom() != null) {
                    xml = xml + "<ram:StartDateTime>" + ZUGFeRDDateFormat.DATE.udtFormat(currentItem.getDetailedDeliveryPeriodFrom()) + "</ram:StartDateTime>";
                }
                if (currentItem.getDetailedDeliveryPeriodTo() != null) {
                    xml = xml + "<ram:EndDateTime>" + ZUGFeRDDateFormat.DATE.udtFormat(currentItem.getDetailedDeliveryPeriodTo()) + "</ram:EndDateTime>";
                }
                xml = xml + "</ram:BillingSpecifiedPeriod>";
            }
            xml = xml + "<ram:SpecifiedTradeSettlementLineMonetarySummation><ram:LineTotalAmount>" + this.currencyFormat(lineCalculator.getItemTotalNetAmount()) + "</ram:LineTotalAmount></ram:SpecifiedTradeSettlementLineMonetarySummation>";
            xml = xml + "</ram:SpecifiedLineTradeSettlement></ram:IncludedSupplyChainTradeLineItem>";
        }
        xml = xml + "<ram:ApplicableHeaderTradeAgreement>";
        if (trans.getReferenceNumber() != null) {
            xml = xml + "<ram:BuyerReference>" + XMLTools.encodeXML(trans.getReferenceNumber()) + "</ram:BuyerReference>";
        }
        xml = xml + "<ram:SellerTradeParty>" + this.getTradePartyAsXML(trans.getSender(), true, false) + "</ram:SellerTradeParty><ram:BuyerTradeParty>";
        xml = xml + this.getTradePartyAsXML(trans.getRecipient(), false, false);
        xml = xml + "</ram:BuyerTradeParty>";
        if (trans.getSellerOrderReferencedDocumentID() != null) {
            xml = xml + "<ram:SellerOrderReferencedDocument><ram:IssuerAssignedID>" + XMLTools.encodeXML(trans.getSellerOrderReferencedDocumentID()) + "</ram:IssuerAssignedID></ram:SellerOrderReferencedDocument>";
        }
        if (trans.getBuyerOrderReferencedDocumentID() != null) {
            xml = xml + "<ram:BuyerOrderReferencedDocument><ram:IssuerAssignedID>" + XMLTools.encodeXML(trans.getBuyerOrderReferencedDocumentID()) + "</ram:IssuerAssignedID></ram:BuyerOrderReferencedDocument>";
        }
        if (trans.getContractReferencedDocument() != null) {
            xml = xml + "<ram:ContractReferencedDocument><ram:IssuerAssignedID>" + XMLTools.encodeXML(trans.getContractReferencedDocument()) + "</ram:IssuerAssignedID></ram:ContractReferencedDocument>";
        }
        if (trans.getAdditionalReferencedDocuments() != null) {
            for (FileAttachment f : trans.getAdditionalReferencedDocuments()) {
                String string = new String(Base64.getEncoder().encodeToString(f.getData()));
                xml = xml + "<ram:AdditionalReferencedDocument><ram:IssuerAssignedID>" + f.getFilename() + "</ram:IssuerAssignedID><ram:TypeCode>916</ram:TypeCode><ram:Name>" + f.getDescription() + "</ram:Name><ram:AttachmentBinaryObject mimeCode=\"" + f.getMimetype() + "\"\nfilename=\"" + f.getFilename() + "\">" + string + "</ram:AttachmentBinaryObject></ram:AdditionalReferencedDocument>";
            }
        }
        if (trans.getSpecifiedProcuringProjectID() != null) {
            xml = xml + "<ram:SpecifiedProcuringProject><ram:ID>" + XMLTools.encodeXML(trans.getSpecifiedProcuringProjectID()) + "</ram:ID>";
            if (trans.getSpecifiedProcuringProjectName() != null) {
                xml = xml + "<ram:Name >" + XMLTools.encodeXML(trans.getSpecifiedProcuringProjectName()) + "</ram:Name>";
            }
            xml = xml + "</ram:SpecifiedProcuringProject>";
        }
        xml = xml + "</ram:ApplicableHeaderTradeAgreement><ram:ApplicableHeaderTradeDelivery>";
        IZUGFeRDExportableTradeParty deliveryAddress = this.trans.getDeliveryAddress();
        if (deliveryAddress == null) {
            deliveryAddress = this.trans.getRecipient();
        }
        xml = xml + "<ram:ShipToTradeParty>" + this.getTradePartyAsXML(deliveryAddress, false, true) + "</ram:ShipToTradeParty>";
        xml = xml + "</ram:ApplicableHeaderTradeDelivery>\n<ram:ApplicableHeaderTradeSettlement><ram:OrderCurrencyCode>" + trans.getCurrency() + "</ram:OrderCurrencyCode>";
        if (trans.getTradeSettlementPayment() != null) {
            for (IZUGFeRDTradeSettlementPayment iZUGFeRDTradeSettlementPayment : trans.getTradeSettlementPayment()) {
                if (iZUGFeRDTradeSettlementPayment == null) continue;
                hasDueDate = true;
            }
        }
        if (trans.getTradeSettlement() != null) {
            for (IZUGFeRDTradeSettlement iZUGFeRDTradeSettlement : trans.getTradeSettlement()) {
                if (iZUGFeRDTradeSettlement == null || !(iZUGFeRDTradeSettlement instanceof IZUGFeRDTradeSettlementPayment)) continue;
                hasDueDate = true;
            }
        }
        if (trans.getDocumentCode() == "384") {
            hasDueDate = false;
        }
        HashMap<BigDecimal, VATAmount> VATPercentAmountMap = this.calc.getVATPercentAmountMap();
        for (BigDecimal currentTaxPercent : VATPercentAmountMap.keySet()) {
            VATAmount vATAmount = (VATAmount)VATPercentAmountMap.get(currentTaxPercent);
            if (vATAmount == null) continue;
            String amountCategoryCode = vATAmount.getCategoryCode();
            int n = TaxCategoryCodeTypeConstants.CATEGORY_CODES_WITH_EXEMPTION_REASON.contains(amountCategoryCode) ? 1 : 0;
        }
        if (trans.getDetailedDeliveryPeriodFrom() != null || trans.getDetailedDeliveryPeriodTo() != null) {
            xml = xml + "<ram:BillingSpecifiedPeriod>";
            if (trans.getDetailedDeliveryPeriodFrom() != null) {
                xml = xml + "<ram:StartDateTime>" + ZUGFeRDDateFormat.DATE.udtFormat(trans.getDetailedDeliveryPeriodFrom()) + "</ram:StartDateTime>";
            }
            if (trans.getDetailedDeliveryPeriodTo() != null) {
                xml = xml + "<ram:EndDateTime>" + ZUGFeRDDateFormat.DATE.udtFormat(trans.getDetailedDeliveryPeriodTo()) + "</ram:EndDateTime>";
            }
            xml = xml + "</ram:BillingSpecifiedPeriod>";
        }
        if (trans.getZFCharges() != null && trans.getZFCharges().length > 0) {
            for (BigDecimal currentTaxPercent : VATPercentAmountMap.keySet()) {
                if (this.calc.getChargesForPercent(currentTaxPercent).compareTo(BigDecimal.ZERO) == 0) continue;
                xml = xml + " <ram:SpecifiedTradeAllowanceCharge><ram:ChargeIndicator><udt:Indicator>true</udt:Indicator></ram:ChargeIndicator><ram:ActualAmount>" + this.currencyFormat(this.calc.getChargesForPercent(currentTaxPercent)) + "</ram:ActualAmount><ram:Reason>" + XMLTools.encodeXML(this.calc.getChargeReasonForPercent(currentTaxPercent)) + "</ram:Reason><ram:CategoryTradeTax><ram:TypeCode>VAT</ram:TypeCode><ram:CategoryCode>" + ((VATAmount)VATPercentAmountMap.get(currentTaxPercent)).getCategoryCode() + "</ram:CategoryCode><ram:RateApplicablePercent>" + this.vatFormat(currentTaxPercent) + "</ram:RateApplicablePercent></ram:CategoryTradeTax></ram:SpecifiedTradeAllowanceCharge>";
            }
        }
        if (trans.getZFAllowances() != null && trans.getZFAllowances().length > 0) {
            for (BigDecimal currentTaxPercent : VATPercentAmountMap.keySet()) {
                if (this.calc.getAllowancesForPercent(currentTaxPercent).compareTo(BigDecimal.ZERO) == 0) continue;
                xml = xml + "<ram:SpecifiedTradeAllowanceCharge><ram:ChargeIndicator><udt:Indicator>false</udt:Indicator></ram:ChargeIndicator><ram:ActualAmount>" + this.currencyFormat(this.calc.getAllowancesForPercent(currentTaxPercent)) + "</ram:ActualAmount><ram:Reason>" + XMLTools.encodeXML(this.calc.getAllowanceReasonForPercent(currentTaxPercent)) + "</ram:Reason><ram:CategoryTradeTax><ram:TypeCode>VAT</ram:TypeCode><ram:CategoryCode>" + ((VATAmount)VATPercentAmountMap.get(currentTaxPercent)).getCategoryCode() + "</ram:CategoryCode><ram:RateApplicablePercent>" + this.vatFormat(currentTaxPercent) + "</ram:RateApplicablePercent></ram:CategoryTradeTax></ram:SpecifiedTradeAllowanceCharge>\t\n";
            }
        }
        if (trans.getPaymentTerms() == null && (this.paymentTermsDescription != null || trans.getTradeSettlement() != null || hasDueDate)) {
            xml = xml + "<ram:SpecifiedTradePaymentTerms>";
            if (this.paymentTermsDescription != null) {
                xml = xml + "<ram:Description>" + this.paymentTermsDescription + "</ram:Description>";
            }
            if (trans.getTradeSettlement() != null) {
                void var16_41;
                IZUGFeRDTradeSettlement[] iZUGFeRDTradeSettlementArray = trans.getTradeSettlement();
                int currentTaxPercent = iZUGFeRDTradeSettlementArray.length;
                boolean bl = false;
                while (var16_41 < currentTaxPercent) {
                    IZUGFeRDTradeSettlement payment = iZUGFeRDTradeSettlementArray[var16_41];
                    if (payment == null || payment instanceof IZUGFeRDTradeSettlementDebit) {
                        // empty if block
                    }
                    ++var16_41;
                }
            }
            xml = xml + "</ram:SpecifiedTradePaymentTerms>";
        } else {
            xml = xml + this.buildPaymentTermsXml();
        }
        String allowanceTotalLine = "<ram:AllowanceTotalAmount>" + this.currencyFormat(this.calc.getAllowancesForPercent(null)) + "</ram:AllowanceTotalAmount>";
        String chargesTotalLine = "<ram:ChargeTotalAmount>" + this.currencyFormat(this.calc.getChargesForPercent(null)) + "</ram:ChargeTotalAmount>";
        xml = xml + "<ram:SpecifiedTradeSettlementHeaderMonetarySummation><ram:LineTotalAmount>" + this.currencyFormat(this.calc.getTotal()) + "</ram:LineTotalAmount>" + chargesTotalLine + allowanceTotalLine + "<ram:TaxBasisTotalAmount>" + this.currencyFormat(this.calc.getTaxBasis()) + "</ram:TaxBasisTotalAmount><ram:TaxTotalAmount currencyID=\"" + trans.getCurrency() + "\">" + this.currencyFormat(this.calc.getGrandTotal().subtract(this.calc.getTaxBasis())) + "</ram:TaxTotalAmount><ram:GrandTotalAmount>" + this.currencyFormat(this.calc.getGrandTotal()) + "</ram:GrandTotalAmount></ram:SpecifiedTradeSettlementHeaderMonetarySummation>";
        if (trans.getInvoiceReferencedDocumentID() != null) {
            xml = xml + "<ram:InvoiceReferencedDocument><ram:IssuerAssignedID>" + XMLTools.encodeXML(trans.getInvoiceReferencedDocumentID()) + "</ram:IssuerAssignedID>";
            if (trans.getInvoiceReferencedIssueDate() != null) {
                xml = xml + "<ram:FormattedIssueDateTime>" + ZUGFeRDDateFormat.DATE.qdtFormat(trans.getInvoiceReferencedIssueDate()) + "</ram:FormattedIssueDateTime>";
            }
            xml = xml + "</ram:InvoiceReferencedDocument>";
        }
        xml = xml + "</ram:ApplicableHeaderTradeSettlement>";
        xml = xml + "</rsm:SupplyChainTradeTransaction></rsm:SCRDMCCBDACIOMessageStructure>";
        try {
            byte[] byArray = xml.getBytes("UTF-8");
            this.zugferdData = XMLTools.removeBOM(byArray);
        }
        catch (UnsupportedEncodingException e) {
            Logger.getLogger(OXPullProvider.class.getName()).log(Level.SEVERE, null, e);
        }
    }

    @Override
    public void setProfile(Profile p) {
        this.profile = p;
    }

    @Override
    public Profile getProfile() {
        return this.profile;
    }

    private String buildPaymentTermsXml() {
        IZUGFeRDPaymentTerms paymentTerms = this.trans.getPaymentTerms();
        if (paymentTerms == null) {
            return "";
        }
        String paymentTermsXml = "<ram:SpecifiedTradePaymentTerms>";
        IZUGFeRDPaymentDiscountTerms discountTerms = paymentTerms.getDiscountTerms();
        paymentTermsXml = paymentTermsXml + "<ram:Description>" + paymentTerms.getDescription() + "</ram:Description>";
        if (discountTerms != null) {
            paymentTermsXml = paymentTermsXml + "<ram:ApplicableTradePaymentDiscountTerms>";
            String currency = this.trans.getCurrency();
            String basisAmount = this.currencyFormat(this.calc.getGrandTotal());
            paymentTermsXml = paymentTermsXml + "<ram:BasisAmount currencyID=\"" + currency + "\">" + basisAmount + "</ram:BasisAmount>";
            paymentTermsXml = paymentTermsXml + "<ram:CalculationPercent>" + discountTerms.getCalculationPercentage().toString() + "</ram:CalculationPercent>";
            if (discountTerms.getBaseDate() != null) {
                Date baseDate = discountTerms.getBaseDate();
                paymentTermsXml = paymentTermsXml + "<ram:BasisDateTime>";
                paymentTermsXml = paymentTermsXml + ZUGFeRDDateFormat.DATE.udtFormat(baseDate);
                paymentTermsXml = paymentTermsXml + "</ram:BasisDateTime>";
                paymentTermsXml = paymentTermsXml + "<ram:BasisPeriodMeasure unitCode=\"" + discountTerms.getBasePeriodUnitCode() + "\">" + discountTerms.getBasePeriodMeasure() + "</ram:BasisPeriodMeasure>";
            }
            paymentTermsXml = paymentTermsXml + "</ram:ApplicableTradePaymentDiscountTerms>";
        }
        paymentTermsXml = paymentTermsXml + "</ram:SpecifiedTradePaymentTerms>";
        return paymentTermsXml;
    }
}

