/*
 * Decompiled with CFR 0.152.
 */
package org.mustangproject.ZUGFeRD;

import java.io.IOException;
import java.io.InputStream;
import javax.activation.DataSource;
import org.apache.pdfbox.preflight.PreflightDocument;
import org.apache.pdfbox.preflight.exception.ValidationException;
import org.apache.pdfbox.preflight.parser.PreflightParser;
import org.mustangproject.EStandard;
import org.mustangproject.ZUGFeRD.IZUGFeRDExporter;
import org.mustangproject.ZUGFeRD.PDFAConformanceLevel;
import org.mustangproject.ZUGFeRD.Profile;
import org.mustangproject.ZUGFeRD.ZUGFeRDExporterFromA3;

public class ZUGFeRDExporterFromA1
extends ZUGFeRDExporterFromA3
implements IZUGFeRDExporter {
    protected boolean ignorePDFAErrors = false;

    public ZUGFeRDExporterFromA1 ignorePDFAErrors() {
        this.ignorePDFAErrors = true;
        return this;
    }

    private static boolean isValidA1(DataSource dataSource) throws IOException {
        return ZUGFeRDExporterFromA1.getPDFAParserValidationResult(new PreflightParser(dataSource));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean getPDFAParserValidationResult(PreflightParser parser) throws IOException {
        parser.parse();
        try (PreflightDocument document = parser.getPreflightDocument();){
            document.validate();
            boolean bl = document.getResult().isValid();
            return bl;
        }
        catch (ValidationException e) {
            return false;
        }
    }

    @Override
    public ZUGFeRDExporterFromA1 setProfile(Profile p) {
        return (ZUGFeRDExporterFromA1)super.setProfile(p);
    }

    @Override
    public ZUGFeRDExporterFromA1 setProfile(String profileName) {
        return (ZUGFeRDExporterFromA1)super.setProfile(profileName);
    }

    @Override
    public boolean ensurePDFIsValid(DataSource dataSource) throws IOException {
        if (!this.ignorePDFAErrors && !ZUGFeRDExporterFromA1.isValidA1(dataSource)) {
            throw new IOException("File is not a valid PDF/A-1 input file");
        }
        return true;
    }

    public ZUGFeRDExporterFromA1() {
        this.setZUGFeRDVersion(2);
    }

    @Override
    public ZUGFeRDExporterFromA1 load(String pdfFilename) throws IOException {
        return (ZUGFeRDExporterFromA1)super.load(pdfFilename);
    }

    @Override
    public ZUGFeRDExporterFromA1 load(byte[] pdfBinary) throws IOException {
        return (ZUGFeRDExporterFromA1)super.load(pdfBinary);
    }

    @Override
    public ZUGFeRDExporterFromA1 load(InputStream pdfSource) throws IOException {
        return (ZUGFeRDExporterFromA1)super.load(pdfSource);
    }

    @Override
    public ZUGFeRDExporterFromA1 setCreator(String creator) {
        return (ZUGFeRDExporterFromA1)super.setCreator(creator);
    }

    @Override
    public ZUGFeRDExporterFromA1 setConformanceLevel(PDFAConformanceLevel newLevel) {
        return (ZUGFeRDExporterFromA1)super.setConformanceLevel(newLevel);
    }

    @Override
    public ZUGFeRDExporterFromA1 setProducer(String producer) {
        return (ZUGFeRDExporterFromA1)super.setProducer(producer);
    }

    @Override
    public ZUGFeRDExporterFromA1 setZUGFeRDVersion(EStandard est, int version) {
        return (ZUGFeRDExporterFromA1)super.setZUGFeRDVersion(est, version);
    }

    @Override
    public ZUGFeRDExporterFromA1 setZUGFeRDVersion(int version) {
        return (ZUGFeRDExporterFromA1)super.setZUGFeRDVersion(version);
    }

    @Override
    public ZUGFeRDExporterFromA1 setXML(byte[] zugferdData) throws IOException {
        return (ZUGFeRDExporterFromA1)super.setXML(zugferdData);
    }

    @Override
    public ZUGFeRDExporterFromA1 disableAutoClose(boolean disableAutoClose) {
        return (ZUGFeRDExporterFromA1)super.disableAutoClose(disableAutoClose);
    }

    public ZUGFeRDExporterFromA1 convertOnly() {
        this.setAttachZUGFeRDHeaders(false);
        return this;
    }
}

