/*
 * Decompiled with CFR 0.152.
 */
package org.mustangproject.ZUGFeRD;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentNameDictionary;
import org.apache.pdfbox.pdmodel.PDEmbeddedFilesNameTreeNode;
import org.apache.pdfbox.pdmodel.common.PDNameTreeNode;
import org.apache.pdfbox.pdmodel.common.filespecification.PDComplexFileSpecification;
import org.apache.pdfbox.pdmodel.common.filespecification.PDEmbeddedFile;
import org.mustangproject.EStandard;
import org.mustangproject.Item;
import org.mustangproject.Product;
import org.mustangproject.ZUGFeRD.PostalTradeAddress;
import org.mustangproject.ZUGFeRD.ZUGFeRDDateFormat;
import org.mustangproject.ZUGFeRD.ZUGFeRDExportException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ZUGFeRDImporter {
    protected boolean containsMeta = false;
    private final HashMap<String, byte[]> additionalXMLs = new HashMap();
    private byte[] rawXML = null;
    private String xmpString = null;
    private Document document;
    private Integer version;

    protected ZUGFeRDImporter() {
    }

    public ZUGFeRDImporter(String pdfFilename) {
        try (InputStream bis = Files.newInputStream(Paths.get(pdfFilename, new String[0]), StandardOpenOption.READ);){
            this.extractLowLevel(bis);
        }
        catch (IOException e) {
            Logger.getLogger(ZUGFeRDImporter.class.getName()).log(Level.SEVERE, null, e);
            throw new ZUGFeRDExportException(e);
        }
    }

    public ZUGFeRDImporter(InputStream pdfStream) {
        try {
            this.extractLowLevel(pdfStream);
        }
        catch (IOException e) {
            Logger.getLogger(ZUGFeRDImporter.class.getName()).log(Level.SEVERE, null, e);
            throw new ZUGFeRDExportException(e);
        }
    }

    private void extractLowLevel(InputStream pdfStream) throws IOException {
        try (PDDocument doc = PDDocument.load((InputStream)pdfStream);){
            PDDocumentNameDictionary names = new PDDocumentNameDictionary(doc.getDocumentCatalog());
            if (doc.getDocumentCatalog() == null || doc.getDocumentCatalog().getMetadata() == null) {
                Logger.getLogger(ZUGFeRDImporter.class.getName()).log(Level.INFO, "no-xmlpart");
                return;
            }
            InputStream XMP = doc.getDocumentCatalog().getMetadata().exportXMPMetadata();
            this.xmpString = ZUGFeRDImporter.convertStreamToString(XMP);
            PDEmbeddedFilesNameTreeNode etn = names.getEmbeddedFiles();
            if (etn == null) {
                return;
            }
            Map efMap = etn.getNames();
            if (efMap != null) {
                this.extractFiles(efMap);
            } else {
                List kids = etn.getKids();
                for (PDNameTreeNode node : kids) {
                    Map namesL = node.getNames();
                    this.extractFiles(namesL);
                }
            }
        }
    }

    private void extractFiles(Map<String, PDComplexFileSpecification> names) throws IOException {
        for (String alias : names.keySet()) {
            PDEmbeddedFile embeddedFile;
            PDComplexFileSpecification fileSpec = names.get(alias);
            String filename = fileSpec.getFilename();
            if (filename.equals("ZUGFeRD-invoice.xml") || filename.equals("zugferd-invoice.xml") || filename.equals("factur-x.xml") || filename.equals("xrechnung.xml") || filename.equals("order-x.xml") || filename.equals("cida.xml")) {
                this.containsMeta = true;
                embeddedFile = fileSpec.getEmbeddedFile();
                this.setRawXML(embeddedFile.toByteArray());
            }
            if (!filename.startsWith("additional_data")) continue;
            embeddedFile = fileSpec.getEmbeddedFile();
            this.additionalXMLs.put(filename, embeddedFile.toByteArray());
        }
    }

    protected Document getDocument() {
        return this.document;
    }

    private void setDocument() throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilderFactory xmlFact = DocumentBuilderFactory.newInstance();
        xmlFact.setNamespaceAware(true);
        DocumentBuilder builder = xmlFact.newDocumentBuilder();
        ByteArrayInputStream is = new ByteArrayInputStream(this.rawXML);
        this.document = builder.parse(is);
    }

    public void setRawXML(byte[] rawXML) throws IOException {
        this.rawXML = rawXML;
        this.version = null;
        try {
            this.setDocument();
        }
        catch (ParserConfigurationException | SAXException e) {
            Logger.getLogger(ZUGFeRDImporter.class.getName()).log(Level.SEVERE, null, e);
            throw new ZUGFeRDExportException(e);
        }
    }

    protected String extractString(String xpathStr) {
        String result;
        if (!this.containsMeta) {
            throw new ZUGFeRDExportException("No suitable data/ZUGFeRD file could be found.");
        }
        try {
            Document document = this.getDocument();
            XPathFactory xpathFact = XPathFactory.newInstance();
            XPath xpath = xpathFact.newXPath();
            result = xpath.evaluate(xpathStr, document);
        }
        catch (XPathExpressionException e) {
            Logger.getLogger(ZUGFeRDImporter.class.getName()).log(Level.SEVERE, null, e);
            throw new ZUGFeRDExportException(e);
        }
        return result;
    }

    public String wExtractString(String xpathStr) {
        return this.extractString(xpathStr);
    }

    public String getForeignReference() {
        String result = this.extractString("//*[local-name() = 'ApplicableHeaderTradeSettlement']/*[local-name() = 'PaymentReference']");
        if (result == null || result.isEmpty()) {
            result = this.extractString("//*[local-name() = 'ApplicableSupplyChainTradeSettlement']/*[local-name() = 'PaymentReference']");
        }
        return result;
    }

    public String getZUGFeRDProfil() {
        switch (this.extractString("//*[local-name() = 'GuidelineSpecifiedDocumentContextParameter']//*[local-name() = 'ID']")) {
            case "urn:cen.eu:en16931:2017": 
            case "urn:ferd:CrossIndustryDocument:invoice:1p0:comfort": {
                return "COMFORT";
            }
            case "urn:cen.eu:en16931:2017#compliant#urn:factur-x.eu:1p0:basic": 
            case "urn:ferd:CrossIndustryDocument:invoice:1p0:basic": {
                return "BASIC";
            }
            case "urn:factur-x.eu:1p0:basicwl": {
                return "BASIC WL";
            }
            case "urn:factur-x.eu:1p0:minimum": {
                return "MINIMUM";
            }
            case "urn:ferd:CrossIndustryDocument:invoice:1p0:extended": 
            case "urn:cen.eu:en16931:2017#conformant#urn:factur-x.eu:1p0:extended": {
                return "EXTENDED";
            }
        }
        return "";
    }

    public String getInvoiceCurrencyCode() {
        try {
            if (this.getVersion() == 1) {
                return this.extractString("//*[local-name() = 'ApplicableSupplyChainTradeSettlement']//*[local-name() = 'InvoiceCurrencyCode']");
            }
            return this.extractString("//*[local-name() = 'ApplicableHeaderTradeSettlement']//*[local-name() = 'InvoiceCurrencyCode']");
        }
        catch (Exception e) {
            Logger.getLogger(ZUGFeRDImporter.class.getName()).log(Level.SEVERE, null, e);
            return "";
        }
    }

    public String getIssuerAssignedID() {
        return this.extractIssuerAssignedID("BuyerOrderReferencedDocument");
    }

    public String getSellerOrderReferencedDocumentIssuerAssignedID() {
        return this.extractIssuerAssignedID("SellerOrderReferencedDocument");
    }

    public String getContractOrderReferencedDocumentIssuerAssignedID() {
        return this.extractIssuerAssignedID("ContractReferencedDocument");
    }

    private String extractIssuerAssignedID(String propertyName) {
        try {
            if (this.getVersion() == 1) {
                return this.extractString("//*[local-name() = '" + propertyName + "']//*[local-name() = 'ID']");
            }
            return this.extractString("//*[local-name() = '" + propertyName + "']//*[local-name() = 'IssuerAssignedID']");
        }
        catch (Exception e) {
            Logger.getLogger(ZUGFeRDImporter.class.getName()).log(Level.SEVERE, null, e);
            return "";
        }
    }

    public String getBuyerTradePartyID() {
        return this.extractString("//*[local-name() = 'BuyerTradeParty']//*[local-name() = 'ID']");
    }

    public String getIssueDate() {
        try {
            if (this.getVersion() == 1) {
                return this.extractString("//*[local-name() = 'HeaderExchangedDocument']//*[local-name() = 'IssueDateTime']//*[local-name() = 'DateTimeString']");
            }
            return this.extractString("//*[local-name() = 'ExchangedDocument']//*[local-name() = 'IssueDateTime']//*[local-name() = 'DateTimeString']");
        }
        catch (Exception e) {
            Logger.getLogger(ZUGFeRDImporter.class.getName()).log(Level.SEVERE, null, e);
            return "";
        }
    }

    public Date getDetailedDeliveryPeriodFrom() {
        String toParse = this.extractString("//*[local-name() = 'ApplicableHeaderTradeSettlement']//*[local-name() = 'BillingSpecifiedPeriod']//*[local-name() = 'StartDateTime']//*[local-name() = 'DateTimeString']");
        return ZUGFeRDImporter.tryDate(toParse);
    }

    public Date getDetailedDeliveryPeriodTo() {
        String toParse = this.extractString("//*[local-name() = 'ApplicableHeaderTradeSettlement']//*[local-name() = 'BillingSpecifiedPeriod']//*[local-name() = 'EndDateTime']//*[local-name() = 'DateTimeString']");
        return ZUGFeRDImporter.tryDate(toParse);
    }

    public String getTaxBasisTotalAmount() {
        try {
            if (this.getVersion() == 1) {
                return this.extractString("//*[local-name() = 'SpecifiedTradeSettlementMonetarySummation']//*[local-name() = 'TaxBasisTotalAmount']");
            }
            return this.extractString("//*[local-name() = 'SpecifiedTradeSettlementHeaderMonetarySummation']//*[local-name() = 'TaxBasisTotalAmount']");
        }
        catch (Exception e) {
            Logger.getLogger(ZUGFeRDImporter.class.getName()).log(Level.SEVERE, null, e);
            return "";
        }
    }

    public String getTaxTotalAmount() {
        try {
            if (this.getVersion() == 1) {
                return this.extractString("//*[local-name() = 'SpecifiedTradeSettlementMonetarySummation']//*[local-name() = 'TaxTotalAmount']");
            }
            return this.extractString("//*[local-name() = 'SpecifiedTradeSettlementHeaderMonetarySummation']//*[local-name() = 'TaxTotalAmount']");
        }
        catch (Exception e) {
            Logger.getLogger(ZUGFeRDImporter.class.getName()).log(Level.SEVERE, null, e);
            return "";
        }
    }

    public String getRoundingAmount() {
        try {
            if (this.getVersion() == 1) {
                return this.extractString("//*[local-name() = 'SpecifiedTradeSettlementMonetarySummation']//*[local-name() = 'RoundingAmount']");
            }
            return this.extractString("//*[local-name() = 'SpecifiedTradeSettlementHeaderMonetarySummation']//*[local-name() = 'RoundingAmount']");
        }
        catch (Exception e) {
            Logger.getLogger(ZUGFeRDImporter.class.getName()).log(Level.SEVERE, null, e);
            return "";
        }
    }

    public String getPaidAmount() {
        try {
            if (this.getVersion() == 1) {
                return this.extractString("//*[local-name() = 'SpecifiedTradeSettlementMonetarySummation']//*[local-name() = 'TotalPrepaidAmount']");
            }
            return this.extractString("//*[local-name() = 'SpecifiedTradeSettlementHeaderMonetarySummation']//*[local-name() = 'TotalPrepaidAmount']");
        }
        catch (Exception e) {
            Logger.getLogger(ZUGFeRDImporter.class.getName()).log(Level.SEVERE, null, e);
            return "";
        }
    }

    public String getSellerTradePartyGlobalID() {
        return this.extractString("//*[local-name() = 'SellerTradeParty']//*[local-name() = 'GlobalID']");
    }

    public String getBuyerTradePartyGlobalID() {
        return this.extractString("//*[local-name() = 'BuyerTradeParty']//*[local-name() = 'GlobalID']");
    }

    public String getBuyertradePartySpecifiedTaxRegistrationID() {
        return this.extractString("//*[local-name() = 'BuyerTradeParty']//*[local-name() = 'SpecifiedTaxRegistration']//*[local-name() = 'ID']");
    }

    public String getIncludedNote() {
        try {
            if (this.getVersion() == 1) {
                return this.extractString("//*[local-name() = 'HeaderExchangedDocument']//*[local-name() = 'IncludedNote']");
            }
            return this.extractString("//*[local-name() = 'ExchangedDocument']//*[local-name() = 'IncludedNote']");
        }
        catch (Exception e) {
            Logger.getLogger(ZUGFeRDImporter.class.getName()).log(Level.SEVERE, null, e);
            return "";
        }
    }

    public String getBuyerTradePartyName() {
        return this.extractString("//*[local-name() = 'BuyerTradeParty']//*[local-name() = 'Name']");
    }

    public String getDeliveryTradePartyName() {
        return this.extractString("//*[local-name() = 'ShipToTradeParty']//*[local-name() = 'Name']");
    }

    public String getLineTotalAmount() {
        try {
            if (this.getVersion() == 1) {
                return this.extractString("//*[local-name() = 'SpecifiedTradeSettlementMonetarySummation']//*[local-name() = 'LineTotalAmount']");
            }
            return this.extractString("//*[local-name() = 'SpecifiedTradeSettlementHeaderMonetarySummation']//*[local-name() = 'LineTotalAmount']");
        }
        catch (Exception e) {
            Logger.getLogger(ZUGFeRDImporter.class.getName()).log(Level.SEVERE, null, e);
            return "";
        }
    }

    public String getPaymentTerms() {
        return this.extractString("//*[local-name() = 'SpecifiedTradePaymentTerms']//*[local-name() = 'Description']");
    }

    public String getTaxPointDate() {
        try {
            if (this.getVersion() == 1) {
                return this.extractString("//*[local-name() = 'ActualDeliverySupplyChainEvent']//*[local-name() = 'OccurrenceDateTime']//*[local-name() = 'DateTimeString']");
            }
            return this.extractString("//*[local-name() = 'ActualDeliverySupplyChainEvent']//*[local-name() = 'OccurrenceDateTime']//*[local-name() = 'DateTimeString']");
        }
        catch (Exception e) {
            Logger.getLogger(ZUGFeRDImporter.class.getName()).log(Level.SEVERE, null, e);
            return "";
        }
    }

    public String getInvoiceID() {
        try {
            if (this.getVersion() == 1) {
                return this.extractString("//*[local-name() = 'HeaderExchangedDocument']//*[local-name() = 'ID']");
            }
            return this.extractString("//*[local-name() = 'ExchangedDocument']//*[local-name() = 'ID']");
        }
        catch (Exception e) {
            Logger.getLogger(ZUGFeRDImporter.class.getName()).log(Level.SEVERE, null, e);
            return "";
        }
    }

    public String getDocumentCode() {
        try {
            if (this.getVersion() == 1) {
                return this.extractString("//*[local-name() = 'HeaderExchangedDocument']/*[local-name() = 'TypeCode']");
            }
            return this.extractString("//*[local-name() = 'ExchangedDocument']/*[local-name() = 'TypeCode']");
        }
        catch (Exception e) {
            Logger.getLogger(ZUGFeRDImporter.class.getName()).log(Level.SEVERE, null, e);
            return "";
        }
    }

    public String getReference() {
        try {
            if (this.getVersion() == 1) {
                return this.extractString("//*[local-name() = 'ApplicableSupplyChainTradeAgreement']/*[local-name() = 'BuyerReference']");
            }
            return this.extractString("//*[local-name() = 'ApplicableHeaderTradeAgreement']/*[local-name() = 'BuyerReference']");
        }
        catch (Exception e) {
            Logger.getLogger(ZUGFeRDImporter.class.getName()).log(Level.SEVERE, null, e);
            return "";
        }
    }

    public String getBIC() {
        return this.extractString("//*[local-name() = 'PayeeSpecifiedCreditorFinancialInstitution']/*[local-name() = 'BICID']");
    }

    public String getBankName() {
        return this.extractString("//*[local-name() = 'PayeeSpecifiedCreditorFinancialInstitution']/*[local-name() = 'Name']");
    }

    public String getIBAN() {
        return this.extractString("//*[local-name() = 'PayeePartyCreditorFinancialAccount']/*[local-name() = 'IBANID']");
    }

    public String getHolder() {
        return this.extractString("//*[local-name() = 'SellerTradeParty']/*[local-name() = 'Name']");
    }

    public String getAmount() {
        String result = this.extractString("//*[local-name() = 'SpecifiedTradeSettlementHeaderMonetarySummation']/*[local-name() = 'DuePayableAmount']");
        if (result == null || result.isEmpty()) {
            result = this.extractString("//*[local-name() = 'GrandTotalAmount']");
        }
        return result;
    }

    public String getDueDate() {
        return this.extractString("//*[local-name() = 'SpecifiedTradePaymentTerms']/*[local-name() = 'DueDateDateTime']/*[local-name() = 'DateTimeString']");
    }

    public HashMap<String, byte[]> getAdditionalData() {
        return this.additionalXMLs;
    }

    public String getXMP() {
        return this.xmpString;
    }

    public boolean containsMeta() {
        return this.containsMeta;
    }

    public void setMeta(String meta) throws IOException {
        this.setRawXML(meta.getBytes());
    }

    public String getMeta() {
        if (this.rawXML == null) {
            return null;
        }
        return new String(this.rawXML);
    }

    public EStandard getStandard() throws Exception {
        if (!this.containsMeta) {
            throw new Exception("Not yet parsed");
        }
        String head = this.getUTF8();
        if (head.contains("<rsm:CrossIndustryDocument")) {
            return EStandard.zugferd;
        }
        if (head.contains("<CrossIndustryDocument")) {
            return EStandard.zugferd;
        }
        if (head.contains("<urn:rsm:CrossIndustryInvoice") || head.contains("<rsm:CrossIndustryInvoice")) {
            return EStandard.facturx;
        }
        if (head.contains("<SCRDMCCBDACIDAMessageStructure")) {
            return EStandard.despatchadvice;
        }
        if (head.contains("<rsm:SCRDMCCBDACIOMessageStructure")) {
            return EStandard.orderx;
        }
        throw new Exception("ZUGFeRD version could not be determined");
    }

    public int getVersion() throws Exception {
        if (!this.containsMeta) {
            throw new Exception("Not yet parsed");
        }
        if (this.version != null) {
            return this.version;
        }
        String head = this.getUTF8();
        if (head.contains("<rsm:CrossIndustryDocument") || head.contains("<CrossIndustryDocument") || head.contains("<SCRDMCCBDACIDAMessageStructure") || head.contains("<rsm:SCRDMCCBDACIOMessageStructure")) {
            this.version = 1;
        } else if (head.contains("<rsm:CrossIndustryInvoice")) {
            this.version = 2;
        } else {
            throw new Exception("ZUGFeRD version could not be determined");
        }
        return this.version;
    }

    public String getUTF8() {
        byte[] bomlessData;
        if (this.rawXML == null) {
            return null;
        }
        if (this.rawXML.length < 3) {
            return new String(this.rawXML);
        }
        if (this.rawXML[0] == -17 && this.rawXML[1] == -69 && this.rawXML[2] == -65) {
            bomlessData = new byte[this.rawXML.length - 3];
            System.arraycopy(this.rawXML, 3, bomlessData, 0, this.rawXML.length - 3);
        } else {
            bomlessData = this.rawXML;
        }
        return new String(bomlessData);
    }

    public byte[] getRawXML() {
        return this.rawXML;
    }

    public boolean canParse() {
        String meta = this.getMeta();
        return meta != null && meta.length() > 0 && (meta.contains("SpecifiedExchangedDocumentContext") || meta.contains("ExchangedDocumentContext"));
    }

    static String convertStreamToString(InputStream is) {
        Scanner s = new Scanner(is, "UTF-8").useDelimiter("\\A");
        return s.hasNext() ? s.next() : "";
    }

    public PostalTradeAddress getBuyerTradePartyAddress() {
        NodeList nl = null;
        try {
            nl = this.getVersion() == 1 ? this.getNodeListByPath("//*[local-name() = 'CrossIndustryDocument']//*[local-name() = 'SpecifiedSupplyChainTradeTransaction']/*[local-name() = 'ApplicableSupplyChainTradeAgreement']//*[local-name() = 'BuyerTradeParty']//*[local-name() = 'PostalTradeAddress']") : this.getNodeListByPath("//*[local-name() = 'CrossIndustryInvoice']//*[local-name() = 'SupplyChainTradeTransaction']//*[local-name() = 'ApplicableHeaderTradeAgreement']//*[local-name() = 'BuyerTradeParty']//*[local-name() = 'PostalTradeAddress']");
        }
        catch (Exception e) {
            Logger.getLogger(ZUGFeRDImporter.class.getName()).log(Level.SEVERE, null, e);
            return null;
        }
        return this.getAddressFromNodeList(nl);
    }

    public PostalTradeAddress getSellerTradePartyAddress() {
        NodeList nl = null;
        try {
            nl = this.getVersion() == 1 ? this.getNodeListByPath("//*[local-name() = 'CrossIndustryDocument']//*[local-name() = 'SpecifiedSupplyChainTradeTransaction']//*[local-name() = 'ApplicableSupplyChainTradeAgreement']//*[local-name() = 'SellerTradeParty']//*[local-name() = 'PostalTradeAddress']") : this.getNodeListByPath("//*[local-name() = 'CrossIndustryInvoice']//*[local-name() = 'SupplyChainTradeTransaction']//*[local-name() = 'ApplicableHeaderTradeAgreement']//*[local-name() = 'SellerTradeParty']//*[local-name() = 'PostalTradeAddress']");
        }
        catch (Exception e) {
            Logger.getLogger(ZUGFeRDImporter.class.getName()).log(Level.SEVERE, null, e);
            return null;
        }
        return this.getAddressFromNodeList(nl);
    }

    public PostalTradeAddress getDeliveryTradePartyAddress() {
        NodeList nl;
        try {
            nl = this.getVersion() == 1 ? this.getNodeListByPath("//*[local-name() = 'CrossIndustryDocument']//*[local-name() = 'SpecifiedSupplyChainTradeTransaction']//*[local-name() = 'ApplicableSupplyChainTradeDelivery']//*[local-name() = 'ShipToTradeParty']//*[local-name() = 'PostalTradeAddress']") : this.getNodeListByPath("//*[local-name() = 'CrossIndustryInvoice']//*[local-name() = 'SupplyChainTradeTransaction']//*[local-name() = 'ApplicableHeaderTradeDelivery']//*[local-name() = 'ShipToTradeParty']//*[local-name() = 'PostalTradeAddress']");
        }
        catch (Exception e) {
            Logger.getLogger(ZUGFeRDImporter.class.getName()).log(Level.SEVERE, null, e);
            return null;
        }
        return this.getAddressFromNodeList(nl);
    }

    private PostalTradeAddress getAddressFromNodeList(NodeList nl) {
        PostalTradeAddress address = new PostalTradeAddress();
        if (nl != null) {
            for (int i = 0; i < nl.getLength(); ++i) {
                Node n = nl.item(i);
                NodeList nodes = n.getChildNodes();
                block19: for (int j = 0; j < nodes.getLength(); ++j) {
                    n = nodes.item(j);
                    short nodeType = n.getNodeType();
                    if (nodeType != 1 || n.getLocalName() == null) continue;
                    switch (n.getLocalName()) {
                        case "PostcodeCode": {
                            address.setPostCodeCode("");
                            if (n.getFirstChild() == null) continue block19;
                            address.setPostCodeCode(n.getFirstChild().getNodeValue());
                            continue block19;
                        }
                        case "LineOne": {
                            address.setLineOne("");
                            if (n.getFirstChild() == null) continue block19;
                            address.setLineOne(n.getFirstChild().getNodeValue());
                            continue block19;
                        }
                        case "LineTwo": {
                            address.setLineTwo("");
                            if (n.getFirstChild() == null) continue block19;
                            address.setLineTwo(n.getFirstChild().getNodeValue());
                            continue block19;
                        }
                        case "LineThree": {
                            address.setLineThree("");
                            if (n.getFirstChild() == null) continue block19;
                            address.setLineThree(n.getFirstChild().getNodeValue());
                            continue block19;
                        }
                        case "CityName": {
                            address.setCityName("");
                            if (n.getFirstChild() == null) continue block19;
                            address.setCityName(n.getFirstChild().getNodeValue());
                            continue block19;
                        }
                        case "CountryID": {
                            address.setCountryID("");
                            if (n.getFirstChild() == null) continue block19;
                            address.setCountryID(n.getFirstChild().getNodeValue());
                            continue block19;
                        }
                        case "CountrySubDivisionName": {
                            address.setCountrySubDivisionName("");
                            if (n.getFirstChild() == null) continue block19;
                            address.setCountrySubDivisionName(n.getFirstChild().getNodeValue());
                        }
                    }
                }
            }
        }
        return address;
    }

    public List<Item> getLineItemList() {
        List<Node> nodeList = this.getLineItemNodes();
        ArrayList<Item> lineItemList = new ArrayList<Item>();
        for (Node n : nodeList) {
            Item lineItem = new Item(null, null, null);
            lineItem.setProduct(new Product(null, null, null, null));
            NodeList nl = n.getChildNodes();
            block19: for (int i = 0; i < nl.getLength(); ++i) {
                Node nn = nl.item(i);
                Node node = null;
                if (nn.getLocalName() == null) continue;
                switch (nn.getLocalName()) {
                    case "SpecifiedLineTradeAgreement": 
                    case "SpecifiedSupplyChainTradeAgreement": {
                        node = this.getNodeByName(nn.getChildNodes(), "NetPriceProductTradePrice");
                        if (node != null) {
                            Node unitCodeAttribute;
                            NodeList tradeAgreementChildren = node.getChildNodes();
                            node = this.getNodeByName(tradeAgreementChildren, "ChargeAmount");
                            lineItem.setPrice(this.tryBigDecimal(this.getNodeValue(node)));
                            node = this.getNodeByName(tradeAgreementChildren, "BasisQuantity");
                            if (node != null && node.getAttributes() != null && (unitCodeAttribute = node.getAttributes().getNamedItem("unitCode")) != null) {
                                lineItem.getProduct().setUnit(unitCodeAttribute.getNodeValue());
                            }
                        }
                        if ((node = this.getNodeByName(nn.getChildNodes(), "GrossPriceProductTradePrice")) == null) continue block19;
                        node = this.getNodeByName(node.getChildNodes(), "ChargeAmount");
                        lineItem.setGrossPrice(this.tryBigDecimal(this.getNodeValue(node)));
                        continue block19;
                    }
                    case "AssociatedDocumentLineDocument": {
                        node = this.getNodeByName(nn.getChildNodes(), "LineID");
                        lineItem.setId(this.getNodeValue(node));
                        continue block19;
                    }
                    case "SpecifiedTradeProduct": {
                        node = this.getNodeByName(nn.getChildNodes(), "SellerAssignedID");
                        lineItem.getProduct().setSellerAssignedID(this.getNodeValue(node));
                        node = this.getNodeByName(nn.getChildNodes(), "BuyerAssignedID");
                        lineItem.getProduct().setBuyerAssignedID(this.getNodeValue(node));
                        node = this.getNodeByName(nn.getChildNodes(), "Name");
                        lineItem.getProduct().setName(this.getNodeValue(node));
                        node = this.getNodeByName(nn.getChildNodes(), "Description");
                        lineItem.getProduct().setDescription(this.getNodeValue(node));
                        continue block19;
                    }
                    case "SpecifiedLineTradeDelivery": 
                    case "SpecifiedSupplyChainTradeDelivery": {
                        node = this.getNodeByName(nn.getChildNodes(), "BilledQuantity");
                        lineItem.setQuantity(this.tryBigDecimal(this.getNodeValue(node)));
                        continue block19;
                    }
                    case "SpecifiedLineTradeSettlement": {
                        node = this.getNodeByName(nn.getChildNodes(), "ApplicableTradeTax");
                        if (node != null) {
                            node = this.getNodeByName(node.getChildNodes(), "RateApplicablePercent");
                            lineItem.getProduct().setVATPercent(this.tryBigDecimal(this.getNodeValue(node)));
                        }
                        if ((node = this.getNodeByName(nn.getChildNodes(), "ApplicableTradeTax")) != null) {
                            node = this.getNodeByName(node.getChildNodes(), "CalculatedAmount");
                            lineItem.setTax(this.tryBigDecimal(this.getNodeValue(node)));
                        }
                        if ((node = this.getNodeByName(nn.getChildNodes(), "BillingSpecifiedPeriod")) != null) {
                            Node start = this.getNodeByName(node.getChildNodes(), "StartDateTime");
                            Node dateTimeStart = null;
                            if (start != null) {
                                dateTimeStart = this.getNodeByName(start.getChildNodes(), "DateTimeString");
                            }
                            Node end = this.getNodeByName(node.getChildNodes(), "EndDateTime");
                            Node dateTimeEnd = null;
                            if (end != null) {
                                dateTimeEnd = this.getNodeByName(end.getChildNodes(), "DateTimeString");
                            }
                            lineItem.setDetailedDeliveryPeriod(this.tryDate(dateTimeStart), this.tryDate(dateTimeEnd));
                        }
                        if ((node = this.getNodeByName(nn.getChildNodes(), "SpecifiedTradeSettlementLineMonetarySummation")) == null) continue block19;
                        node = this.getNodeByName(node.getChildNodes(), "LineTotalAmount");
                        lineItem.setLineTotalAmount(this.tryBigDecimal(this.getNodeValue(node)));
                        continue block19;
                    }
                    case "SpecifiedSupplyChainTradeSettlement": {
                        node = this.getNodeByName(nn.getChildNodes(), "ApplicableTradeTax");
                        if (node != null) {
                            node = this.getNodeByName(node.getChildNodes(), "ApplicablePercent");
                            lineItem.getProduct().setVATPercent(this.tryBigDecimal(this.getNodeValue(node)));
                        }
                        if ((node = this.getNodeByName(nn.getChildNodes(), "ApplicableTradeTax")) != null) {
                            node = this.getNodeByName(node.getChildNodes(), "CalculatedAmount");
                            lineItem.setTax(this.tryBigDecimal(this.getNodeValue(node)));
                        }
                        if ((node = this.getNodeByName(nn.getChildNodes(), "SpecifiedTradeSettlementMonetarySummation")) == null) continue block19;
                        node = this.getNodeByName(node.getChildNodes(), "LineTotalAmount");
                        lineItem.setLineTotalAmount(this.tryBigDecimal(this.getNodeValue(node)));
                    }
                }
            }
            lineItemList.add(lineItem);
        }
        return lineItemList;
    }

    public List<Node> getLineItemNodes() {
        ArrayList<Node> lineItemNodes = new ArrayList<Node>();
        NodeList nl = null;
        try {
            nl = this.getNodeListByPath("//*[local-name() = 'IncludedSupplyChainTradeLineItem']");
        }
        catch (Exception e) {
            Logger.getLogger(ZUGFeRDImporter.class.getName()).log(Level.SEVERE, null, e);
        }
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            lineItemNodes.add(n);
        }
        return lineItemNodes;
    }

    private Node getNodeByName(NodeList nl, String name) {
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node;
            if (nl.item(i).getLocalName() != null && nl.item(i).getLocalName().equals(name)) {
                return nl.item(i);
            }
            if (nl.item(i).getChildNodes().getLength() <= 0 || (node = this.getNodeByName(nl.item(i).getChildNodes(), name)) == null) continue;
            return node;
        }
        return null;
    }

    public NodeList getNodeListByPath(String path) {
        XPathFactory xpathFact = XPathFactory.newInstance();
        XPath xPath = xpathFact.newXPath();
        String s = path;
        try {
            XPathExpression xpr = xPath.compile(s);
            return (NodeList)xpr.evaluate(this.getDocument(), XPathConstants.NODESET);
        }
        catch (Exception e) {
            Logger.getLogger(ZUGFeRDImporter.class.getName()).log(Level.SEVERE, null, e);
            return null;
        }
    }

    private String getNodeValue(Node node) {
        if (node != null && node.getFirstChild() != null) {
            return node.getFirstChild().getNodeValue();
        }
        return "";
    }

    private BigDecimal tryBigDecimal(String nodeValue) {
        try {
            return new BigDecimal(nodeValue);
        }
        catch (Exception e) {
            try {
                return BigDecimal.valueOf(Float.valueOf(nodeValue).floatValue());
            }
            catch (Exception ex) {
                return new BigDecimal("0.00");
            }
        }
    }

    private Date tryDate(Node node) {
        String nodeValue = this.getNodeValue(node);
        if (nodeValue.isEmpty()) {
            return null;
        }
        return ZUGFeRDImporter.tryDate(nodeValue);
    }

    private static Date tryDate(String toParse) {
        SimpleDateFormat formatter = ZUGFeRDDateFormat.DATE.getFormatter();
        try {
            return formatter.parse(toParse);
        }
        catch (Exception e) {
            return null;
        }
    }
}

